/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.rm.CreateSequenceException;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.runtime.ProtocolCommunicator;
import com.sun.xml.ws.rm.runtime.Rm10ClientSession;
import com.sun.xml.ws.rm.runtime.Rm11ClientSession;
import com.sun.xml.ws.rm.runtime.ScheduledTaskManager;
import com.sun.xml.ws.rm.runtime.SequenceManager;
import com.sun.xml.ws.rm.runtime.SequenceManagerFactory;
import com.sun.xml.ws.rm.runtime.UnknownSequenceException;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

abstract class ClientSession {
    private static final RmLogger LOGGER = RmLogger.getLogger(ClientSession.class);
    private static final int MAX_INITIATE_SESSION_ATTEMPTS = 3;
    protected String inboundSequenceId = null;
    protected String outboundSequenceId = null;
    protected final SequenceManager sequenceManager;
    protected final ProtocolCommunicator communicator;
    protected final Configuration configuration;
    private final Lock initLock;
    private final ScheduledTaskManager scheduledTaskManager;
    private final Queue<FiberRegistration> fibersToResend = new LinkedList<FiberRegistration>();
    private final AtomicLong lastAckRequestedTime = new AtomicLong(0L);

    static ClientSession create(Configuration configuration, ProtocolCommunicator communicator) {
        switch (configuration.getRmVersion()) {
            case WSRM10: {
                return new Rm10ClientSession(configuration, communicator);
            }
            case WSRM11: {
                return new Rm11ClientSession(configuration, communicator);
            }
        }
        throw new IllegalStateException("Unsupported WS-ReliableMessaging version [ " + configuration.getRmVersion().namespaceUri + "]");
    }

    protected ClientSession(Configuration configuration, ProtocolCommunicator communicator) {
        this.initLock = new ReentrantLock();
        this.configuration = configuration;
        this.sequenceManager = SequenceManagerFactory.getInstance().getSequenceManager();
        this.communicator = communicator;
        this.scheduledTaskManager = new ScheduledTaskManager();
    }

    protected abstract void openRmSession(String var1, SecurityTokenReferenceType var2) throws RmException;

    protected abstract void appendSequenceHeader(Message var1) throws RmException;

    protected abstract void appendAckRequestedHeader(Message var1) throws RmException;

    protected abstract void appendSequenceAcknowledgementHeader(Message var1) throws RmException;

    protected abstract void processSequenceHeader(HeaderList var1) throws RmException;

    protected abstract void processAcknowledgementHeader(HeaderList var1) throws RmException;

    protected abstract void processAckRequestedHeader(HeaderList var1) throws RmException;

    protected abstract void closeOutboundSequence() throws RmException;

    protected abstract void terminateOutboundSequence() throws RmException;

    protected final void processInboundMessageHeaders(HeaderList responseHeaders, boolean expectSequenceHeader) throws RmException {
        if (responseHeaders != null) {
            if (expectSequenceHeader) {
                this.processSequenceHeader(responseHeaders);
            }
            this.processAcknowledgementHeader(responseHeaders);
            this.processAckRequestedHeader(responseHeaders);
        }
    }

    protected final void assertSequenceIdInInboundHeader(String expected, String actual) {
        if (expected != null && !expected.equals(actual)) {
            throw LOGGER.logSevereException(new IllegalStateException("Sequence id in the inbound message header [" + actual + " ] " + "does not match the sequence id bound to this session [" + expected + "]"));
        }
    }

    final Packet processOutgoingPacket(Packet requestPacket) throws RmException {
        this.initializeIfNecessary(requestPacket);
        this.appendSequenceHeader(requestPacket.getMessage());
        if (this.checkPendingAckRequest()) {
            this.appendAckRequestedHeader(requestPacket.getMessage());
            this.lastAckRequestedTime.set(System.currentTimeMillis());
        }
        if (this.inboundSequenceId != null) {
            this.appendSequenceAcknowledgementHeader(requestPacket.getMessage());
        }
        return requestPacket;
    }

    final Packet processIncommingPacket(Packet responsePacket, boolean responseToOneWayRequest) throws RmException {
        Message responseMessage = responsePacket.getMessage();
        if (responseMessage != null) {
            this.processInboundMessageHeaders(responseMessage.getHeaders(), !responseToOneWayRequest && !this.isProtocolMessage(responseMessage));
        }
        return responsePacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean registerForResend(Fiber fiber, Packet packet) {
        Queue<FiberRegistration> queue = this.fibersToResend;
        synchronized (queue) {
            return this.fibersToResend.offer(new FiberRegistration(fiber, packet));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        try {
            try {
                this.closeOutboundSequence();
            }
            catch (RmException ex) {
                LOGGER.logException(ex, Level.WARNING);
            }
            finally {
                try {
                    this.sequenceManager.closeSequence(this.outboundSequenceId);
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.logException(ex, Level.WARNING);
                }
            }
            try {
                this.waitUntilAllRequestsAckedOrTimeout();
                this.terminateOutboundSequence();
            }
            catch (RmException ex) {
                LOGGER.logException(ex, Level.WARNING);
            }
            finally {
                try {
                    this.sequenceManager.terminateSequence(this.outboundSequenceId);
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.logException(ex, Level.WARNING);
                }
            }
            if (this.inboundSequenceId != null && this.sequenceManager.isValid(this.inboundSequenceId)) {
                try {
                    if (!this.sequenceManager.getSequence(this.inboundSequenceId).isClosed()) {
                        this.sequenceManager.closeSequence(this.inboundSequenceId);
                    }
                    this.sequenceManager.terminateSequence(this.inboundSequenceId);
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.logException(ex, Level.WARNING);
                }
            }
        }
        finally {
            this.scheduledTaskManager.stopAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNecessary(Packet requestPacket) throws CreateSequenceException, RmException {
        this.initLock.lock();
        try {
            if (!this.isInitialized()) {
                this.communicator.registerMusterRequestPacket(requestPacket.copy(false));
                int numberOfInitiateSessionAttempts = 0;
                while (true) {
                    try {
                        this.openRmSession(this.configuration.requestResponseOperationsDetected() ? this.sequenceManager.generateSequenceUID() : null, this.communicator.tryStartSecureConversation());
                    }
                    catch (RuntimeException ex) {
                        LOGGER.warning("Attempt to initiate RM session failed with an exception", ex);
                    }
                    finally {
                        if (++numberOfInitiateSessionAttempts <= 3) continue;
                        throw LOGGER.logSevereException(new CreateSequenceException("Unable to initiate RM Session: Maximum attempts to initiate RM session reached"));
                    }
                    break;
                }
                this.scheduledTaskManager.startTasks(new Runnable(){

                    public void run() {
                        ClientSession.this.resend();
                    }
                }, new Runnable(){

                    public void run() {
                        ClientSession.this.sendAckRequested();
                    }
                });
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    private boolean isInitialized() {
        return this.outboundSequenceId != null;
    }

    private boolean isProtocolMessage(@NotNull Message responseMessage) {
        HeaderList headers = responseMessage.getHeaders();
        return headers != null && this.configuration.getRmVersion().isRMAction(headers.getAction(this.configuration.getAddressingVersion(), this.configuration.getSoapVersion()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resend() {
        while (!this.fibersToResend.isEmpty() && this.fibersToResend.peek().expired(this.configuration.getMessageRetransmissionInterval())) {
            FiberRegistration registration;
            Queue<FiberRegistration> queue = this.fibersToResend;
            synchronized (queue) {
                registration = this.fibersToResend.poll();
            }
            registration.fiber.resume(registration.packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAckRequested() {
        Message ackResponse = null;
        try {
            if (this.checkPendingAckRequest()) {
                Message ackRequestMessage = this.communicator.createEmptyMessage();
                this.appendAckRequestedHeader(ackRequestMessage);
                this.lastAckRequestedTime.set(System.currentTimeMillis());
                ackResponse = this.communicator.send(ackRequestMessage, this.configuration.getRmVersion().ackRequestedAction);
                if (ackResponse == null) {
                    throw new RmException("Response for the acknowledgement request is 'null'");
                }
                this.processInboundMessageHeaders(ackResponse.getHeaders(), false);
                if (ackResponse.isFault()) {
                    throw new RmException("Acknowledgement request ended in a SOAP fault", ackResponse);
                }
            }
        }
        catch (RmException ex) {
            LOGGER.warning("Acknowledgement request failed", ex);
        }
        finally {
            if (ackResponse != null) {
                ackResponse.consume();
            }
        }
    }

    private boolean checkPendingAckRequest() throws UnknownSequenceException {
        return this.lastAckRequestedTime.get() - System.currentTimeMillis() > this.configuration.getAcknowledgementRequestInterval() && this.sequenceManager.getSequence(this.outboundSequenceId).hasPendingAcknowledgements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilAllRequestsAckedOrTimeout() {
        final CountDownLatch doneSignal = new CountDownLatch(1);
        ScheduledFuture<?> taskHandle = this.scheduledTaskManager.startTask(new Runnable(){

            public void run() {
                try {
                    if (!ClientSession.this.sequenceManager.getSequence(ClientSession.this.outboundSequenceId).hasPendingAcknowledgements()) {
                        doneSignal.countDown();
                    }
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.severe("Unexpected exception occured while waiting for sequence acknowledgements", ex);
                    doneSignal.countDown();
                }
            }
        });
        try {
            if (this.configuration.getCloseSequenceOperationTimeout() > 0L) {
                boolean waitResult = doneSignal.await(this.configuration.getCloseSequenceOperationTimeout(), TimeUnit.MILLISECONDS);
                if (!waitResult) {
                    LOGGER.info("Close sequence operation timed out for outbound sequence [" + this.outboundSequenceId + "]");
                }
            } else {
                doneSignal.await();
            }
        }
        catch (InterruptedException ex) {
            LOGGER.fine("Got interrupted while waiting for close sequence operation", ex);
        }
        finally {
            taskHandle.cancel(true);
        }
    }

    private static class FiberRegistration {
        private final long timestamp = System.currentTimeMillis();
        final Fiber fiber;
        final Packet packet;

        FiberRegistration(Fiber fiber, Packet packet) {
            this.fiber = fiber;
            this.packet = packet;
        }

        boolean expired(long period) {
            return System.currentTimeMillis() - this.timestamp >= period;
        }
    }
}

