/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.policy.assertion;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.ComplexAssertion;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.spi.AssertionCreationException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.policy.assertion.RmAssertionInstantiator;
import java.util.Collection;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryAssuranceAssertion
extends ComplexAssertion {
    private static final RmLogger LOGGER = RmLogger.getLogger(DeliveryAssuranceAssertion.class);
    private static final QName EXACTLY_ONCE_QNAME = new QName(RmVersion.WSRM11.policyNamespaceUri, "ExactlyOnce");
    private static final QName AT_LEAST_ONCE_QNAME = new QName(RmVersion.WSRM11.policyNamespaceUri, "AtLeastOnce");
    private static final QName AT_MOST_ONCE_QNAME = new QName(RmVersion.WSRM11.policyNamespaceUri, "AtMostOnce");
    private static final QName IN_ORDER_QNAME = new QName(RmVersion.WSRM11.policyNamespaceUri, "InOrder");
    public static final QName NAME = new QName(RmVersion.WSRM11.policyNamespaceUri, "DeliveryAssurance");
    private static RmAssertionInstantiator instantiator = new RmAssertionInstantiator(){

        @Override
        public PolicyAssertion newInstance(AssertionData data, Collection<PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
            return new DeliveryAssuranceAssertion(data, assertionParameters, nestedAlternative);
        }
    };
    private final Configuration.DeliveryAssurance deliveryAssurance;
    private final boolean orderedDelivery;

    public static RmAssertionInstantiator getInstantiator() {
        return instantiator;
    }

    private DeliveryAssuranceAssertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
        super(data, assertionParameters, nestedAlternative);
        Configuration.DeliveryAssurance _deliveryAssurance = null;
        boolean _orderedDelivery = false;
        if (nestedAlternative != null) {
            for (PolicyAssertion nestedAssertion : nestedAlternative) {
                if (EXACTLY_ONCE_QNAME.equals(nestedAssertion.getName())) {
                    _deliveryAssurance = this.evaluateDeliveryAssurance(_deliveryAssurance == null, Configuration.DeliveryAssurance.EXACTLY_ONCE, data);
                    continue;
                }
                if (AT_LEAST_ONCE_QNAME.equals(nestedAssertion.getName())) {
                    _deliveryAssurance = this.evaluateDeliveryAssurance(_deliveryAssurance == null, Configuration.DeliveryAssurance.AT_LEAST_ONCE, data);
                    continue;
                }
                if (AT_MOST_ONCE_QNAME.equals(nestedAssertion.getName())) {
                    _deliveryAssurance = this.evaluateDeliveryAssurance(_deliveryAssurance == null, Configuration.DeliveryAssurance.AT_MOST_ONCE, data);
                    continue;
                }
                if (!IN_ORDER_QNAME.equals(nestedAssertion.getName())) continue;
                _orderedDelivery = true;
            }
        }
        this.deliveryAssurance = _deliveryAssurance == null ? Configuration.DeliveryAssurance.EXACTLY_ONCE : _deliveryAssurance;
        this.orderedDelivery = _orderedDelivery;
    }

    public Configuration.DeliveryAssurance getDeliveryAssurance() {
        return this.deliveryAssurance;
    }

    public boolean isOrderedDelivery() {
        return this.orderedDelivery;
    }

    private Configuration.DeliveryAssurance evaluateDeliveryAssurance(boolean successCondition, Configuration.DeliveryAssurance daOnSuccess, AssertionData data) throws AssertionCreationException {
        if (successCondition) {
            return daOnSuccess;
        }
        throw LOGGER.logSevereException(new AssertionCreationException(data, "Inconsistent RM policy: Multiple delivery assurance types specified."));
    }
}

