/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.server;

import com.sun.xml.ws.api.rm.SequenceSettings;
import com.sun.xml.ws.api.rm.server.ServerSequence;
import com.sun.xml.ws.rm.InvalidMessageNumberException;
import com.sun.xml.ws.rm.RMMessage;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.runtime.server.ServerOutboundSequence;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.runtime.util.Session;
import java.util.UUID;

public class ServerInboundSequence
extends InboundSequence
implements ServerSequence {
    private static final RmLogger LOGGER = RmLogger.getLogger(ServerInboundSequence.class);
    private Session session;

    public ServerInboundSequence(String inboundId, String outboundId, SequenceConfig config) {
        super(config, true);
        this.setId(inboundId != null ? inboundId : "uuid:" + UUID.randomUUID());
        this.setCompanionSequence(new ServerOutboundSequence(this, outboundId, config));
    }

    public RMMessage getOriginalMessage(RMMessage duplicate) throws InvalidMessageNumberException {
        int number = duplicate.getMessageNumber();
        return this.get(number);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session s) {
        this.session = s;
    }

    public boolean isDeliverable(RMMessage message) {
        if (!this.getConfig().isOrdered()) {
            return true;
        }
        if (message.getMessageNumber() > 1) {
            RMMessage mess = null;
            try {
                mess = this.get(message.getMessageNumber() - 1);
            }
            catch (InvalidMessageNumberException e) {
                LOGGER.severe("Error retrieving the message with number [" + message.getMessageNumber() + "]", e);
            }
            if (mess == null || !mess.isComplete()) {
                return false;
            }
        }
        return true;
    }

    public SequenceSettings getSequenceSettings() {
        SequenceConfig settings = this.getConfig();
        settings.setSequenceId(this.getId());
        OutboundSequence oseq = this.getOutboundSequence();
        settings.setCompanionSequenceId(oseq != null ? oseq.getId() : null);
        return settings;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.getLastActivityTime() > this.getConfig().getInactivityTimeout();
    }

    public boolean isOrdered() {
        return this.getConfig().isOrdered();
    }

    public void releaseNextMessage(RMMessage message) throws RmException {
        message.complete();
        this.decreaseStoredMessages();
        int num = message.getMessageNumber() + 1;
        if (num < this.getNextIndex() && this.get(num) != null) {
            LOGGER.finest("Resuming " + num + " message");
            this.get(num).resume();
        }
    }
}

