/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm;

import com.sun.xml.ws.rm.BufferFullException;
import com.sun.xml.ws.rm.DuplicateMessageException;
import com.sun.xml.ws.rm.InvalidMessageNumberException;
import com.sun.xml.ws.rm.RMMessage;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import java.util.ArrayList;
import java.util.List;

public class Sequence {
    private boolean closed;
    private SequenceConfig config;
    private String id;
    private boolean last = false;
    private long lastActivityTime;
    private int maxMessages = -1;
    private int nextIndex = 1;
    private List<RMMessage> rmMessages;
    private int storedMessages = 0;

    public Sequence(SequenceConfig config) {
        this.config = config;
        this.rmMessages = new ArrayList<RMMessage>();
        this.rmMessages.add(null);
        this.resetLastActivityTime();
    }

    public Sequence(SequenceConfig config, boolean setMaxMessages) {
        this(config);
        if (setMaxMessages && config.isFlowControlRequired() && !config.isOrdered()) {
            this.maxMessages = config.getBufferSize();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public synchronized int getNextIndex() {
        return this.nextIndex;
    }

    public synchronized RMMessage get(int index) throws InvalidMessageNumberException {
        if (index >= this.nextIndex) {
            throw new InvalidMessageNumberException(LocalizationMessages.WSRM_1000_INVALID_INDEX_MESSAGE(index));
        }
        return this.rmMessages.get(index);
    }

    public synchronized int set(int index, RMMessage rmMessage) throws InvalidMessageNumberException, BufferFullException, DuplicateMessageException {
        rmMessage.setMessageNumber(index);
        rmMessage.setSequence(this);
        if (index <= 0) {
            throw new InvalidMessageNumberException("Invalid message index [" + index + "]");
        }
        if (this.storedMessages == this.maxMessages) {
            throw new BufferFullException(this);
        }
        if (index < this.nextIndex) {
            RMMessage mess = null;
            mess = this.rmMessages.get(index);
            if (null != mess && !this.config.isAllowDuplicatesEnabled()) {
                throw new DuplicateMessageException("Duplicate message detected in sequence [" + this.getId() + "] at message index [" + index + "]", mess);
            }
            this.rmMessages.set(index, rmMessage);
        } else if (index == this.nextIndex) {
            this.rmMessages.add(rmMessage);
            ++this.nextIndex;
        } else {
            for (int j = this.nextIndex; j < index; ++j) {
                this.rmMessages.add(null);
            }
            this.rmMessages.add(rmMessage);
            this.nextIndex = index + 1;
        }
        ++this.storedMessages;
        return index;
    }

    public synchronized void setLast() {
        this.last = true;
    }

    public synchronized void setClosed() {
        this.closed = true;
    }

    public synchronized boolean isLast() {
        return this.last;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public void resetLastActivityTime() {
        this.lastActivityTime = System.currentTimeMillis();
    }

    protected long getLastActivityTime() {
        return this.lastActivityTime;
    }

    protected boolean isGettingClose(long elapsedTime, long timeLimit) {
        return elapsedTime > timeLimit / 2L;
    }

    protected SequenceConfig getConfig() {
        return this.config;
    }

    protected int getMaxMessages() {
        return this.maxMessages;
    }

    protected int getStoredMessages() {
        return this.storedMessages;
    }

    protected void decreaseStoredMessages() {
        --this.storedMessages;
    }
}

