/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.assembler;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.client.WSPortInfo;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Codecs;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.assembler.ActionDumpTubeAppender;
import com.sun.xml.ws.assembler.ClientPipelineHook;
import com.sun.xml.ws.assembler.MessageDumpingFeature;
import com.sun.xml.ws.assembler.ServerPipelineHook;
import com.sun.xml.ws.assembler.TubeAppender;
import com.sun.xml.ws.assembler.TubelineAssemblyContextUpdater;
import com.sun.xml.ws.assembler.WsitClientTubeAssemblyContext;
import com.sun.xml.ws.assembler.WsitServerTubeAssemblyContext;
import com.sun.xml.ws.encoding.LazyStreamCodec;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.rm.runtime.RmTubeAppender;
import com.sun.xml.ws.rm.runtime.testing.PacketFilteringTubeAppender;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.transport.tcp.wsit.TCPConstants;
import com.sun.xml.ws.transport.tcp.wsit.TCPTransportPipeFactory;
import com.sun.xml.ws.tx.client.TxClientPipe;
import com.sun.xml.ws.tx.common.Util;
import com.sun.xml.ws.tx.service.TxServerPipe;
import com.sun.xml.ws.util.ServiceConfigurationError;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.jaxws.impl.SecurityClientPipe;
import com.sun.xml.wss.jaxws.impl.SecurityServerPipe;
import com.sun.xml.xwss.XWSSClientPipe;
import com.sun.xml.xwss.XWSSServerPipe;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TubelineAssemblyController {
    private static final String BEFORE_SUFFIX = ".before";
    private static final String AFTER_SUFFIX = ".after";
    private static final String TRANSPORT_SUFFIX = ".transport";
    private static final String WSS_SUFFIX = ".wss";
    private static final String WSA_SUFFIX = ".wsa";
    private static final String WSRM_SUFFIX = ".wsrm";
    private static final String WSTX_SUFFIX = ".wstx";
    private static final TubeAppender transportAppender = new TransportTubeAppender();
    private static final TubeAppender messageDumpingAppender = new MessageDumpingTubeAppender();
    private static final TubeAppender packetFilteringAppender = new PacketFilteringTubeAppender();
    private static final TubeAppender actionDumpAppender = new ActionDumpTubeAppender();
    private static final TubeAppender securityAppender = new SecurityTubeAppender();
    private static final TubeAppender reliableMessagingAppender = new RmTubeAppender();
    private static final TubeAppender transactionsAppender = new TxTubeAppender();
    private static final TubeAppender addressingAppender = new AddressingTubeAppender();
    private static final TubeAppender monitoringAppender = new MonitoringTubeAppender();
    private static final TubeAppender mustUnderstandAppender = new MustUnderstandTubeAppender();
    private static final TubeAppender validationAppender = new ValidationTubeAppender();
    private static final TubeAppender handlerAppender = new HandlerTubeAppender();
    private static final TubeAppender terminalAppender = new TerminalTubeAppender();
    private static final TubeAppender[] clientAppenders = new TubeAppender[]{transportAppender, messageDumpingAppender, packetFilteringAppender, new DumpTubeAppender(""), actionDumpAppender, new DumpTubeAppender(".transport"), new DumpTubeAppender(".wss.after"), securityAppender, new DumpTubeAppender(".wss.before"), new DumpTubeAppender(".wsrm.after"), reliableMessagingAppender, new DumpTubeAppender(".wsrm.before"), new DumpTubeAppender(".wstx.after"), transactionsAppender, new DumpTubeAppender(".wstx.before"), new DumpTubeAppender(".wsa.after"), addressingAppender, new DumpTubeAppender(".wsa.before"), monitoringAppender, mustUnderstandAppender, validationAppender, handlerAppender};
    private static final TubeAppender[] serverAppenders = new TubeAppender[]{terminalAppender, validationAppender, handlerAppender, mustUnderstandAppender, monitoringAppender, new DumpTubeAppender(".wstx.after"), transactionsAppender, new DumpTubeAppender(".wstx.before"), new DumpTubeAppender(".wsrm.after"), reliableMessagingAppender, new DumpTubeAppender(".wsrm.before"), new DumpTubeAppender(".wsa.after"), addressingAppender, new DumpTubeAppender(".wsa.before"), new DumpTubeAppender(".wss.after"), securityAppender, new DumpTubeAppender(".wss.before"), new DumpTubeAppender(".transport"), actionDumpAppender, new DumpTubeAppender(""), packetFilteringAppender, messageDumpingAppender};

    Collection<TubeAppender> getClientSideAppenders() {
        return Arrays.asList(clientAppenders);
    }

    Collection<TubeAppender> getServerSideAppenders() {
        return Arrays.asList(serverAppenders);
    }

    public static class TerminalTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            return context.getTubelineHead();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().getTerminalTube();
        }
    }

    public static class HandlerTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createHandlerTube(context.getTubelineHead());
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createHandlerTube(context.getTubelineHead());
        }
    }

    public static class ValidationTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createValidationTube(context.getTubelineHead());
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createValidationTube(context.getTubelineHead());
        }
    }

    public static class MustUnderstandTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createClientMUTube(context.getTubelineHead());
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createServerMUTube(context.getTubelineHead());
        }
    }

    public static class MonitoringTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            return context.getTubelineHead();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createMonitoringTube(context.getTubelineHead());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SecurityTubeAppender
    implements TubeAppender,
    TubelineAssemblyContextUpdater {
        private static final String SERVLET_CONTEXT_CLASSNAME = "javax.servlet.ServletContext";
        private static final String ENDPOINT = "ENDPOINT";
        private static final String NEXT_PIPE = "NEXT_PIPE";
        private static final String POLICY = "POLICY";
        private static final String SEI_MODEL = "SEI_MODEL";
        private static final String WSDL_MODEL = "WSDL_MODEL";
        private static final String GF_SERVER_SEC_PIPE = "com.sun.enterprise.webservice.CommonServerSecurityPipe";

        @Override
        public void prepareContext(WsitClientTubeAssemblyContext context) throws WebServiceException {
            if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
                context.setCodec(this.createSecurityCodec(context.getBinding()));
            }
        }

        @Override
        public void prepareContext(WsitServerTubeAssemblyContext context) throws WebServiceException {
            if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
                context.setCodec(this.createSecurityCodec(context.getEndpoint().getBinding()));
            }
        }

        @Override
        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            ServerPipelineHook hook = context.getEndpoint().getContainer().getSPI(ServerPipelineHook.class);
            if (hook != null) {
                Pipe securityPipe = hook.createSecurityPipe(context.getPolicyMap(), context.getSEIModel(), context.getWsdlPort(), context.getEndpoint(), context.getAdaptedTubelineHead());
                return PipeAdapter.adapt(securityPipe);
            }
            if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
                if (this.serverTubeLineHookExists()) {
                    return this.createSecurityTube(context);
                }
                return PipeAdapter.adapt(new SecurityServerPipe(context, context.getAdaptedTubelineHead()));
            }
            try {
                if (!context.isPolicyAvailable() && this.isSecurityConfigPresent(context)) {
                    return this.initializeXWSSServerTube(context);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return context.getTubelineHead();
        }

        @Override
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            ClientPipelineHook[] hooks;
            ClientPipelineHook hook = context.getContainer().getSPI(ClientPipelineHook.class);
            if (hook == null && (hooks = SecurityTubeAppender.loadSPs(ClientPipelineHook.class)) != null && hooks.length > 0) {
                hook = hooks[0];
            }
            if (hook != null) {
                ClientPipeAssemblerContext pipeContext = new ClientPipeAssemblerContext(context.getAddress(), context.getWsdlPort(), context.getService(), context.getBinding(), context.getContainer());
                Pipe securityPipe = hook.createSecurityPipe(context.getPolicyMap(), pipeContext, context.getAdaptedTubelineHead());
                if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
                    context.setScInitiator((SecureConversationInitiator)((Object)securityPipe));
                }
                return PipeAdapter.adapt(securityPipe);
            }
            if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
                SecurityClientPipe securityPipe = new SecurityClientPipe(context, context.getAdaptedTubelineHead());
                context.setScInitiator(securityPipe);
                return PipeAdapter.adapt(securityPipe);
            }
            if (!context.isPolicyAvailable() && this.isSecurityConfigPresent(context)) {
                return this.initializeXWSSClientTube(context);
            }
            return context.getTubelineHead();
        }

        private boolean isSecurityEnabled(PolicyMap policyMap, WSDLPort wsdlPort) {
            if (policyMap == null || wsdlPort == null) {
                return false;
            }
            try {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY200512.namespaceUri))) {
                    return true;
                }
                for (WSDLBoundOperation wSDLBoundOperation : wsdlPort.getBinding().getBindingOperations()) {
                    PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName(), wSDLBoundOperation.getName());
                    policy = policyMap.getOperationEffectivePolicy(operationKey);
                    if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                        return true;
                    }
                    policy = policyMap.getInputMessageEffectivePolicy(operationKey);
                    if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                        return true;
                    }
                    policy = policyMap.getOutputMessageEffectivePolicy(operationKey);
                    if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                        return true;
                    }
                    policy = policyMap.getFaultMessageEffectivePolicy(operationKey);
                    if (policy == null || !policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) && !policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri)) continue;
                    return true;
                }
            }
            catch (PolicyException e) {
                throw new WebServiceException((Throwable)e);
            }
            return false;
        }

        private Codec createSecurityCodec(WSBinding binding) {
            StreamSOAPCodec primaryCodec = Codecs.createSOAPEnvelopeXmlCodec(binding.getSOAPVersion());
            LazyStreamCodec lsc = new LazyStreamCodec(primaryCodec);
            return Codecs.createSOAPBindingCodec(binding, lsc);
        }

        private static <P> P[] loadSPs(Class<P> svcClass) {
            return ServiceFinder.find(svcClass).toArray();
        }

        private boolean serverTubeLineHookExists() {
            try {
                ServerPipelineHook[] hooks = SecurityTubeAppender.loadSPs(ServerPipelineHook.class);
                if (hooks != null && hooks.length > 0) {
                    return true;
                }
            }
            catch (ServiceConfigurationError ex) {
                return ex.getCause() instanceof InstantiationException;
            }
            return false;
        }

        private boolean isSecurityConfigPresent(WsitClientTubeAssemblyContext context) {
            return true;
        }

        private boolean isSecurityConfigPresent(WsitServerTubeAssemblyContext context) {
            QName serviceQName = context.getEndpoint().getServiceName();
            String serviceLocalName = serviceQName.getLocalPart();
            Container container = context.getEndpoint().getContainer();
            Object ctxt = null;
            if (container != null) {
                try {
                    Class<?> contextClass = Class.forName(SERVLET_CONTEXT_CLASSNAME);
                    ctxt = container.getSPI(contextClass);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            String serverName = "server";
            if (ctxt != null) {
                String serverConfig = "/WEB-INF/" + serverName + "_" + "security_config.xml";
                URL url = SecurityUtil.loadFromContext(serverConfig, ctxt);
                if (url == null) {
                    serverConfig = "/WEB-INF/" + serviceLocalName + "_" + "security_config.xml";
                    url = SecurityUtil.loadFromContext(serverConfig, ctxt);
                }
                if (url != null) {
                    return true;
                }
            } else {
                String serverConfig = "META-INF/" + serverName + "_" + "security_config.xml";
                URL url = SecurityUtil.loadFromClasspath(serverConfig);
                if (url == null) {
                    serverConfig = "META-INF/" + serviceLocalName + "_" + "security_config.xml";
                    url = SecurityUtil.loadFromClasspath(serverConfig);
                }
                if (url != null) {
                    return true;
                }
            }
            return false;
        }

        private Tube initializeXWSSClientTube(WsitClientTubeAssemblyContext context) {
            return PipeAdapter.adapt(new XWSSClientPipe(context.getWsdlPort(), context.getService(), context.getBinding(), context.getAdaptedTubelineHead()));
        }

        private Tube initializeXWSSServerTube(WsitServerTubeAssemblyContext context) {
            return PipeAdapter.adapt(new XWSSServerPipe(context.getEndpoint(), context.getWsdlPort(), context.getAdaptedTubelineHead()));
        }

        private Tube createSecurityTube(WsitServerTubeAssemblyContext context) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put(POLICY, context.getPolicyMap());
            props.put(SEI_MODEL, context.getSEIModel());
            props.put(WSDL_MODEL, context.getWsdlPort());
            props.put(ENDPOINT, context.getEndpoint());
            props.put(NEXT_PIPE, context.getAdaptedTubelineHead());
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> gfServerPipeClass = null;
                gfServerPipeClass = loader != null ? loader.loadClass(GF_SERVER_SEC_PIPE) : Class.forName(GF_SERVER_SEC_PIPE);
                if (gfServerPipeClass != null) {
                    Class<?>[] paramTypes;
                    Constructor<?>[] ctors = gfServerPipeClass.getDeclaredConstructors();
                    Constructor<?> ctor = null;
                    for (int i = 0; i < ctors.length && !(paramTypes = (ctor = ctors[i]).getParameterTypes())[0].equals(Map.class); ++i) {
                    }
                    if (ctor != null) {
                        return PipeAdapter.adapt((Pipe)ctor.newInstance(props, context.getAdaptedTubelineHead(), false));
                    }
                }
                return context.getTubelineHead();
            }
            catch (InstantiationException ex) {
                throw new WebServiceException((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw new WebServiceException((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                throw new WebServiceException((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new WebServiceException((Throwable)ex);
            }
            catch (SecurityException ex) {
                throw new WebServiceException((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                throw new WebServiceException((Throwable)ex);
            }
        }
    }

    public static class AddressingTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            if (this.isAddressingEnabled(context.getPolicyMap(), context.getWsdlPort(), context.getBinding())) {
                return context.getWrappedContext().createWsaTube(context.getTubelineHead());
            }
            return context.getTubelineHead();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            if (this.isAddressingEnabled(context.getPolicyMap(), context.getWsdlPort(), context.getEndpoint().getBinding())) {
                return context.getWrappedContext().createWsaTube(context.getTubelineHead());
            }
            return context.getTubelineHead();
        }

        private boolean isAddressingEnabled(PolicyMap policyMap, WSDLPort port, WSBinding binding) {
            if (AddressingVersion.isEnabled(binding)) {
                return true;
            }
            if (policyMap == null || port == null) {
                return false;
            }
            try {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                return policy != null && (policy.contains(AddressingVersion.W3C.policyNsUri) || policy.contains(AddressingVersion.MEMBER.policyNsUri));
            }
            catch (PolicyException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
    }

    public static class TransportTubeAppender
    implements TubeAppender {
        private static final String AUTO_OPTIMIZED_TRANSPORT_POLICY_NAMESPACE_URI = "http://java.sun.com/xml/ns/wsit/2006/09/policy/transport/client";
        private static final QName AUTO_OPTIMIZED_TRANSPORT_POLICY_ASSERTION = new QName("http://java.sun.com/xml/ns/wsit/2006/09/policy/transport/client", "AutomaticallySelectOptimalTransport");

        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            if (this.isOptimizedTransportEnabled(context.getPolicyMap(), context.getWsdlPort(), context.getPortInfo())) {
                return TCPTransportPipeFactory.doCreate(context, false);
            }
            return context.getWrappedContext().createTransportTube();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getTubelineHead();
        }

        private boolean isOptimizedTransportEnabled(PolicyMap policyMap, WSDLPort port, WSPortInfo portInfo) {
            if (policyMap == null || port == null) {
                return false;
            }
            String schema = null;
            if (port != null) {
                schema = port.getAddress().getURI().getScheme();
            } else if (portInfo != null) {
                schema = portInfo.getEndpointAddress().getURI().getScheme();
            }
            if ("vnd.sun.ws.tcp".equals(schema)) {
                return true;
            }
            try {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                if (policy != null && policy.contains(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION) && policy.contains(AUTO_OPTIMIZED_TRANSPORT_POLICY_ASSERTION)) {
                    for (AssertionSet assertionSet : policy) {
                        for (PolicyAssertion assertion : assertionSet) {
                            if (!assertion.getName().equals(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION)) continue;
                            String value = assertion.getAttributeValue(new QName("enabled"));
                            if (value == null) {
                                return false;
                            }
                            return Boolean.valueOf(value = value.trim()) != false || value.equalsIgnoreCase("yes");
                        }
                    }
                }
                return false;
            }
            catch (PolicyException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
    }

    public static class MessageDumpingTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            MessageDumpingFeature msgDumper = context.getBinding().getFeature(MessageDumpingFeature.class);
            if (msgDumper != null) {
                return msgDumper.createMessageDumpingTube(context.getTubelineHead());
            }
            return context.getTubelineHead();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getTubelineHead();
        }
    }

    public static class DumpTubeAppender
    implements TubeAppender {
        public static final String PREFIX = "com.sun.xml.ws.assembler";
        public static final String CLIENT_PREFIX = "com.sun.xml.ws.assembler.client";
        public static final String SERVER_PREFIX = "com.sun.xml.ws.assembler.server";
        private final String name;

        public DumpTubeAppender(String name) {
            this.name = name;
        }

        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            if (Boolean.getBoolean(CLIENT_PREFIX + this.name)) {
                return context.getWrappedContext().createDumpTube(this.name, System.out, context.getTubelineHead());
            }
            return context.getTubelineHead();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            if (Boolean.getBoolean(SERVER_PREFIX + this.name)) {
                return context.getWrappedContext().createDumpTube(this.name, System.out, context.getTubelineHead());
            }
            return context.getTubelineHead();
        }
    }

    public static class TxTubeAppender
    implements TubeAppender {
        private static final String WSAT_SOAP_NSURI = "http://schemas.xmlsoap.org/ws/2004/10/wsat";
        private static final QName AT_ALWAYS_CAPABILITY = new QName("http://schemas.xmlsoap.org/ws/2004/10/wsat", "ATAlwaysCapability");
        private static final QName AT_ASSERTION = new QName("http://schemas.xmlsoap.org/ws/2004/10/wsat", "ATAssertion");

        public Tube appendTube(WsitClientTubeAssemblyContext context) {
            if (this.isTransactionsEnabled(context.getPolicyMap(), context.getWsdlPort(), false)) {
                return PipeAdapter.adapt(new TxClientPipe(context, context.getAdaptedTubelineHead()));
            }
            return context.getTubelineHead();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) {
            if (this.isTransactionsEnabled(context.getPolicyMap(), context.getWsdlPort(), true)) {
                return PipeAdapter.adapt(new TxServerPipe(context, context.getAdaptedTubelineHead()));
            }
            return context.getTubelineHead();
        }

        private boolean isTransactionsEnabled(PolicyMap policyMap, WSDLPort wsdlPort, boolean isServerSide) {
            if (policyMap == null || wsdlPort == null || !Util.isJTAAvailable()) {
                return false;
            }
            try {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                for (WSDLBoundOperation wSDLBoundOperation : wsdlPort.getBinding().getBindingOperations()) {
                    PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName(), wSDLBoundOperation.getName());
                    policy = policyMap.getOperationEffectivePolicy(operationKey);
                    if (policy == null) continue;
                    if (isServerSide && policy.contains(AT_ALWAYS_CAPABILITY)) {
                        return true;
                    }
                    if (!policy.contains(AT_ASSERTION)) continue;
                    return true;
                }
            }
            catch (PolicyException e) {
                throw new WebServiceException((Throwable)e);
            }
            return false;
        }
    }
}

