/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.HighlyAvailableMap;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.ReplicationManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.SequenceDataPojo;
import com.sun.xml.ws.rx.util.TimeSynchronizer;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.ha.store.annotations.StoreEntry;
import org.glassfish.ha.store.api.BackingStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StoreEntry
final class InVmSequenceData
implements SequenceData {
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final HighlyAvailableMap<String, ApplicationMessage> messageStore;
    private final SequenceDataPojo data;
    private final TimeSynchronizer timeSynchronizer;

    public static InVmSequenceData newInstace(@NotNull TimeSynchronizer timeSynchronizer, @NotNull SequenceDataPojo data) {
        return new InVmSequenceData(timeSynchronizer, data);
    }

    public static InVmSequenceData loadReplica(@NotNull TimeSynchronizer timeSynchronizer, @NotNull SequenceDataPojo data) {
        InVmSequenceData replica = new InVmSequenceData(timeSynchronizer, data);
        replica.initLocalCache();
        return replica;
    }

    private InVmSequenceData(@NotNull TimeSynchronizer timeSynchronizer, @NotNull SequenceDataPojo data) {
        assert (timeSynchronizer != null);
        assert (data != null);
        this.timeSynchronizer = timeSynchronizer;
        this.data = data;
        UnackedMessageReplicationManager rm = null;
        if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            rm = new UnackedMessageReplicationManager(data.getSequenceId());
        }
        this.messageStore = HighlyAvailableMap.newInstance(new HashMap(), rm);
    }

    private void lockRead() {
        this.dataLock.readLock().lock();
    }

    private void unlockRead() {
        this.dataLock.readLock().unlock();
    }

    private void lockWrite() {
        this.dataLock.writeLock().lock();
    }

    private void unlockWrite() {
        this.dataLock.writeLock().unlock();
    }

    @Override
    public String getSequenceId() {
        return this.data.getSequenceId();
    }

    @Override
    public String getBoundSecurityTokenReferenceId() {
        return this.data.getBoundSecurityTokenReferenceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastMessageNumber() {
        try {
            this.lockRead();
            long l = this.data.getLastMessageNumber();
            return l;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public Sequence.State getState() {
        return this.data.getState();
    }

    @Override
    public void setState(Sequence.State newState) {
        this.updateLastActivityTime();
        this.data.setState(newState);
        this.data.replicate();
    }

    @Override
    public boolean getAckRequestedFlag() {
        return this.data.getAckRequestedFlag();
    }

    @Override
    public void setAckRequestedFlag(boolean newValue) {
        this.updateLastActivityTime();
        this.data.setAckRequestedFlag(newValue);
        this.data.replicate();
    }

    @Override
    public long getLastAcknowledgementRequestTime() {
        return this.data.getLastAcknowledgementRequestTime();
    }

    @Override
    public void setLastAcknowledgementRequestTime(long newTime) {
        this.updateLastActivityTime();
        this.data.setLastAcknowledgementRequestTime(newTime);
        this.data.replicate();
    }

    @Override
    public long getLastActivityTime() {
        return this.data.getLastActivityTime();
    }

    private void updateLastActivityTime() {
        this.data.setLastActivityTime(this.timeSynchronizer.currentTimeInMillis());
    }

    @Override
    public long getExpirationTime() {
        return this.data.getExpirationTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void attachMessageToUnackedMessageNumber(ApplicationMessage message) {
        this.updateLastActivityTime();
        try {
            this.lockWrite();
            Long msgNumberKey = this.getUnackedMessageIdentifierKey(message.getMessageNumber());
            this.data.getUnackedNumberToCorrelationIdMap().put(msgNumberKey, message.getCorrelationId());
            this.data.replicate();
            this.messageStore.put(message.getCorrelationId(), message);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long incrementAndGetLastMessageNumber(boolean received) {
        this.updateLastActivityTime();
        try {
            this.dataLock.writeLock().lock();
            this.data.setLastMessageNumber(this.data.getLastMessageNumber() + 1L);
            this.addUnackedMessageNumber(this.data.getLastMessageNumber(), received);
            this.data.replicate();
            long l = this.data.getLastMessageNumber();
            return l;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerReceivedUnackedMessageNumber(long messageNumber) throws DuplicateMessageRegistrationException {
        this.updateLastActivityTime();
        try {
            this.lockWrite();
            if (messageNumber > this.data.getLastMessageNumber()) {
                while (messageNumber > this.data.getLastMessageNumber() + 1L) {
                    this.incrementAndGetLastMessageNumber(false);
                }
                this.incrementAndGetLastMessageNumber(true);
            } else {
                if (this.data.getReceivedUnackedMessageNumbers().contains(messageNumber) || !this.data.getAllUnackedMessageNumbers().contains(messageNumber)) {
                    throw new DuplicateMessageRegistrationException(this.data.getSequenceId(), messageNumber);
                }
                this.addUnackedMessageNumber(messageNumber, true);
            }
            this.data.replicate();
        }
        finally {
            this.unlockWrite();
        }
    }

    private void addUnackedMessageNumber(long messageNumber, boolean received) {
        Long newUnackedInstance = messageNumber;
        this.data.getAllUnackedMessageNumbers().add(newUnackedInstance);
        if (received) {
            this.data.getReceivedUnackedMessageNumbers().add(newUnackedInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsAcknowledged(long messageNumber) {
        this.updateLastActivityTime();
        try {
            this.lockWrite();
            this.data.getReceivedUnackedMessageNumbers().remove(messageNumber);
            this.data.getAllUnackedMessageNumbers().remove(messageNumber);
            String correlationId = this.data.getUnackedNumberToCorrelationIdMap().remove(messageNumber);
            this.data.replicate();
            this.messageStore.remove(correlationId);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationMessage retrieveMessage(String correlationId) {
        this.updateLastActivityTime();
        try {
            this.lockRead();
            ApplicationMessage applicationMessage = this.messageStore.get(correlationId);
            return applicationMessage;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getUnackedMessageNumbers() {
        try {
            this.lockRead();
            ArrayList<Long> arrayList = new ArrayList<Long>(this.data.getAllUnackedMessageNumbers());
            return arrayList;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getLastMessageNumberWithUnackedMessageNumbers() {
        try {
            this.lockRead();
            LinkedList<Long> result = new LinkedList<Long>(this.data.getAllUnackedMessageNumbers());
            result.addFirst(this.data.getLastMessageNumber());
            LinkedList<Long> linkedList = result;
            return linkedList;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getUnackedMessageIdentifierKey(long messageNumber) {
        try {
            this.lockRead();
            Long msgNumberKey2 = null;
            for (Long msgNumberKey2 : this.data.getReceivedUnackedMessageNumbers()) {
                if (msgNumberKey2 == messageNumber) break;
            }
            Long l = msgNumberKey2;
            return l;
        }
        finally {
            this.unlockRead();
        }
    }

    SequenceDataPojo getSequenceStatePojo() {
        return this.data;
    }

    private void initLocalCache() {
        for (Long unackedMessageNumber : this.data.getReceivedUnackedMessageNumbers()) {
            this.messageStore.get(this.data.getUnackedNumberToCorrelationIdMap().get(unackedMessageNumber));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnackedMessageReplicationManager
    implements ReplicationManager<String, ApplicationMessage> {
        private BackingStore<String, ApplicationMessageState> unackedMesagesBs;

        public UnackedMessageReplicationManager(String sequenceId) {
            this.unackedMesagesBs = HighAvailabilityProvider.INSTANCE.createBackingStore(HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY), sequenceId + "_UNACKED_MESSAGES_BS", String.class, ApplicationMessageState.class);
        }

        @Override
        public ApplicationMessage load(String key) {
            ApplicationMessageState state = HighAvailabilityProvider.loadFrom(this.unackedMesagesBs, key, null);
            return state.toMessage();
        }

        @Override
        public String save(String key, ApplicationMessage value, boolean isNew) {
            ApplicationMessageState ams = new ApplicationMessageState(value);
            return HighAvailabilityProvider.saveTo(this.unackedMesagesBs, key, ams, isNew);
        }

        @Override
        public void remove(String key) {
            HighAvailabilityProvider.removeFrom(this.unackedMesagesBs, key);
        }

        @Override
        public void close() {
            HighAvailabilityProvider.close(this.unackedMesagesBs);
        }

        @Override
        public void destroy() {
            HighAvailabilityProvider.destroy(this.unackedMesagesBs);
        }

        private static class ApplicationMessageState
        implements Serializable {
            private final byte[] data;
            private final int nextResendCount;
            private final String correlationId;
            private final String wsaAction;
            private final String sequenceId;
            private final long messageNumber;

            public ApplicationMessageState(ApplicationMessage _message) {
                if (!(_message instanceof JaxwsApplicationMessage)) {
                    throw new IllegalArgumentException("Unsupported message class: " + _message.getClass().getName());
                }
                JaxwsApplicationMessage message = (JaxwsApplicationMessage)_message;
                this.data = message.toBytes();
                this.nextResendCount = message.getNextResendCount();
                this.correlationId = message.getCorrelationId();
                this.wsaAction = message.getWsaAction();
                this.sequenceId = message.getSequenceId();
                this.messageNumber = message.getMessageNumber();
            }

            public ApplicationMessage toMessage() {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
                return JaxwsApplicationMessage.newInstance(bais, this.nextResendCount, this.correlationId, this.wsaAction, this.sequenceId, this.messageNumber);
            }
        }
    }
}

