/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.wss.NonceManager;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HANonceManager
extends NonceManager {
    private Long maxNonceAge;
    private BackingStore<String, MyPojo> backingStore = null;
    private final ScheduledExecutorService singleThreadScheduledExecutor = Executors.newSingleThreadScheduledExecutor();

    public HANonceManager(BackingStore<String, MyPojo> backingStore, long maxNonceAge) {
        this.backingStore = backingStore;
        this.maxNonceAge = maxNonceAge;
        this.singleThreadScheduledExecutor.scheduleAtFixedRate(new HANM(), maxNonceAge, maxNonceAge, TimeUnit.MILLISECONDS);
    }

    public boolean validateNonce(String nonce, MyPojo created) throws NonceManager.NonceException {
        try {
            MyPojo value = null;
            try {
                value = (MyPojo)this.backingStore.load((Serializable)((Object)nonce), null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (value != null) {
                String message = "Nonce Repeated : Nonce Cache already contains the nonce value :" + nonce;
                LOGGER.log(Level.WARNING, message);
                throw new NonceManager.NonceException(message);
            }
            this.backingStore.save((Serializable)((Object)nonce), (Serializable)created, true);
            LOGGER.log(Level.INFO, " nonce saved ");
        }
        catch (BackingStoreException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return true;
    }

    @Override
    public boolean validateNonce(String nonce, String created) throws NonceManager.NonceException {
        byte[] data = created.getBytes();
        MyPojo pojo = new MyPojo();
        pojo.setData(data);
        return this.validateNonce(nonce, pojo);
    }

    public static class MyPojo
    implements Serializable {
        byte[] data;

        public void setData(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public class HANM
    implements Runnable {
        public void run() {
            try {
                int removed = HANonceManager.this.backingStore.removeExpired(HANonceManager.this.maxNonceAge.longValue());
            }
            catch (BackingStoreException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }
}

