/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.glassfish.ha.store.api.BackingStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SequenceDataPojo
implements Serializable {
    static final long serialVersionUID = -5024744406713321676L;
    private transient BackingStore<String, SequenceDataPojo> backingStore;
    private String sequenceId;
    private String boundSecurityTokenReferenceId;
    private long expirationTime;
    private volatile Sequence.State state;
    private volatile boolean ackRequestedFlag;
    private volatile long lastMessageNumber;
    private volatile long lastActivityTime;
    private volatile long lastAcknowledgementRequestTime;
    private Set<Long> allUnackedMessageNumbers;
    private Set<Long> receivedUnackedMessageNumbers;
    private Map<Long, String> unackedNumberToCorrelationIdMap;
    private boolean inbound;

    protected SequenceDataPojo() {
    }

    public SequenceDataPojo(String sequenceId, String boundSecurityTokenReferenceId, long expirationTime, boolean isInbound, BackingStore<String, SequenceDataPojo> bs) {
        this.sequenceId = sequenceId;
        this.boundSecurityTokenReferenceId = boundSecurityTokenReferenceId;
        this.expirationTime = expirationTime;
        this.inbound = isInbound;
        this.allUnackedMessageNumbers = new TreeSet<Long>();
        this.receivedUnackedMessageNumbers = new HashSet<Long>();
        this.unackedNumberToCorrelationIdMap = new HashMap<Long, String>();
        this.backingStore = bs;
    }

    public String getBoundSecurityTokenReferenceId() {
        return this.boundSecurityTokenReferenceId;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public boolean getAckRequestedFlag() {
        return this.ackRequestedFlag;
    }

    public void setAckRequestedFlag(boolean ackRequestedFlag) {
        this.ackRequestedFlag = ackRequestedFlag;
    }

    public long getLastAcknowledgementRequestTime() {
        return this.lastAcknowledgementRequestTime;
    }

    public void setLastAcknowledgementRequestTime(long lastAcknowledgementRequestTime) {
        this.lastAcknowledgementRequestTime = lastAcknowledgementRequestTime;
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public void setLastActivityTime(long lastActivityTime) {
        this.lastActivityTime = lastActivityTime;
    }

    public long getLastMessageNumber() {
        return this.lastMessageNumber;
    }

    public void setLastMessageNumber(long lastMessageNumber) {
        this.lastMessageNumber = lastMessageNumber;
    }

    public Sequence.State getState() {
        return this.state;
    }

    public void setState(Sequence.State state) {
        this.state = state;
    }

    public Set<Long> getAllUnackedMessageNumbers() {
        return this.allUnackedMessageNumbers;
    }

    public Set<Long> getReceivedUnackedMessageNumbers() {
        return this.receivedUnackedMessageNumbers;
    }

    public Map<Long, String> getUnackedNumberToCorrelationIdMap() {
        return this.unackedNumberToCorrelationIdMap;
    }

    public boolean isInbound() {
        return this.inbound;
    }

    public void setBackingStore(BackingStore<String, SequenceDataPojo> backingStore) {
        this.backingStore = backingStore;
    }

    public void replicate() {
        if (this.backingStore != null) {
            HighAvailabilityProvider.saveTo(this.backingStore, this.sequenceId, this, false);
        }
    }
}

