/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.jmx;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.jmx.ReconfigMBean;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.jmx.MBeanAttribute;
import com.sun.xml.ws.config.management.jmx.ReconfigNotification;
import java.io.Serializable;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Reconfig
extends NotificationBroadcasterSupport
implements ReconfigMBean,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(Reconfig.class);
    private final Map<String, MBeanAttribute> attributeToListener;
    private final Map<String, ReconfigNotification> notificationToListener;

    public Reconfig(Map<String, MBeanAttribute> attributeNameToListener, Map<String, ReconfigNotification> notificationToListener) {
        this.attributeToListener = attributeNameToListener;
        this.notificationToListener = notificationToListener;
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null) {
            throw (RuntimeOperationsException)LOGGER.logSevereException((Throwable)new RuntimeOperationsException(new IllegalArgumentException(ManagementMessages.WSM_5073_ATTRIBUTE_NAME_NULL()), ManagementMessages.WSM_5074_GET_ATTRIBUTE_NULL_NAME()));
        }
        MBeanAttribute listener = this.attributeToListener.get(attributeName);
        if (listener != null) {
            if (!listener.isReadable()) {
                throw (AttributeNotFoundException)LOGGER.logSevereException((Throwable)new AttributeNotFoundException(ManagementMessages.WSM_5085_ATTRIBUTE_UNREADABLE(attributeName)));
            }
            return listener.getValue();
        }
        throw (AttributeNotFoundException)LOGGER.logSevereException((Throwable)new AttributeNotFoundException(ManagementMessages.WSM_5075_CANNOT_FIND_ATTRIBUTE(attributeName)));
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw (RuntimeOperationsException)LOGGER.logSevereException((Throwable)new RuntimeOperationsException(new IllegalArgumentException(ManagementMessages.WSM_5076_ATTRIBUTE_NULL()), ManagementMessages.WSM_5077_SETTER_ATTRIBUTE_NULL(ManagementMessages.RECONFIG_MBEAN_NAME())));
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        MBeanAttribute listener = this.attributeToListener.get(name);
        if (listener != null) {
            if (!listener.isWritable()) {
                throw (AttributeNotFoundException)LOGGER.logSevereException((Throwable)new AttributeNotFoundException(ManagementMessages.WSM_5086_ATTRIBUTE_UNWRITABLE(name)));
            }
            if (value == null) {
                throw (InvalidAttributeValueException)LOGGER.logSevereException((Throwable)new InvalidAttributeValueException(ManagementMessages.WSM_5078_ATTRIBUTE_VALUE_NULL(name)));
            }
            try {
                listener.setValue(value);
            }
            catch (RuntimeException e) {
                LOGGER.severe(ManagementMessages.WSM_5072_ATTRIBUTE_UPDATE_FAILED(name, value), (Throwable)e);
                throw (RuntimeOperationsException)LOGGER.logSevereException((Throwable)new RuntimeOperationsException(e, ManagementMessages.WSM_5084_ATTRIBUTE_UPDATE_FAILED(name)));
            }
        } else {
            throw (AttributeNotFoundException)LOGGER.logSevereException((Throwable)new AttributeNotFoundException(ManagementMessages.WSM_5079_ATTRIBUTE_NOT_FOUND(name, ManagementMessages.RECONFIG_MBEAN_NAME())));
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw (RuntimeOperationsException)LOGGER.logSevereException((Throwable)new RuntimeOperationsException(new IllegalArgumentException(ManagementMessages.WSM_5080_ATTRIBUTE_NAMES_ARRAY_NULL()), ManagementMessages.WSM_5081_GET_ATTRIBUTES_NULL_NAME()));
        }
        AttributeList resultList = new AttributeList();
        if (attributes.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributes.length; ++i) {
            try {
                Object value = this.getAttribute(attributes[i]);
                resultList.add(new Attribute(attributes[i], value));
                continue;
            }
            catch (AttributeNotFoundException e) {
                LOGGER.logSevereException((Throwable)e);
                continue;
            }
            catch (MBeanException e) {
                LOGGER.logSevereException((Throwable)e);
                continue;
            }
            catch (ReflectionException e) {
                LOGGER.logSevereException((Throwable)e);
            }
        }
        return resultList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw (RuntimeOperationsException)LOGGER.logSevereException((Throwable)new RuntimeOperationsException(new IllegalArgumentException(ManagementMessages.WSM_5082_ATTRIBUTE_LIST_NULL()), ManagementMessages.WSM_5083_CANNOT_INVOKE_SETTER(ManagementMessages.RECONFIG_MBEAN_NAME())));
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        for (Object attribute : attributes) {
            Attribute attr = (Attribute)attribute;
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                resultList.add(new Attribute(name, value));
            }
            catch (Exception e) {
                LOGGER.logSevereException((Throwable)e);
            }
        }
        return resultList;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        Object listener;
        OpenMBeanAttributeInfo[] attributes = new OpenMBeanAttributeInfoSupport[this.attributeToListener.size()];
        OpenMBeanConstructorInfo[] constructors = new OpenMBeanConstructorInfoSupport[1];
        OpenMBeanOperationInfo[] operations = new OpenMBeanOperationInfoSupport[]{};
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[this.notificationToListener.size()];
        int i = 0;
        for (String attributeName : this.attributeToListener.keySet()) {
            listener = this.attributeToListener.get(attributeName);
            attributes[i] = new OpenMBeanAttributeInfoSupport(attributeName, listener.getDescription(), listener.getType(), listener.isReadable(), listener.isWritable(), false);
            ++i;
        }
        i = 0;
        for (String notificationName : this.notificationToListener.keySet()) {
            listener = this.notificationToListener.get(notificationName);
            notifications[i] = new MBeanNotificationInfo(((ReconfigNotification)listener).getNotificationTypes(), ((ReconfigNotification)listener).getName(), ((ReconfigNotification)listener).getDescription());
        }
        constructors[0] = new OpenMBeanConstructorInfoSupport(ManagementMessages.RECONFIG_MBEAN_NAME(), ManagementMessages.RECONFIG_MBEAN_CONSTRUCTOR_DESCRIPTION(ManagementMessages.RECONFIG_MBEAN_NAME()), new OpenMBeanParameterInfoSupport[0]);
        return new OpenMBeanInfoSupport(this.getClass().getName(), ManagementMessages.RECONFIG_MBEAN_DESCRIPTION(), attributes, constructors, operations, notifications);
    }
}

