/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.runtime;

import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.assembler.dev.ClientTubelineAssemblyContext;
import com.sun.xml.ws.assembler.dev.ServerTubelineAssemblyContext;
import com.sun.xml.ws.assembler.dev.TubeFactory;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.tx.client.TxClientPipe;
import com.sun.xml.ws.tx.common.Util;
import com.sun.xml.ws.tx.service.TxServerPipe;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public final class TxTubeFactory
implements TubeFactory {
    private static final String WSAT_SOAP_NSURI = "http://schemas.xmlsoap.org/ws/2004/10/wsat";
    private static final QName AT_ALWAYS_CAPABILITY = new QName("http://schemas.xmlsoap.org/ws/2004/10/wsat", "ATAlwaysCapability");
    private static final QName AT_ASSERTION = new QName("http://schemas.xmlsoap.org/ws/2004/10/wsat", "ATAssertion");

    public Tube createTube(ClientTubelineAssemblyContext context) {
        if (this.isTransactionsEnabled(context.getPolicyMap(), context.getWsdlPort(), false)) {
            return PipeAdapter.adapt(new TxClientPipe(context, context.getAdaptedTubelineHead()));
        }
        return context.getTubelineHead();
    }

    public Tube createTube(ServerTubelineAssemblyContext context) {
        if (this.isTransactionsEnabled(context.getPolicyMap(), context.getWsdlPort(), true)) {
            return PipeAdapter.adapt(new TxServerPipe(context, context.getAdaptedTubelineHead()));
        }
        return context.getTubelineHead();
    }

    private boolean isTransactionsEnabled(PolicyMap policyMap, WSDLPort wsdlPort, boolean isServerSide) {
        if (policyMap == null || wsdlPort == null || !Util.isJTAAvailable()) {
            return false;
        }
        try {
            PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName());
            Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
            for (WSDLBoundOperation wSDLBoundOperation : wsdlPort.getBinding().getBindingOperations()) {
                PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName(), wSDLBoundOperation.getName());
                policy = policyMap.getOperationEffectivePolicy(operationKey);
                if (policy == null) continue;
                if (isServerSide && policy.contains(AT_ALWAYS_CAPABILITY)) {
                    return true;
                }
                if (!policy.contains(AT_ASSERTION)) continue;
                return true;
            }
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
        return false;
    }
}

