/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.wss.provider.wsit.WSITAuthConfigProvider;
import com.sun.xml.wss.provider.wsit.WSITClientAuthContext;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ClientAuthContext;
import javax.xml.bind.JAXBElement;

public class WSITClientAuthConfig
implements ClientAuthConfig {
    private static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    private String layer = null;
    private String appContext = null;
    private CallbackHandler callbackHandler = null;
    private WSITClientAuthContext clientAuthContext = null;
    private ReentrantReadWriteLock rwLock;
    private ReentrantReadWriteLock.ReadLock rLock;
    private ReentrantReadWriteLock.WriteLock wLock;
    private volatile boolean secEnabled;
    private Map<Object, WSITClientAuthContext> tubetoClientAuthContextHash = Collections.synchronizedMap(new WeakHashMap());

    public WSITClientAuthConfig(String layer, String appContext, CallbackHandler callbackHandler) {
        this.layer = layer;
        this.appContext = appContext;
        this.callbackHandler = callbackHandler;
        this.rwLock = new ReentrantReadWriteLock(true);
        this.rLock = this.rwLock.readLock();
        this.wLock = this.rwLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientAuthContext getAuthContext(String operation, Subject subject, Map rawMap) throws AuthException {
        Object tubeOrPipe;
        Map map;
        block21: {
            map = rawMap;
            PolicyMap pMap = (PolicyMap)map.get("POLICY");
            WSDLPort port = (WSDLPort)map.get("WSDL_MODEL");
            tubeOrPipe = map.get("SECURITY_PIPE");
            map.put("AUTH_CONFIG", this);
            if (pMap == null || pMap.isEmpty()) {
                return null;
            }
            if (tubeOrPipe == null) {
                log.log(Level.INFO, "called getAuthContext() of WsitClientAuthConfig");
                return this.clientAuthContext;
            }
            try {
                this.rLock.lock();
                if (this.secEnabled && this.tubetoClientAuthContextHash.containsKey(tubeOrPipe)) break block21;
                this.rLock.unlock();
                this.wLock.lock();
                try {
                    if (!this.secEnabled || !this.tubetoClientAuthContextHash.containsKey(tubeOrPipe)) {
                        if (!WSITAuthConfigProvider.isSecurityEnabled(pMap, port)) {
                            ClientAuthContext clientAuthContext = null;
                            return clientAuthContext;
                        }
                        this.secEnabled = true;
                    }
                }
                finally {
                    this.rLock.lock();
                    this.wLock.unlock();
                }
            }
            finally {
                this.rLock.unlock();
            }
        }
        boolean authContextInitialized = false;
        this.rLock.lock();
        try {
            if (this.clientAuthContext != null && this.tubetoClientAuthContextHash.containsKey(tubeOrPipe)) {
                authContextInitialized = true;
                this.clientAuthContext = this.tubetoClientAuthContextHash.get(tubeOrPipe);
            }
        }
        finally {
            this.rLock.unlock();
        }
        if (!authContextInitialized) {
            this.wLock.lock();
            try {
                if (this.clientAuthContext == null || !this.tubetoClientAuthContextHash.containsKey(tubeOrPipe)) {
                    this.clientAuthContext = new WSITClientAuthContext(operation, subject, map, this.callbackHandler);
                    this.tubetoClientAuthContextHash.put(tubeOrPipe, this.clientAuthContext);
                }
            }
            finally {
                this.wLock.unlock();
            }
        }
        this.startSecureConversation(map);
        return this.clientAuthContext;
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public String getOperation(MessageInfo messageInfo) {
        return null;
    }

    public void refresh() {
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return null;
    }

    public boolean isProtected() {
        return true;
    }

    public ClientAuthContext cleanupAuthContext(Object tubeOrPipe) {
        return this.tubetoClientAuthContextHash.remove(tubeOrPipe);
    }

    public JAXBElement startSecureConversation(Map map) {
        JAXBElement ret;
        block4: {
            ret = null;
            try {
                MessageInfo info = (MessageInfo)map.get("SECURITY_TOKEN");
                if (info == null) break block4;
                Packet packet = (Packet)info.getMap().get("REQ_PACKET");
                if (packet != null) {
                    if (this.clientAuthContext != null) {
                        ret = this.clientAuthContext.startSecureConversation(packet);
                        info.getMap().put("SECURITY_TOKEN", ret);
                        break block4;
                    }
                    log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0024_NULL_CLIENT_AUTH_CONTEXT());
                    throw new WSSecureConversationException(LogStringsMessages.WSITPVD_0024_NULL_CLIENT_AUTH_CONTEXT());
                }
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0025_NULL_PACKET());
                throw new RuntimeException(LogStringsMessages.WSITPVD_0025_NULL_PACKET());
            }
            catch (WSSecureConversationException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0026_ERROR_STARTING_SC(), ex);
                throw new RuntimeException(LogStringsMessages.WSITPVD_0026_ERROR_STARTING_SC(), ex);
            }
        }
        return ret;
    }
}

