/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.jaxws.impl;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.message.stream.InputStreamMessage;
import com.sun.xml.ws.api.message.stream.XMLStreamReaderMessage;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.security.CallbackHandlerFeature;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.assembler.dev.ServerTubelineAssemblyContext;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.runtime.dev.Session;
import com.sun.xml.ws.runtime.dev.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.secconv.WSSCContract;
import com.sun.xml.ws.security.secconv.WSSCFactory;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.RealmAuthenticationAdapter;
import com.sun.xml.wss.SubjectAccessor;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.NewSecurityRecipient;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.DefaultCallbackHandler;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.jaxws.impl.Constants;
import com.sun.xml.wss.jaxws.impl.PolicyResolverImpl;
import com.sun.xml.wss.jaxws.impl.SecurityTubeBase;
import com.sun.xml.wss.jaxws.impl.ServerTubeConfiguration;
import com.sun.xml.wss.jaxws.impl.logging.LogStringsMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityServerTube
extends SecurityTubeBase {
    private static final String WSCONTEXT_DELEGATE = "META-INF/services/com.sun.xml.ws.api.server.WebServiceContextDelegate";
    private Class contextDelegate = null;
    private SessionManager sessionManager = null;
    private Set trustConfig = null;
    private Set wsscConfig = null;
    private CallbackHandler handler = null;
    private Packet tmpPacket;
    private boolean isTrustMessage;
    private boolean isSCIssueMessage;
    private boolean isSCCancelMessage;
    private String reqAction = null;
    private WSEndpoint wsEndpoint = null;

    public SecurityServerTube(ServerTubelineAssemblyContext context, Tube nextTube) {
        super(new ServerTubeConfiguration(context.getPolicyMap(), context.getWsdlPort(), context.getEndpoint()), nextTube);
        this.wsEndpoint = context.getEndpoint();
        try {
            Iterator it = this.inMessagePolicyMap.values().iterator();
            Set<PolicyAssertion> configAssertions = null;
            while (it.hasNext()) {
                SecurityPolicyHolder holder = (SecurityPolicyHolder)it.next();
                if (configAssertions != null) {
                    configAssertions.addAll(holder.getConfigAssertions("http://schemas.sun.com/2006/03/wss/server"));
                } else {
                    configAssertions = holder.getConfigAssertions("http://schemas.sun.com/2006/03/wss/server");
                }
                if (this.trustConfig != null) {
                    this.trustConfig.addAll(holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/trust/server"));
                } else {
                    this.trustConfig = holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/trust/server");
                }
                if (this.wsscConfig != null) {
                    this.wsscConfig.addAll(holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/sc/server"));
                    continue;
                }
                this.wsscConfig = holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/sc/server");
            }
            Properties props = new Properties();
            this.handler = this.configureServerHandler(configAssertions, props);
            this.secEnv = new DefaultSecurityEnvironmentImpl(this.handler, props);
            String cntxtClass = SecurityServerTube.getMetaINFServiceClass(WSCONTEXT_DELEGATE);
            if (cntxtClass != null) {
                this.contextDelegate = this.loadClass(cntxtClass);
            }
            this.sessionManager = SessionManager.getSessionManager(((ServerTubeConfiguration)this.tubeConfig).getEndpoint());
            props.put("ENDPOINT", context.getEndpoint());
            props.put("POLICY", context.getPolicyMap());
            props.put("WSDL_MODEL", context.getWsdlPort());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0028_ERROR_CREATING_NEW_INSTANCE_SEC_SERVER_TUBE(), e);
            throw new RuntimeException(LogStringsMessages.WSSTUBE_0028_ERROR_CREATING_NEW_INSTANCE_SEC_SERVER_TUBE(), e);
        }
    }

    protected SecurityServerTube(SecurityServerTube that, TubeCloner cloner) {
        super(that, cloner);
        this.sessionManager = that.sessionManager;
        this.trustConfig = that.trustConfig;
        this.wsscConfig = that.wsscConfig;
        this.handler = that.handler;
        this.contextDelegate = that.contextDelegate;
    }

    @Override
    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new SecurityServerTube(this, cloner);
    }

    @Override
    public NextAction processRequest(Packet packet) {
        SOAPFaultException sfe;
        Message msg = packet.getMessage();
        this.isSCIssueMessage = false;
        this.isSCCancelMessage = false;
        this.isTrustMessage = false;
        this.tmpPacket = null;
        boolean thereWasAFault = false;
        if (this.contextDelegate != null) {
            try {
                WebServiceContextDelegate current = packet.webServiceContextDelegate;
                Constructor ctor = this.contextDelegate.getConstructor(WebServiceContextDelegate.class);
                packet.webServiceContextDelegate = (WebServiceContextDelegate)ctor.newInstance(current);
            }
            catch (InstantiationException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
            catch (SecurityException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
        ProcessingContext ctx = this.initializeInboundProcessingContext(packet);
        ctx.setExtraneousProperty("OperationResolver", new PolicyResolverImpl(this.inMessagePolicyMap, this.inProtocolPM, this.cachedOperation, this.tubeConfig, this.addVer, false, this.rmVer, this.mcVer));
        ctx.setExtraneousProperty("SessionManager", this.sessionManager);
        try {
            if (!this.optimized) {
                SOAPMessage soapMessage = msg.readAsSOAPMessage();
                soapMessage = this.verifyInboundMessage(soapMessage, ctx);
                msg = Messages.create(soapMessage);
            } else {
                msg = this.verifyInboundMessage(msg, ctx);
            }
        }
        catch (WssSoapFaultException ex) {
            thereWasAFault = true;
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0025_ERROR_VERIFY_INBOUND_MSG(), ex);
            sfe = SOAPUtil.getSOAPFaultException(ex, this.soapFactory, this.soapVersion);
            if (sfe.getCause() == null) {
                sfe.initCause((Throwable)ex);
            }
            msg = Messages.create((Throwable)sfe, this.soapVersion);
        }
        catch (XWSSecurityException xwse) {
            thereWasAFault = true;
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0025_ERROR_VERIFY_INBOUND_MSG(), xwse);
            sfe = SOAPUtil.getSOAPFaultException(xwse, this.soapFactory, this.soapVersion);
            if (sfe.getCause() == null) {
                sfe.initCause((Throwable)xwse);
            }
            msg = Messages.create((Throwable)sfe, this.soapVersion);
        }
        catch (XWSSecurityRuntimeException xwse) {
            thereWasAFault = true;
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0025_ERROR_VERIFY_INBOUND_MSG(), xwse);
            sfe = SOAPUtil.getSOAPFaultException(xwse, this.soapFactory, this.soapVersion);
            if (sfe.getCause() == null) {
                sfe.initCause((Throwable)xwse);
            }
            msg = Messages.create((Throwable)sfe, this.soapVersion);
        }
        catch (WebServiceException xwse) {
            thereWasAFault = true;
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0025_ERROR_VERIFY_INBOUND_MSG(), xwse);
            sfe = SOAPUtil.getSOAPFaultException((Exception)((Object)xwse), this.soapFactory, this.soapVersion);
            if (sfe.getCause() == null) {
                sfe.initCause((Throwable)xwse);
            }
            msg = Messages.create((Throwable)sfe, this.soapVersion);
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0025_ERROR_VERIFY_INBOUND_MSG(), se);
            thereWasAFault = true;
            sfe = SOAPUtil.getSOAPFaultException(se, this.soapFactory, this.soapVersion);
            if (sfe.getCause() == null) {
                sfe.initCause((Throwable)se);
            }
            msg = Messages.create((Throwable)sfe, this.soapVersion);
        }
        Packet retPacket = null;
        if (thereWasAFault) {
            if (this.isAddressingEnabled()) {
                if (this.optimized) {
                    packet.setMessage(((JAXBFilterProcessingContext)ctx).getPVMessage());
                }
                retPacket = packet.createServerResponse(msg, this.addVer, this.soapVersion, this.addVer.getDefaultFaultAction());
            } else {
                packet.setMessage(msg);
                retPacket = packet;
            }
        }
        packet.setMessage(msg);
        if (this.isAddressingEnabled()) {
            List<PolicyAssertion> policies;
            this.reqAction = this.getAction(packet);
            if (this.wsscVer.getSCTRequestAction().equals(this.reqAction) || this.wsscVer.getSCTRenewRequestAction().equals(this.reqAction)) {
                this.isSCIssueMessage = true;
                if (this.wsscConfig != null) {
                    packet.invocationProperties.put("http://schemas.sun.com/ws/2006/05/sc/server", this.wsscConfig.iterator());
                }
            } else if (this.wsscVer.getSCTCancelRequestAction().equals(this.reqAction)) {
                this.isSCCancelMessage = true;
            } else if (this.wsTrustVer.getIssueRequestAction().equals(this.reqAction) || this.wsTrustVer.getValidateRequestAction().equals(this.reqAction)) {
                this.isTrustMessage = true;
                if (this.trustConfig != null) {
                    packet.invocationProperties.put("http://schemas.sun.com/ws/2006/05/trust/server", this.trustConfig.iterator());
                }
                packet.invocationProperties.put("SecurityEnvironment", this.secEnv);
                packet.invocationProperties.put("WSTrustVersion", this.wsTrustVer);
                IssuedTokenContext ictx = ((ProcessingContextImpl)ctx).getTrustContext();
                if (ictx != null && ictx.getAuthnContextClass() != null) {
                    packet.invocationProperties.put("AuthnContextClass", ictx.getAuthnContextClass());
                }
            }
            if (this.isSCIssueMessage && !(policies = this.getInBoundSCP(packet.getMessage())).isEmpty()) {
                packet.invocationProperties.put(Constants.SC_ASSERTION, policies.get(0));
            }
        }
        if (!this.isSCIssueMessage) {
            this.cachedOperation = msg.getOperation(this.tubeConfig.getWSDLPort());
            if (this.cachedOperation == null && this.addVer != null) {
                this.cachedOperation = this.getWSDLOpFromAction(packet, true);
            }
        }
        if (!thereWasAFault) {
            if (this.isSCIssueMessage || this.isSCCancelMessage) {
                retPacket = this.invokeSecureConversationContract(packet, ctx, this.isSCIssueMessage, this.reqAction);
                this.tmpPacket = packet;
                return this.processResponse(retPacket);
            }
            this.updateSCBootstrapCredentials(packet, ctx);
            this.tmpPacket = packet;
            return this.doInvoke(this.next, packet);
        }
        return this.doReturnWith(retPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction processResponse(Packet retPacket) {
        if (retPacket.getMessage() == null) {
            return this.doReturnWith(retPacket);
        }
        if (!this.optimized) {
            try {
                SOAPMessage sm = retPacket.getMessage().readAsSOAPMessage();
                Message newMsg = Messages.create(sm);
                retPacket.setMessage(newMsg);
            }
            catch (SOAPException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0005_PROBLEM_PROC_SOAP_MESSAGE(), ex);
                return this.doThrow(new WebServiceException(LogStringsMessages.WSSTUBE_0005_PROBLEM_PROC_SOAP_MESSAGE(), (Throwable)ex));
            }
        }
        ProcessingContext ctx = this.initializeOutgoingProcessingContext(retPacket, this.isSCIssueMessage, this.isTrustMessage);
        ctx.setExtraneousProperty("SessionManager", this.sessionManager);
        Message msg = null;
        try {
            msg = retPacket.getMessage();
            if (ctx.getSecurityPolicy() != null && ((MessagePolicy)ctx.getSecurityPolicy()).size() > 0) {
                if (!this.optimized) {
                    SOAPMessage soapMessage = msg.readAsSOAPMessage();
                    soapMessage = this.secureOutboundMessage(soapMessage, ctx);
                    msg = Messages.create(soapMessage);
                } else {
                    msg = this.secureOutboundMessage(msg, ctx);
                }
            }
        }
        catch (WssSoapFaultException ex) {
            msg = Messages.create(this.getSOAPFault(ex));
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0024_ERROR_SECURING_OUTBOUND_MSG(), se);
            NextAction nextAction = this.doThrow(new WebServiceException(LogStringsMessages.WSSTUBE_0024_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)se));
            return nextAction;
        }
        finally {
            if (this.isSCCancel(retPacket)) {
                this.removeContext(this.tmpPacket);
            }
            this.tmpPacket = null;
        }
        this.resetCachedOperation();
        retPacket.setMessage(msg);
        return this.doReturnWith(retPacket);
    }

    @Override
    public NextAction processException(Throwable t) {
        if (!(t instanceof WebServiceException)) {
            t = new WebServiceException(t);
        }
        return this.doThrow(t);
    }

    private void removeContext(Packet packet) {
        String strId;
        SecurityContextToken sct = (SecurityContextToken)packet.invocationProperties.get("Incoming_SCT");
        if (sct != null && (strId = sct.getIdentifier().toString()) != null) {
            this.issuedTokenContextMap.remove(strId);
            this.sessionManager.terminateSession(strId);
        }
    }

    @Override
    public void preDestroy() {
        if (this.next != null) {
            this.next.preDestroy();
        }
        this.issuedTokenContextMap.clear();
        SessionManager.removeSessionManager(((ServerTubeConfiguration)this.tubeConfig).getEndpoint());
        NonceManager.deleteInstance(this.wsEndpoint);
    }

    public Packet processMessage(XMLStreamReaderMessage msg) {
        throw new UnsupportedOperationException();
    }

    public InputStreamMessage processInputStream(XMLStreamReaderMessage msg) {
        throw new UnsupportedOperationException();
    }

    public InputStreamMessage processInputStream(Message msg) {
        throw new UnsupportedOperationException();
    }

    protected ProcessingContext initializeOutgoingProcessingContext(Packet packet, boolean isSCMessage, boolean isTrustMessage) {
        ProcessingContext ctx = this.initializeOutgoingProcessingContext(packet, isSCMessage);
        return ctx;
    }

    @Override
    protected ProcessingContext initializeOutgoingProcessingContext(Packet packet, boolean isSCMessage) {
        ProcessingContextImpl ctx;
        if (this.optimized) {
            ctx = new JAXBFilterProcessingContext(packet.invocationProperties);
            ((JAXBFilterProcessingContext)ctx).setAddressingVersion(this.addVer);
            ((JAXBFilterProcessingContext)ctx).setSOAPVersion(this.soapVersion);
            ((JAXBFilterProcessingContext)ctx).setBSP(this.bsp10);
        } else {
            ctx = new ProcessingContextImpl(packet.invocationProperties);
        }
        if (this.addVer != null) {
            ctx.setAction(this.getAction(packet));
        }
        ctx.setSecurityPolicyVersion(this.spVersion.namespaceUri);
        try {
            MessagePolicy policy;
            if (this.isRMMessage(packet) || this.isMakeConnectionMessage(packet)) {
                SecurityPolicyHolder holder = (SecurityPolicyHolder)this.outProtocolPM.get("RM");
                policy = holder.getMessagePolicy();
            } else if (packet.getMessage().isFault()) {
                policy = this.getOutgoingFaultPolicy(packet);
            } else if (this.isSCCancel(packet)) {
                SecurityPolicyHolder holder = (SecurityPolicyHolder)this.outProtocolPM.get("SC-CANCEL");
                policy = holder.getMessagePolicy();
            } else {
                policy = this.getOutgoingXWSSecurityPolicy(packet, isSCMessage);
            }
            if (policy != null) {
                ctx.setSecurityPolicy(policy);
            }
            if (this.isTrustMessage(packet)) {
                ctx.isTrustMessage(true);
            }
            if (isSCMessage) {
                ctx.setAlgorithmSuite(policy.getAlgorithmSuite());
            } else {
                ctx.setAlgorithmSuite(this.getAlgoSuite(this.getBindingAlgorithmSuite(packet)));
            }
            ctx.setSecurityEnvironment(this.secEnv);
            ctx.isInboundMessage(false);
            ctx.getExtraneousProperties().put("WSDLPort", this.tubeConfig.getWSDLPort());
        }
        catch (XWSSecurityException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0006_PROBLEM_INIT_OUT_PROC_CONTEXT(), e);
            throw new RuntimeException(LogStringsMessages.WSSTUBE_0006_PROBLEM_INIT_OUT_PROC_CONTEXT(), e);
        }
        return ctx;
    }

    @Override
    protected MessagePolicy getOutgoingXWSSecurityPolicy(Packet packet, boolean isSCMessage) {
        SecurityPolicyHolder sph;
        if (isSCMessage) {
            Token scToken = (Token)packet.invocationProperties.get(Constants.SC_ASSERTION);
            return this.getOutgoingXWSBootstrapPolicy(scToken);
        }
        if (this.outMessagePolicyMap == null) {
            return new MessagePolicy();
        }
        if (this.isTrustMessage(packet)) {
            this.cachedOperation = this.getWSDLOpFromAction(packet, false);
        }
        if (this.cachedOperation == null) {
            this.cachedOperation = this.getWSDLOpFromAction(packet, false);
        }
        if ((sph = (SecurityPolicyHolder)this.outMessagePolicyMap.get(this.cachedOperation)) == null) {
            return new MessagePolicy();
        }
        MessagePolicy mp = sph.getMessagePolicy();
        return mp;
    }

    protected MessagePolicy getOutgoingFaultPolicy(Packet packet) {
        if (this.cachedOperation != null) {
            WSDLOperation operation = this.cachedOperation.getOperation();
            QName faultDetail = packet.getMessage().getFirstDetailEntryName();
            WSDLFault fault = null;
            if (faultDetail != null) {
                fault = operation.getFault(faultDetail);
            }
            SecurityPolicyHolder sph = (SecurityPolicyHolder)this.outMessagePolicyMap.get(this.cachedOperation);
            if (fault == null) {
                MessagePolicy faultPolicy1 = sph != null ? sph.getMessagePolicy() : new MessagePolicy();
                return faultPolicy1;
            }
            SecurityPolicyHolder faultPolicyHolder = sph.getFaultPolicy(fault);
            MessagePolicy faultPolicy = faultPolicyHolder == null ? new MessagePolicy() : faultPolicyHolder.getMessagePolicy();
            return faultPolicy;
        }
        return null;
    }

    @Override
    protected SOAPMessage verifyInboundMessage(SOAPMessage message, ProcessingContext ctx) throws WssSoapFaultException, XWSSecurityException {
        ctx.setSOAPMessage(message);
        NewSecurityRecipient.validateMessage(ctx);
        return ctx.getSOAPMessage();
    }

    private Packet invokeSecureConversationContract(Packet packet, ProcessingContext ctx, boolean isSCTIssue, String action) {
        List<PolicyAssertion> policies;
        Message retMsg;
        String retAction;
        IssuedTokenContextImpl ictx = new IssuedTokenContextImpl();
        ictx.getOtherProperties().put("SessionManager", this.sessionManager);
        Message msg = packet.getMessage();
        try {
            BaseSTSResponse rstr;
            Subject subject = SubjectAccessor.getRequesterSubject(ctx);
            ictx.setRequestorSubject(subject);
            WSTrustElementFactory wsscEleFac = WSTrustElementFactory.newInstance(this.wsscVer);
            JAXBElement rstEle = (JAXBElement)msg.readPayloadAsJAXB(WSTrustElementFactory.getContext(this.wsTrustVer).createUnmarshaller());
            RequestSecurityToken rst = wsscEleFac.createRSTFrom(rstEle);
            URI requestType = rst.getRequestType();
            WSSCContract scContract = WSSCFactory.newWSSCContract(this.wsscVer);
            scContract.setWSSCServerConfig((Iterator)packet.invocationProperties.get("http://schemas.sun.com/ws/2006/05/sc/server"));
            if (requestType.toString().equals(this.wsTrustVer.getIssueRequestTypeURI())) {
                List<PolicyAssertion> policies2 = this.getOutBoundSCP(packet.getMessage());
                rstr = scContract.issue(rst, ictx, (SecureConversationToken)((Object)policies2.get(0)));
                retAction = this.wsscVer.getSCTResponseAction();
                SecurityContextToken sct = (SecurityContextToken)ictx.getSecurityToken();
                String sctId = sct.getIdentifier().toString();
                Session session = this.sessionManager.getSession(sctId);
                if (session == null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0029_ERROR_SESSION_CREATION());
                    throw new WSSecureConversationException(LogStringsMessages.WSSTUBE_0029_ERROR_SESSION_CREATION());
                }
                packet.invocationProperties.put("com.sun.xml.ws.sessionid", sctId);
                packet.invocationProperties.put("com.sun.xml.ws.session", session.getUserData());
            } else if (requestType.toString().equals(this.wsTrustVer.getRenewRequestTypeURI())) {
                List<PolicyAssertion> policies3 = this.getOutBoundSCP(packet.getMessage());
                retAction = this.wsscVer.getSCTRenewResponseAction();
                rstr = scContract.renew(rst, ictx, (SecureConversationToken)((Object)policies3.get(0)));
            } else if (requestType.toString().equals(this.wsTrustVer.getCancelRequestTypeURI())) {
                retAction = this.wsscVer.getSCTCancelResponseAction();
                rstr = scContract.cancel(rst, ictx);
            } else {
                log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0030_UNSUPPORTED_OPERATION_EXCEPTION(requestType));
                throw new UnsupportedOperationException(LogStringsMessages.WSSTUBE_0030_UNSUPPORTED_OPERATION_EXCEPTION(requestType));
            }
            retMsg = Messages.create(WSTrustElementFactory.getContext(this.wsTrustVer).createMarshaller(), (Object)wsscEleFac.toJAXBElement(rstr), this.soapVersion);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0031_ERROR_INVOKE_SC_CONTRACT(), ex);
            throw new RuntimeException(LogStringsMessages.WSSTUBE_0031_ERROR_INVOKE_SC_CONTRACT(), ex);
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0001_PROBLEM_MAR_UNMAR(), ex);
            throw new RuntimeException(LogStringsMessages.WSSTUBE_0001_PROBLEM_MAR_UNMAR(), ex);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0031_ERROR_INVOKE_SC_CONTRACT(), ex);
            throw new RuntimeException(LogStringsMessages.WSSTUBE_0031_ERROR_INVOKE_SC_CONTRACT(), ex);
        }
        Packet retPacket = this.addAddressingHeaders(packet, retMsg, retAction);
        if (isSCTIssue && !(policies = this.getOutBoundSCP(packet.getMessage())).isEmpty()) {
            retPacket.invocationProperties.put(Constants.SC_ASSERTION, policies.get(0));
        }
        return retPacket;
    }

    public InputStreamMessage processInputStream(Packet packet) {
        throw new UnsupportedOperationException("Will be supported for optimized path");
    }

    @Override
    protected SecurityPolicyHolder addOutgoingMP(WSDLBoundOperation operation, Policy policy) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, true, true);
        this.inMessagePolicyMap.put(operation, sph);
        return sph;
    }

    @Override
    protected SecurityPolicyHolder addIncomingMP(WSDLBoundOperation operation, Policy policy) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, true, false);
        this.outMessagePolicyMap.put(operation, sph);
        return sph;
    }

    @Override
    protected void addIncomingProtocolPolicy(Policy effectivePolicy, String protocol) throws PolicyException {
        this.outProtocolPM.put(protocol, this.constructPolicyHolder(effectivePolicy, true, false, true));
    }

    @Override
    protected void addOutgoingProtocolPolicy(Policy effectivePolicy, String protocol) throws PolicyException {
        this.inProtocolPM.put(protocol, this.constructPolicyHolder(effectivePolicy, true, true, false));
    }

    @Override
    protected void addIncomingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, true, false);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected void addOutgoingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, true, true);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected String getAction(WSDLOperation operation, boolean inComming) {
        if (inComming) {
            return operation.getInput().getAction();
        }
        return operation.getOutput().getAction();
    }

    private Packet addAddressingHeaders(Packet packet, Message retMsg, String action) {
        Packet retPacket = packet.createServerResponse(retMsg, this.addVer, this.soapVersion, action);
        retPacket.proxy = packet.proxy;
        retPacket.invocationProperties.putAll(packet.invocationProperties);
        return retPacket;
    }

    private CallbackHandler configureServerHandler(Set<PolicyAssertion> configAssertions, Properties props) {
        CallbackHandlerFeature cbFeature = this.tubeConfig.getBinding().getFeature(CallbackHandlerFeature.class);
        if (cbFeature != null) {
            return cbFeature.getHandler();
        }
        String ret = this.populateConfigProperties(configAssertions, props);
        try {
            if (ret != null) {
                Object obj = this.loadClass(ret).newInstance();
                if (!(obj instanceof CallbackHandler)) {
                    log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0033_INVALID_CALLBACK_HANDLER_CLASS(ret));
                    throw new RuntimeException(LogStringsMessages.WSSTUBE_0033_INVALID_CALLBACK_HANDLER_CLASS(ret));
                }
                return (CallbackHandler)obj;
            }
            RealmAuthenticationAdapter adapter = this.getRealmAuthenticationAdapter(((ServerTubeConfiguration)this.tubeConfig).getEndpoint());
            return new DefaultCallbackHandler("server", props, adapter);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0032_ERROR_CONFIGURE_SERVER_HANDLER(), e);
            throw new RuntimeException(LogStringsMessages.WSSTUBE_0032_ERROR_CONFIGURE_SERVER_HANDLER(), e);
        }
    }

    private RealmAuthenticationAdapter getRealmAuthenticationAdapter(WSEndpoint wSEndpoint) {
        Object obj;
        String className = "javax.servlet.ServletContext";
        Class<?> ret = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                ret = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (ret == null) {
            loader = this.getClass().getClassLoader();
            try {
                ret = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (ret != null && (obj = wSEndpoint.getContainer().getSPI(ret)) != null) {
            return RealmAuthenticationAdapter.newInstance(obj);
        }
        return null;
    }

    private void updateSCBootstrapCredentials(Packet packet, ProcessingContext ctx) {
        SecurityContextToken sct = (SecurityContextToken)packet.invocationProperties.get("Incoming_SCT");
        if (sct != null) {
            String sessionId = sct.getIdentifier().toString();
            packet.invocationProperties.put("com.sun.xml.ws.sessionid", sessionId);
            packet.invocationProperties.put("com.sun.xml.ws.session", this.sessionManager.getSession(sessionId).getUserData());
            IssuedTokenContext itctx = this.sessionManager.getSecurityContext(sessionId, true);
            if (itctx != null) {
                Subject from = itctx.getRequestorSubject();
                Subject to = DefaultSecurityEnvironmentImpl.getSubject(packet.invocationProperties);
                SecurityServerTube.copySubject(from, to);
            }
        }
    }

    private static void copySubject(final Subject from, final Subject to) {
        if (from == null || to == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                to.getPrincipals().addAll(from.getPrincipals());
                to.getPublicCredentials().addAll(from.getPublicCredentials());
                to.getPrivateCredentials().addAll(from.getPrivateCredentials());
                return null;
            }
        });
    }

    private static String getMetaINFServiceClass(String metaInfService) {
        URL url = SecurityServerTube.loadFromClasspath(metaInfService);
        if (url != null) {
            InputStream is = null;
            try {
                String classname;
                is = url.openStream();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int val = is.read();
                while (val != -1) {
                    os.write(val);
                    val = is.read();
                }
                String string2 = classname = os.toString();
                return string2;
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new WebServiceException((Throwable)ex);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.log(Level.WARNING, null, ex);
                }
            }
        }
        return null;
    }

    public static URL loadFromClasspath(String configFileName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResource(configFileName);
        }
        return cl.getResource(configFileName);
    }
}

