/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.dsig;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenManager;
import com.sun.xml.ws.runtime.dev.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.impl.DerivedKeyTokenImpl;
import com.sun.xml.ws.security.secconv.impl.client.DefaultSCTokenConfiguration;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.DerivedKeyTokenHeaderBlock;
import com.sun.xml.wss.core.EncryptedKeyToken;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.core.SecurityContextTokenImpl;
import com.sun.xml.wss.core.SecurityToken;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.X509SecurityToken;
import com.sun.xml.wss.core.reference.DirectReference;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.core.reference.X509IssuerSerial;
import com.sun.xml.wss.impl.AlgorithmSuite;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.dsig.SignatureProcessor;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.KeyResolver;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.AssertionUtil;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.util.SAMLUtil;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeySelectorImpl
extends KeySelector {
    private static KeySelectorImpl keyResolver = null;
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");

    private KeySelectorImpl() {
    }

    public static KeySelector getInstance() {
        return keyResolver;
    }

    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (keyInfo == null) {
            if (logger.getLevel() == Level.SEVERE) {
                logger.log(Level.SEVERE, "WSS1317.keyinfo.null");
            }
            throw new KeySelectorException("Null KeyInfo object!");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "KeySelectorResult::select Purpose =  " + purpose);
            logger.log(Level.FINEST, "KeySelectorResult::select Algorithm is " + method.getAlgorithm());
            logger.log(Level.FINEST, "KeySelectorResult::select ParameterSpec is " + method.getParameterSpec());
        }
        try {
            SignatureMethod sm = (SignatureMethod)method;
            List list = keyInfo.getContent();
            FilterProcessingContext wssContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
            SecurityPolicy securityPolicy = wssContext.getSecurityPolicy();
            boolean isBSP = false;
            if (securityPolicy != null) {
                isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
            }
            if (isBSP && list.size() > 1) {
                logger.log(Level.SEVERE, "WSS1350.illegal.BSP.Violation.KeyInfo");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "BSP Violation of R5402: KeyInfo MUST have exactly one child", null);
            }
            boolean isStr = false;
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = (XMLStructure)list.get(i);
                if (xmlStructure instanceof KeyValue) {
                    PublicKey pk = null;
                    try {
                        pk = ((KeyValue)xmlStructure).getPublicKey();
                    }
                    catch (KeyException ke) {
                        logger.log(Level.SEVERE, "WSS1351.exception.keyselector.publickey", ke);
                        throw new KeySelectorException(ke);
                    }
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), pk, false);
                        wssContext.getSecurityEnvironment().validateCertificate(cert, wssContext.getExtraneousProperties());
                    }
                    if (!KeySelectorImpl.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                    return new SimpleKeySelectorResult(pk);
                }
                if (xmlStructure instanceof DOMStructure) {
                    SOAPElement reference = (SOAPElement)((DOMStructure)xmlStructure).getNode();
                    if (!KeySelectorImpl.isSecurityTokenReference(reference)) continue;
                    isStr = true;
                    final Key key = KeySelectorImpl.resolve(reference, context, purpose);
                    return new KeySelectorResult(){

                        public Key getKey() {
                            return key;
                        }
                    };
                }
                if (xmlStructure instanceof KeyName) {
                    KeyName keyName = (KeyName)xmlStructure;
                    SecretKey returnKey = wssContext.getSecurityEnvironment().getSecretKey(wssContext.getExtraneousProperties(), keyName.getName(), false);
                    if (returnKey == null) {
                        X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), keyName.getName(), false);
                        if (cert == null || !KeySelectorImpl.algEquals(sm.getAlgorithm(), cert.getPublicKey().getAlgorithm())) continue;
                        wssContext.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(wssContext), cert);
                        return new SimpleKeySelectorResult(cert.getPublicKey());
                    }
                    return new SimpleKeySelectorResult(returnKey);
                }
                if (!(xmlStructure instanceof X509Data)) continue;
                Key key = KeySelectorImpl.resolveX509Data(wssContext, (X509Data)xmlStructure, purpose);
                return new SimpleKeySelectorResult(key);
            }
            if (isBSP && !isStr) {
                logger.log(Level.SEVERE, "BSP Violation of R5409: Child element of KeyInfo MUST be a STR element");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "BSP Violation of R5409: Child element of KeyInfo MUST be a STR element", null);
            }
        }
        catch (KeySelectorException kse) {
            logger.log(Level.SEVERE, "WSS1352.exception.keyselector", kse);
            throw kse;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WSS1353.unable.resolve.keyInformation", ex.getMessage());
            throw new KeySelectorException(ex);
        }
        logger.log(Level.SEVERE, "WSS1354.null.keyValue");
        throw new KeySelectorException("No KeyValue element found!");
    }

    static boolean algEquals(String algURI, String algName) {
        if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return true;
        }
        return algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Key resolve(SOAPElement securityTokenReference, XMLCryptoContext context, KeySelector.Purpose purpose) throws KeySelectorException {
        try {
            void var17_45;
            AuthenticationTokenPolicy.X509CertificateBinding keyBinding;
            SignaturePolicy inferredSignaturePolicy;
            ReferenceElement refElement;
            boolean isPolicyRecipient;
            FilterProcessingContext wssContext;
            block154: {
                String valueType;
                String uri;
                boolean isSymmetric;
                HashMap tokenCache;
                String encAlgo;
                block156: {
                    String sctId;
                    SecurityToken token;
                    block155: {
                        HashMap insertedX509Cache;
                        boolean isBSP;
                        block150: {
                            Element samlAssertion;
                            String assertionID;
                            KeyIdentifier keyId;
                            SecurityTokenReference str;
                            block148: {
                                block151: {
                                    Element tokenElement;
                                    String assertionID2;
                                    block152: {
                                        Assertion samlAssertion2;
                                        block153: {
                                            wssContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
                                            SecurableSoapMessage secureMsg = wssContext.getSecurableSoapMessage();
                                            AlgorithmSuite algSuite = wssContext.getAlgorithmSuite();
                                            encAlgo = null;
                                            boolean bl = isPolicyRecipient = wssContext.getMode() == 3;
                                            if (algSuite != null) {
                                                encAlgo = algSuite.getEncryptionAlgorithm();
                                            }
                                            SecurityPolicy securityPolicy = wssContext.getSecurityPolicy();
                                            isBSP = false;
                                            if (securityPolicy != null) {
                                                isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
                                            }
                                            str = new SecurityTokenReference(securityTokenReference, isBSP);
                                            refElement = str.getReference();
                                            tokenCache = wssContext.getTokenCache();
                                            insertedX509Cache = wssContext.getInsertedX509Cache();
                                            SignaturePolicy policy = (SignaturePolicy)wssContext.getInferredPolicy();
                                            inferredSignaturePolicy = null;
                                            if (isPolicyRecipient) {
                                                int i = wssContext.getInferredSecurityPolicy().size() - 1;
                                                if (PolicyTypeUtil.signaturePolicy(wssContext.getInferredSecurityPolicy().get(i))) {
                                                    inferredSignaturePolicy = (SignaturePolicy)wssContext.getInferredSecurityPolicy().get(i);
                                                }
                                            }
                                            keyBinding = null;
                                            if (policy != null) {
                                                keyBinding = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
                                            }
                                            Object var17_21 = null;
                                            isSymmetric = false;
                                            if (!(refElement instanceof KeyIdentifier)) break block150;
                                            keyId = (KeyIdentifier)refElement;
                                            if (keyBinding != null) {
                                                keyBinding.setReferenceType("Identifier");
                                                keyBinding.setValueType(keyId.getValueType());
                                            }
                                            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(keyId.getValueType()) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3SubjectKeyIdentifier".equals(keyId.getValueType())) {
                                                if (isPolicyRecipient && inferredSignaturePolicy != null) {
                                                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                                                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                                                    x509Binding.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
                                                    x509Binding.setReferenceType("Identifier");
                                                    if (inferredKB == null) {
                                                        inferredSignaturePolicy.setKeyBinding(x509Binding);
                                                    } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                                                        ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                                                        isSymmetric = true;
                                                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                                                        DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                                                        if (dktBind.getOriginalKeyBinding() == null) {
                                                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                                                        } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                                                            dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                                                            isSymmetric = true;
                                                        }
                                                    }
                                                }
                                                if (purpose != KeySelector.Purpose.VERIFY) {
                                                    if (purpose != KeySelector.Purpose.SIGN) return var17_45;
                                                    PrivateKey privateKey = wssContext.getSecurityEnvironment().getPrivateKey(wssContext.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                                                    return var17_45;
                                                }
                                                byte[] keyIdBytes = XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue());
                                                wssContext.setExtraneousProperty("requester.keyid", new String(keyIdBytes));
                                                X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), keyIdBytes);
                                                if (!isSymmetric) {
                                                    wssContext.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(wssContext), cert);
                                                }
                                                PublicKey publicKey = cert.getPublicKey();
                                                return var17_45;
                                            }
                                            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(keyId.getValueType())) {
                                                if (isPolicyRecipient && inferredSignaturePolicy != null) {
                                                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                                                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                                                    x509Binding.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
                                                    x509Binding.setReferenceType("Identifier");
                                                    if (inferredKB == null) {
                                                        inferredSignaturePolicy.setKeyBinding(x509Binding);
                                                    } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                                                        ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                                                        isSymmetric = true;
                                                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                                                        DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                                                        if (dktBind.getOriginalKeyBinding() == null) {
                                                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                                                        } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                                                            dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                                                            isSymmetric = true;
                                                        }
                                                    }
                                                }
                                                if (purpose != KeySelector.Purpose.VERIFY) {
                                                    if (purpose != KeySelector.Purpose.SIGN) return var17_45;
                                                    PrivateKey privateKey = wssContext.getSecurityEnvironment().getPrivateKey(wssContext.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue()), "Thumbprint");
                                                    return var17_45;
                                                }
                                                byte[] keyIdBytes = XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue());
                                                wssContext.setExtraneousProperty("requester.keyid", new String(keyIdBytes));
                                                X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), keyIdBytes, "Thumbprint");
                                                if (!isSymmetric) {
                                                    wssContext.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(wssContext), cert);
                                                }
                                                PublicKey publicKey = cert.getPublicKey();
                                                return var17_45;
                                            }
                                            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(keyId.getValueType())) {
                                                if (isPolicyRecipient && inferredSignaturePolicy != null) {
                                                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                                                    SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                                                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                                                    x509Binding.setReferenceType("Identifier");
                                                    skBinding.setKeyBinding(x509Binding);
                                                    if (inferredKB == null) {
                                                        inferredSignaturePolicy.setKeyBinding(skBinding);
                                                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                                                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                                                    }
                                                }
                                                String ekSha1RefValue = (String)wssContext.getExtraneousProperty("EncryptedKeySHA1");
                                                Key secretKey = (Key)wssContext.getExtraneousProperty("SecretKey");
                                                String keyRefValue = keyId.getReferenceValue();
                                                if (ekSha1RefValue != null && secretKey != null) {
                                                    if (!ekSha1RefValue.equals(keyRefValue)) return var17_45;
                                                    Key key = secretKey;
                                                    return var17_45;
                                                }
                                                String message = "EncryptedKeySHA1 reference not correct";
                                                logger.log(Level.SEVERE, "WSS1306:unsupported.KeyIdentifier.Reference.Type.encountered", new Object[]{message});
                                                throw new KeySelectorException(message);
                                            }
                                            if (!"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(keyId.getValueType()) && !"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(keyId.getValueType())) break block151;
                                            assertionID2 = keyId.getReferenceValue();
                                            tokenElement = wssContext.getIssuedSAMLToken();
                                            if (tokenElement != null) break block152;
                                            samlAssertion2 = (Assertion)tokenCache.get(assertionID2);
                                            if (samlAssertion2 != null) break block153;
                                            if (str.getSamlAuthorityBinding() != null) {
                                                tokenElement = wssContext.getSecurityEnvironment().locateSAMLAssertion(wssContext.getExtraneousProperties(), str.getSamlAuthorityBinding(), assertionID2, secureMsg.getSOAPPart());
                                                break block152;
                                            } else {
                                                tokenElement = SAMLUtil.locateSamlAssertion(assertionID2, secureMsg.getSOAPPart());
                                                if (!"true".equals((String)wssContext.getExtraneousProperty("Saml_Signature_resolved")) || "false".equals((String)wssContext.getExtraneousProperty("Saml_Signature_resolved"))) {
                                                    wssContext.setExtraneousProperty("Saml_Signature_resolved", "false");
                                                }
                                            }
                                            break block152;
                                        }
                                        try {
                                            tokenElement = samlAssertion2.toElement(null);
                                        }
                                        catch (Exception e) {
                                            logger.log(Level.SEVERE, "WSS1355.unableto.resolve.SAMLAssertion", e.getMessage());
                                            throw new KeySelectorException(e);
                                        }
                                    }
                                    if (isPolicyRecipient && inferredSignaturePolicy != null) {
                                        MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                                        IssuedTokenKeyBinding itkBinding = new IssuedTokenKeyBinding();
                                        if (inferredKB == null) {
                                            if (wssContext.hasIssuedToken()) {
                                                inferredSignaturePolicy.setKeyBinding(itkBinding);
                                            } else {
                                                inferredSignaturePolicy.setKeyBinding(new AuthenticationTokenPolicy.SAMLAssertionBinding());
                                            }
                                        } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(itkBinding);
                                        }
                                    }
                                    Key key = KeySelectorImpl.resolveSamlAssertion(context, tokenElement, purpose, assertionID2);
                                    KeySelectorImpl.addAuthorityId(tokenElement, wssContext);
                                    if (!wssContext.hasIssuedToken()) return var17_45;
                                    if (key == null) return var17_45;
                                    SecurityUtil.initInferredIssuedTokenContext(wssContext, str, key);
                                    return var17_45;
                                }
                                assertionID = keyId.getDecodedReferenceValue();
                                samlAssertion = null;
                                try {
                                    samlAssertion = KeySelectorImpl.resolveSAMLToken(str, assertionID, wssContext);
                                }
                                catch (Exception e) {
                                    if (!logger.isLoggable(Level.FINEST)) break block148;
                                    logger.log(Level.FINEST, "Error occurred while trying to resolve SAML assertion" + e.getMessage());
                                }
                            }
                            if (samlAssertion != null) {
                                if (isPolicyRecipient && inferredSignaturePolicy != null) {
                                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                                    IssuedTokenKeyBinding itkBinding = new IssuedTokenKeyBinding();
                                    if (inferredKB == null) {
                                        if (wssContext.hasIssuedToken()) {
                                            inferredSignaturePolicy.setKeyBinding(itkBinding);
                                        } else {
                                            inferredSignaturePolicy.setKeyBinding(new AuthenticationTokenPolicy.SAMLAssertionBinding());
                                        }
                                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(itkBinding);
                                    }
                                }
                                Key key = KeySelectorImpl.resolveSamlAssertion(context, samlAssertion, purpose, assertionID);
                                KeySelectorImpl.addAuthorityId(samlAssertion, wssContext);
                                if (!wssContext.hasIssuedToken()) return var17_45;
                                if (key == null) return var17_45;
                                SecurityUtil.initInferredIssuedTokenContext(wssContext, str, key);
                                return var17_45;
                            }
                            if (isPolicyRecipient && inferredSignaturePolicy != null) {
                                MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                                AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                                x509Binding.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
                                x509Binding.setReferenceType("Identifier");
                                if (inferredKB == null) {
                                    inferredSignaturePolicy.setKeyBinding(x509Binding);
                                } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                                    ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                                    DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                                    if (dktBind.getOriginalKeyBinding() == null) {
                                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                                    } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                                        dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                                    }
                                }
                            }
                            if (purpose == KeySelector.Purpose.VERIFY) {
                                byte[] keyIdBytes = XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue());
                                wssContext.setExtraneousProperty("requester.keyid", new String(keyIdBytes));
                                X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                                wssContext.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(wssContext), cert);
                                PublicKey publicKey = cert.getPublicKey();
                                return var17_45;
                            }
                            if (purpose != KeySelector.Purpose.SIGN) return var17_45;
                            PrivateKey privateKey = wssContext.getSecurityEnvironment().getPrivateKey(wssContext.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                            return var17_45;
                        }
                        if (!(refElement instanceof DirectReference)) break block154;
                        if (keyBinding != null) {
                            keyBinding.setReferenceType("Direct");
                        }
                        uri = ((DirectReference)refElement).getURI();
                        if (isBSP && !uri.startsWith("#")) {
                            logger.log(Level.SEVERE, "WSS1356.Violation.BSP.R5204");
                            throw new XWSSecurityException("Violation of BSP R5204 : When a SECURITY_TOKEN_REFERENCE uses a Direct Reference to an INTERNAL_SECURITY_TOKEN, it MUST use a Shorthand XPointer Reference");
                        }
                        valueType = ((DirectReference)refElement).getValueType();
                        if ("http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(valueType) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk".equals(valueType)) {
                            valueType = null;
                        }
                        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1".equals(valueType)) {
                            String wsuId;
                            X509SecurityToken token2;
                            if (keyBinding != null) {
                                keyBinding.setValueType(valueType);
                            }
                            if ((token2 = (X509SecurityToken)insertedX509Cache.get(wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri))) == null) {
                                token2 = (X509SecurityToken)KeySelectorImpl.resolveToken(wsuId, context);
                                if (token2 == null) {
                                    logger.log(Level.SEVERE, "WSS1357.unableto.locate.Token");
                                    throw new KeySelectorException("Token with Id " + wsuId + "not found");
                                }
                                tokenCache.put(wsuId, token2);
                            }
                            if (isPolicyRecipient && inferredSignaturePolicy != null) {
                                MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                                AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                                x509Binding.setReferenceType("Direct");
                                x509Binding.setValueType(valueType);
                                if (inferredKB == null) {
                                    inferredSignaturePolicy.setKeyBinding(x509Binding);
                                } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                                    ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                                    isSymmetric = true;
                                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                                    DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                                    if (dktBind.getOriginalKeyBinding() == null) {
                                        dktBind.setOriginalKeyBinding(x509Binding);
                                    } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                                        dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                                        isSymmetric = true;
                                    }
                                }
                            }
                            Key key = KeySelectorImpl.resolveX509Token(wssContext, token2, purpose, isSymmetric);
                            return var17_45;
                        }
                        if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(valueType)) {
                            String wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri);
                            SecurityToken token3 = (SecurityToken)tokenCache.get(wsuId);
                            if (token3 == null) {
                                token3 = KeySelectorImpl.resolveToken(wsuId, context);
                                if (token3 == null) {
                                    logger.log(Level.SEVERE, "WSS1357.unableto.locate.Token");
                                    throw new KeySelectorException("Token with Id " + wsuId + "not found");
                                }
                                tokenCache.put(wsuId, token3);
                            }
                            KeyInfoHeaderBlock kiHB = ((EncryptedKeyToken)token3).getKeyInfo();
                            SecurityTokenReference sectr = kiHB.getSecurityTokenReference(0);
                            SOAPElement se = sectr.getAsSoapElement();
                            ReferenceElement refElem = sectr.getReference();
                            if (isPolicyRecipient && inferredSignaturePolicy != null) {
                                MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                                SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                                AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                                skBinding.setKeyBinding(x509Binding);
                                if (inferredKB == null) {
                                    inferredSignaturePolicy.setKeyBinding(skBinding);
                                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                                    ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                                }
                            }
                            Key privKey = KeySelectorImpl.resolve(se, context, KeySelector.Purpose.SIGN);
                            Element cipherData = (Element)((EncryptedKeyToken)token3).getAsSoapElement().getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "CipherData", "xenc")).next();
                            String cipherValue = cipherData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0).getTextContent();
                            byte[] decodedCipher = Base64.decode(cipherValue);
                            byte[] ekSha1 = MessageDigest.getInstance("SHA-1").digest(decodedCipher);
                            String encEkSha1 = Base64.encode(ekSha1);
                            wssContext.setExtraneousProperty("EKSHA1Value", encEkSha1);
                            Key key = ((EncryptedKeyToken)token3).getSecretKey(privKey, encAlgo);
                            wssContext.setExtraneousProperty("SecretKeyValue", key);
                            return var17_45;
                        }
                        if ("http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(valueType)) break block155;
                        if (!"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(valueType)) break block156;
                    }
                    if ((token = (SecurityToken)tokenCache.get(sctId = SecurableSoapMessage.getIdFromFragmentRef(uri))) == null) {
                        token = SecurityUtil.locateBySCTId(wssContext, uri);
                        if (token == null) {
                            token = KeySelectorImpl.resolveToken(sctId, context);
                        }
                        if (token == null) {
                            logger.log(Level.SEVERE, "WSS1358.unableto.locate.SCTToken");
                            throw new KeySelectorException("SCT Token with Id " + sctId + "not found");
                        }
                        tokenCache.put(sctId, token);
                    }
                    if (!(token instanceof SecurityContextToken)) {
                        logger.log(Level.SEVERE, "WSS1359.invalid.valuetype.nonSCTtoken");
                        throw new KeySelectorException("Incorrect ValueType: http://schemas.xmlsoap.org/ws/2005/02/sc/sct, specified for a Non SCT Token");
                    }
                    if (isPolicyRecipient && inferredSignaturePolicy != null) {
                        MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                        SecureConversationTokenKeyBinding sctBinding = new SecureConversationTokenKeyBinding();
                        if (inferredKB == null) {
                            inferredSignaturePolicy.setKeyBinding(sctBinding);
                        } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(sctBinding);
                        }
                    }
                    Key key = KeySelectorImpl.resolveSCT(wssContext, (SecurityContextTokenImpl)token, purpose);
                    return var17_45;
                }
                if (null != valueType) {
                    logger.log(Level.SEVERE, "WSS1307.unsupported.directref.mechanism", new Object[]{((DirectReference)refElement).getValueType()});
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "unsupported directreference ValueType " + ((DirectReference)refElement).getValueType(), null);
                }
                String wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri);
                SecurityToken token = (SecurityToken)tokenCache.get(wsuId);
                if (token == null) {
                    token = KeySelectorImpl.resolveToken(wsuId, context);
                    if (token == null) {
                        token = SecurityUtil.locateBySCTId(wssContext, uri);
                    }
                    if (token == null) {
                        logger.log(Level.SEVERE, "WSS1357.unableto.locate.Token");
                        throw new KeySelectorException("Token with Id " + wsuId + "not found");
                    }
                    tokenCache.put(wsuId, token);
                }
                if (token instanceof X509SecurityToken) {
                    if (isPolicyRecipient && inferredSignaturePolicy != null) {
                        MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                        AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                        x509Binding.setReferenceType("Direct");
                        if (inferredKB == null) {
                            inferredSignaturePolicy.setKeyBinding(x509Binding);
                        } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                            ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                            isSymmetric = true;
                        } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                            DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                            if (dktBind.getOriginalKeyBinding() == null) {
                                dktBind.setOriginalKeyBinding(x509Binding);
                            } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                                dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                                isSymmetric = true;
                            }
                        }
                    }
                    Key key = KeySelectorImpl.resolveX509Token(wssContext, (X509SecurityToken)token, purpose, isSymmetric);
                    return var17_45;
                }
                if (token instanceof EncryptedKeyToken) {
                    if (isPolicyRecipient && inferredSignaturePolicy != null) {
                        MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                        SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                        AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                        skBinding.setKeyBinding(x509Binding);
                        if (inferredKB == null) {
                            inferredSignaturePolicy.setKeyBinding(skBinding);
                        } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                        }
                    }
                    KeyInfoHeaderBlock kiHB = ((EncryptedKeyToken)token).getKeyInfo();
                    SecurityTokenReference sectr = kiHB.getSecurityTokenReference(0);
                    SOAPElement se = sectr.getAsSoapElement();
                    ReferenceElement refElem = sectr.getReference();
                    Key privKey = KeySelectorImpl.resolve(se, context, KeySelector.Purpose.SIGN);
                    Element cipherData = (Element)((EncryptedKeyToken)token).getAsSoapElement().getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "CipherData", "xenc")).next();
                    String cipherValue = cipherData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0).getTextContent();
                    byte[] decodedCipher = Base64.decode(cipherValue);
                    byte[] ekSha1 = MessageDigest.getInstance("SHA-1").digest(decodedCipher);
                    String encEkSha1 = Base64.encode(ekSha1);
                    wssContext.setExtraneousProperty("EKSHA1Value", encEkSha1);
                    Key key = ((EncryptedKeyToken)token).getSecretKey(privKey, encAlgo);
                    wssContext.setExtraneousProperty("SecretKeyValue", key);
                    return var17_45;
                }
                if (token instanceof SecurityContextToken) {
                    if (isPolicyRecipient && inferredSignaturePolicy != null) {
                        MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                        SecureConversationTokenKeyBinding sctBinding = new SecureConversationTokenKeyBinding();
                        if (inferredKB == null) {
                            inferredSignaturePolicy.setKeyBinding(sctBinding);
                        } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(sctBinding);
                        }
                    }
                    Key key = KeySelectorImpl.resolveSCT(wssContext, (SecurityContextTokenImpl)token, purpose);
                    return var17_45;
                }
                if (!(token instanceof DerivedKeyTokenHeaderBlock)) {
                    String message = " Cannot Resolve URI " + uri;
                    logger.log(Level.SEVERE, "WSS1307.unsupported.directref.mechanism", new Object[]{message});
                    KeySelectorException xwsse = new KeySelectorException(message);
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, xwsse.getMessage(), xwsse);
                }
                if (isPolicyRecipient && inferredSignaturePolicy != null) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    DerivedTokenKeyBinding dtkBinding = new DerivedTokenKeyBinding();
                    if (inferredKB == null) {
                        inferredSignaturePolicy.setKeyBinding(dtkBinding);
                    } else if (!PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                        logger.log(Level.SEVERE, "WSS1360.invalid.DerivedKeyToken");
                        throw new XWSSecurityException("A derived Key Token should be a top level key binding");
                    }
                }
                Key key = KeySelectorImpl.resolveDKT(context, (DerivedKeyTokenHeaderBlock)token);
                return var17_45;
            }
            if (!(refElement instanceof X509IssuerSerial)) {
                logger.log(Level.SEVERE, "WSS1308.unsupported.reference.mechanism");
                KeySelectorException xwsse = new KeySelectorException("Key reference mechanism not supported");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
            }
            if (keyBinding != null) {
                keyBinding.setReferenceType("IssuerSerialNumber");
            }
            X509IssuerSerial xisElement = (X509IssuerSerial)refElement;
            BigInteger serialNumber = xisElement.getSerialNumber();
            String issuerName = xisElement.getIssuerName();
            if (isPolicyRecipient && inferredSignaturePolicy != null) {
                MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                x509Binding.setReferenceType("IssuerSerialNumber");
                if (inferredKB == null) {
                    inferredSignaturePolicy.setKeyBinding(x509Binding);
                } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                    ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                    DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                    if (dktBind.getOriginalKeyBinding() == null) {
                        dktBind.setOriginalKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                        dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                    }
                }
            }
            if (purpose == KeySelector.Purpose.VERIFY) {
                wssContext.setExtraneousProperty("requester.serial", serialNumber);
                wssContext.setExtraneousProperty("requester.issuername", issuerName);
                X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), serialNumber, issuerName);
                wssContext.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(wssContext), cert);
                PublicKey publicKey = cert.getPublicKey();
                return var17_45;
            }
            if (purpose != KeySelector.Purpose.SIGN) return var17_45;
            PrivateKey privateKey = wssContext.getSecurityEnvironment().getPrivateKey(wssContext.getExtraneousProperties(), serialNumber, issuerName);
            return var17_45;
        }
        catch (XWSSecurityException xwsExp) {
            logger.log(Level.SEVERE, "WSS1353.unable.resolve.keyInformation", xwsExp);
            throw new KeySelectorException(xwsExp);
        }
        catch (MarshalException me) {
            logger.log(Level.SEVERE, "WSS1353.unable.resolve.keyInformation", me);
            throw new KeySelectorException(me);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WSS1353.unable.resolve.keyInformation", ex);
            throw new KeySelectorException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Key resolveSamlAssertion(XMLCryptoContext dsigContext, Element samlAssertion, KeySelector.Purpose purpose, String assertionID) throws MarshalException, KeySelectorException, XWSSecurityException {
        FilterProcessingContext context = (FilterProcessingContext)dsigContext.get("http://wss.sun.com#processingContext");
        String samlSignatureResolved = (String)context.getExtraneousProperty("Saml_Signature_resolved");
        Element elem = null;
        Key key = (Key)context.getSamlIdVSKeyCache().get(assertionID);
        if (key != null) {
            return key;
        }
        if (samlAssertion == null) {
            logger.log(Level.SEVERE, "WSS1355.unableto.resolve.SAMLAssertion");
            throw new XWSSecurityException("Cannot Resolve SAML Assertion");
        }
        if (purpose == KeySelector.Purpose.VERIFY || "false".equals(samlSignatureResolved)) {
            NodeList nl = samlAssertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() == 0) {
                XWSSecurityException e = new XWSSecurityException("Unsigned SAML Assertion encountered");
                logger.log(Level.SEVERE, "WSS1309.saml.signature.verify.failed", e);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Exception during Signature verfication in SAML Assertion", e);
            }
            boolean topLevelSigElement = false;
            int returnSigNodeIndex = 0;
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getParentNode().getParentNode().getLocalName().equals("Advice")) {
                    continue;
                }
                topLevelSigElement = true;
                returnSigNodeIndex = i;
                break;
            }
            if (!topLevelSigElement) {
                XWSSecurityException e = new XWSSecurityException("Unsigned SAML Assertion encountered");
                logger.log(Level.SEVERE, "WSS1309.saml.signature.verify.failed", e);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Exception during Signature verfication in SAML Assertion", e);
            }
            elem = (Element)nl.item(returnSigNodeIndex);
            SignaturePolicy policy = (SignaturePolicy)context.getInferredPolicy();
            AuthenticationTokenPolicy.SAMLAssertionBinding keyBinding = null;
            if (policy != null) {
                keyBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.newSAMLAssertionKeyBinding();
            }
            try {
                if (!SignatureProcessor.verifySignature(elem, context)) {
                    logger.log(Level.SEVERE, "WSS1310.saml.signature.invalid");
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "SAML Assertion has invalid Signature", new Exception("SAML Assertion has invalid Signature"));
                }
            }
            catch (XWSSecurityException ex) {
                logger.log(Level.SEVERE, "WSS1310.saml.signature.invalid");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "SAML Assertion has invalid Signature", ex);
            }
        }
        if ("false".equals(samlSignatureResolved)) {
            context.setExtraneousProperty("Saml_Signature_resolved", "true");
        }
        Element keyInfoElem = AssertionUtil.getSubjectConfirmationKeyInfo(samlAssertion);
        KeyInfo keyInfo = KeyInfoFactory.getInstance().unmarshalKeyInfo(new DOMStructure(keyInfoElem));
        List keyInfoList = keyInfo.getContent();
        Iterator content = keyInfoList.iterator();
        if (content.hasNext()) {
            Object data = content.next();
            if (data instanceof KeyName) {
                logger.log(Level.SEVERE, "WSS1361.unsupported.KeyName.SAML");
                throw new XWSSecurityException("Unsupported KeyName under SAML SubjectConfirmation");
            }
            if (data instanceof KeyValue) {
                key = KeySelectorImpl.resolveKeyValue(context, (KeyValue)data, purpose);
            } else if (data instanceof X509Data) {
                key = KeySelectorImpl.resolveSAMLX509Data(context, (X509Data)data, purpose);
            } else {
                if (!(data instanceof DOMStructure)) {
                    logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                    throw new KeySelectorException("Unsupported Key Information");
                }
                SOAPElement reference = (SOAPElement)((DOMStructure)data).getNode();
                if (KeySelectorImpl.isSecurityTokenReference(reference)) {
                    key = KeySelectorImpl.resolve(reference, dsigContext, purpose);
                } else if (SecurityUtil.isBinarySecret(reference)) {
                    BinarySecret bs = null;
                    try {
                        bs = WSTrustElementFactory.newInstance().createBinarySecret(reference);
                    }
                    catch (WSTrustException ex) {
                        logger.log(Level.SEVERE, "WSS1362.exception.WSTrust.CreatingBinarySecret", ex);
                        throw new XWSSecurityException(ex);
                    }
                    if (bs.getType() != null && !bs.getType().equals("http://schemas.xmlsoap.org/ws/2005/02/trust/SymmetricKey")) {
                        logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                        throw new KeySelectorException("Unsupported wst:BinarySecret Type");
                    }
                    String algo = "AES";
                    if (context.getAlgorithmSuite() != null) {
                        algo = SecurityUtil.getSecretKeyAlgorithm(context.getAlgorithmSuite().getEncryptionAlgorithm());
                    }
                    key = new SecretKeySpec(bs.getRawValue(), algo);
                } else {
                    if (!SecurityUtil.isEncryptedKey(reference)) {
                        logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                        throw new KeySelectorException("Unsupported Key Information");
                    }
                    EncryptedKeyToken ekToken = new EncryptedKeyToken(reference);
                    KeyInfoHeaderBlock kiHB = ekToken.getKeyInfo();
                    if (!kiHB.containsSecurityTokenReference()) {
                        logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                        throw new KeySelectorException("Unsupported Key Information Inside EncryptedKey");
                    }
                    Key privKey = KeyResolver.processSTR(kiHB, false, context);
                    String dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
                    if (context.getAlgorithmSuite() != null) {
                        dataEncAlgo = context.getAlgorithmSuite().getEncryptionAlgorithm();
                    }
                    key = ekToken.getSecretKey(privKey, dataEncAlgo);
                }
            }
        }
        context.getSamlIdVSKeyCache().put(assertionID, key);
        context.setExtraneousProperty("incoming_saml_assertion", samlAssertion);
        try {
            context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), AssertionUtil.fromElement(samlAssertion));
            return key;
        }
        catch (SAMLException ex) {
            // empty catch block
        }
        return key;
    }

    private static Key resolveKeyValue(FilterProcessingContext context, KeyValue keyValue, KeySelector.Purpose purpose) throws KeySelectorException {
        try {
            if (purpose == KeySelector.Purpose.VERIFY) {
                return keyValue.getPublicKey();
            }
            if (purpose == KeySelector.Purpose.SIGN) {
                return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), keyValue.getPublicKey(), true);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WSS1313.illegal.key.value", e.getMessage());
            throw new KeySelectorException(e);
        }
        return null;
    }

    private static Key resolveX509Data(FilterProcessingContext context, X509Data x509Data, KeySelector.Purpose purpose) throws KeySelectorException {
        X509Certificate cert = null;
        try {
            List data = x509Data.getContent();
            for (Object content : data) {
                if (content instanceof X509Certificate) {
                    cert = (X509Certificate)content;
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        context.getSecurityEnvironment().validateCertificate(cert, context.getExtraneousProperties());
                        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                        return cert.getPublicKey();
                    }
                    if (purpose != KeySelector.Purpose.SIGN) continue;
                    return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
                }
                if (content instanceof byte[]) {
                    byte[] ski = (byte[])content;
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), ski);
                        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                        return cert.getPublicKey();
                    }
                    if (purpose != KeySelector.Purpose.SIGN) continue;
                    return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), ski);
                }
                if (content instanceof String) {
                    logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                    throw new KeySelectorException("X509SubjectName child element of X509Data is not yet supported by our implementation");
                }
                if (content instanceof javax.xml.crypto.dsig.keyinfo.X509IssuerSerial) {
                    javax.xml.crypto.dsig.keyinfo.X509IssuerSerial xis = (javax.xml.crypto.dsig.keyinfo.X509IssuerSerial)content;
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), xis.getSerialNumber(), xis.getIssuerName());
                        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                        return cert.getPublicKey();
                    }
                    if (purpose != KeySelector.Purpose.SIGN) continue;
                    return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), xis.getSerialNumber(), xis.getIssuerName());
                }
                logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                throw new KeySelectorException("Unsupported child element of X509Data encountered");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WSS1314.illegal.x509.data", e.getMessage());
            throw new KeySelectorException(e);
        }
        return null;
    }

    private static Key resolveSAMLX509Data(FilterProcessingContext context, X509Data x509Data, KeySelector.Purpose purpose) throws KeySelectorException {
        X509Certificate cert = null;
        try {
            List data = x509Data.getContent();
            Iterator iterator = data.iterator();
            if (iterator.hasNext()) {
                Object content = iterator.next();
                if (content instanceof X509Certificate) {
                    cert = (X509Certificate)content;
                    context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        return cert.getPublicKey();
                    }
                    return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
                }
                if (content instanceof byte[]) {
                    byte[] ski = (byte[])content;
                    cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), ski);
                    context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        return cert.getPublicKey();
                    }
                    return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
                }
                if (content instanceof String) {
                    logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                    throw new KeySelectorException("X509SubjectName child element of X509Data is not yet supported by our implementation");
                }
                if (content instanceof javax.xml.crypto.dsig.keyinfo.X509IssuerSerial) {
                    javax.xml.crypto.dsig.keyinfo.X509IssuerSerial xis = (javax.xml.crypto.dsig.keyinfo.X509IssuerSerial)content;
                    cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), xis.getSerialNumber(), xis.getIssuerName());
                    context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        return cert.getPublicKey();
                    }
                    return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
                }
                logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                throw new KeySelectorException("Unsupported child element of X509Data encountered");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WSS1314.illegal.x509.data", e.getMessage());
            throw new KeySelectorException(e);
        }
        return null;
    }

    private static Key resolveX509Token(FilterProcessingContext context, X509SecurityToken token, KeySelector.Purpose purpose, boolean isSymmetric) throws XWSSecurityException {
        if (purpose == KeySelector.Purpose.VERIFY) {
            X509Certificate cert = token.getCertificate();
            if (!isSymmetric) {
                context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
            }
            return cert.getPublicKey();
        }
        if (purpose == KeySelector.Purpose.SIGN || purpose == KeySelector.Purpose.DECRYPT) {
            return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), token.getCertificate());
        }
        return null;
    }

    private static boolean isSecurityTokenReference(Element reference) {
        return "SecurityTokenReference".equals(reference.getLocalName());
    }

    protected static SecurityToken resolveToken(final String uri, XMLCryptoContext context) throws URIReferenceException, XWSSecurityException {
        URIDereferencer resolver = context.getURIDereferencer();
        URIReference uriRef = new URIReference(){

            public String getURI() {
                return uri;
            }

            public String getType() {
                return null;
            }
        };
        FilterProcessingContext wssContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
        SecurityPolicy securityPolicy = wssContext.getSecurityPolicy();
        boolean isBSP = false;
        if (securityPolicy != null) {
            isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
        }
        try {
            NodeSetData set = (NodeSetData)resolver.dereference(uriRef, context);
            Iterator itr = set.iterator();
            while (itr.hasNext()) {
                Node node = (Node)itr.next();
                if ("BinarySecurityToken".equals(node.getLocalName())) {
                    X509SecurityToken token = new X509SecurityToken((SOAPElement)node, isBSP);
                    X509Certificate cert = null;
                    try {
                        cert = token.getCertificate();
                    }
                    catch (XWSSecurityException xwe) {
                        logger.log(Level.SEVERE, "WSS1363.invalid.security.token");
                        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "A Invalid security token was provided ", xwe);
                    }
                    if (!wssContext.getSecurityEnvironment().validateCertificate(cert, wssContext.getExtraneousProperties())) {
                        logger.log(Level.SEVERE, "WSS1364.unableto.validate.certificate");
                        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Certificate validation failed", null);
                    }
                    return token;
                }
                if ("EncryptedKey".equals(node.getLocalName())) {
                    return new EncryptedKeyToken((SOAPElement)node);
                }
                if ("SecurityContextToken".equals(node.getLocalName())) {
                    return new SecurityContextTokenImpl((SOAPElement)node);
                }
                if (!"DerivedKeyToken".equals(node.getLocalName())) continue;
                return new DerivedKeyTokenHeaderBlock((SOAPElement)node);
            }
        }
        catch (URIReferenceException ure) {
            logger.log(Level.SEVERE, "WSS1304.FC_SECURITY_TOKEN_UNAVAILABLE", ure);
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", ure);
        }
        logger.log(Level.SEVERE, "WSS1305.UnSupported.security.token");
        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, "A Unsupported token was provided ", null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Element resolveSAMLToken(SecurityTokenReference tokenRef, String assertionId, FilterProcessingContext context) throws XWSSecurityException {
        Element tokenElement = context.getIssuedSAMLToken();
        if (tokenElement != null) {
            context.setExtraneousProperty("Saml_Signature_resolved", "false");
        }
        if (tokenElement == null) {
            if (tokenRef.getSamlAuthorityBinding() != null) {
                tokenElement = context.getSecurityEnvironment().locateSAMLAssertion(context.getExtraneousProperties(), tokenRef.getSamlAuthorityBinding(), assertionId, context.getSOAPMessage().getSOAPPart());
            } else {
                tokenElement = SAMLUtil.locateSamlAssertion(assertionId, context.getSOAPMessage().getSOAPPart());
                if (!"true".equals((String)context.getExtraneousProperty("Saml_Signature_resolved")) || "false".equals((String)context.getExtraneousProperty("Saml_Signature_resolved"))) {
                    context.setExtraneousProperty("Saml_Signature_resolved", "false");
                }
            }
        }
        try {
            if (!"EncryptedData".equals(tokenElement.getLocalName())) return tokenElement;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WSS1355.unableto.resolve.SAMLAssertion", e);
            throw new XWSSecurityException(e);
        }
        return tokenElement;
    }

    private static void addAuthorityId(Element assertion, FilterProcessingContext fp) {
        String issuer = null;
        SignaturePolicy ep = (SignaturePolicy)fp.getInferredPolicy();
        if (ep != null) {
            AuthenticationTokenPolicy.SAMLAssertionBinding kb = (AuthenticationTokenPolicy.SAMLAssertionBinding)ep.newSAMLAssertionKeyBinding();
            if (assertion.getAttributeNode("ID") != null) {
                NodeList nl = assertion.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer");
                Element issuerElement = (Element)nl.item(0);
                issuer = issuerElement.getTextContent();
            } else {
                issuer = assertion.getAttribute("Issuer");
            }
            kb.setAuthorityIdentifier(issuer);
        }
    }

    private static Key resolveSCT(FilterProcessingContext context, SecurityContextTokenImpl token, KeySelector.Purpose purpose) throws XWSSecurityException {
        Subject subj;
        context.setExtraneousProperty("Incoming_SCT", token);
        String scId = token.getSCId();
        IssuedTokenContext ctx = null;
        String protocol = context.getWSSCVersion(context.getSecurityPolicyVersion());
        if (context.isClient()) {
            DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(protocol, scId, !context.isExpired(), !context.isInboundMessage());
            ctx = IssuedTokenManager.getInstance().createIssuedTokenContext(config, null);
            try {
                IssuedTokenManager.getInstance().getIssuedToken(ctx);
            }
            catch (WSTrustException e) {
                throw new XWSSecurityException(e);
            }
        } else {
            ctx = ((SessionManager)context.getExtraneousProperty("SessionManager")).getSecurityContext(scId, !context.isExpired());
            SecurityContextToken sct = (SecurityContextToken)ctx.getSecurityToken();
            ctx.setSecurityToken(WSTrustElementFactory.newInstance(protocol).createSecurityContextToken(sct.getIdentifier(), sct.getInstance(), sct.getWsuId()));
        }
        if (ctx == null) {
            logger.log(Level.SEVERE, "WSS1365.unableto.locate.SecureConversation.Session");
            throw new XWSSecurityException("Could not locate SecureConversation session for Id:" + scId);
        }
        byte[] proofKey = null;
        SecurityContextToken scToken = (SecurityContextToken)ctx.getSecurityToken();
        if (scToken.getInstance() != null) {
            if (context.isExpired()) {
                proofKey = ctx.getProofKey();
            } else {
                SecurityContextTokenInfo sctInstanceInfo = ctx.getSecurityContextTokenInfo();
                proofKey = sctInstanceInfo.getInstanceSecret(scToken.getInstance());
            }
        } else {
            proofKey = ctx.getProofKey();
        }
        if (proofKey == null) {
            logger.log(Level.SEVERE, "WSS1365.unableto.locate.SecureConversation.Session");
            throw new XWSSecurityException("Could not locate SecureConversation session for Id:" + scId);
        }
        String algo = "AES";
        if (context.getAlgorithmSuite() != null) {
            algo = SecurityUtil.getSecretKeyAlgorithm(context.getAlgorithmSuite().getEncryptionAlgorithm());
        }
        SecretKeySpec key = new SecretKeySpec(proofKey, algo);
        if (purpose == KeySelector.Purpose.VERIFY && (subj = ctx.getRequestorSubject()) != null && context.getExtraneousProperty("SCBOOTSTRAP_CRED_IN_SUBJ") == null) {
            context.getSecurityEnvironment().updateOtherPartySubject(SecurityUtil.getSubject(context.getExtraneousProperties()), subj);
            context.getExtraneousProperties().put("SCBOOTSTRAP_CRED_IN_SUBJ", "true");
        }
        return key;
    }

    private static Key resolveDKT(XMLCryptoContext context, DerivedKeyTokenHeaderBlock token) throws XWSSecurityException {
        FilterProcessingContext wssContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
        AlgorithmSuite algSuite = wssContext.getAlgorithmSuite();
        String algorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        if (algSuite != null) {
            algorithm = algSuite.getEncryptionAlgorithm();
        }
        try {
            SecurityTokenReference sectr = token.getDerivedKeyElement();
            SOAPElement se = sectr.getAsSoapElement();
            Key encKey = KeySelectorImpl.resolve(se, context, KeySelector.Purpose.SIGN);
            byte[] secret = encKey.getEncoded();
            byte[] nonce = token.getNonce();
            long length = token.getLength();
            long offset = token.getOffset();
            String label = token.getLabel();
            DerivedKeyTokenImpl dkt = new DerivedKeyTokenImpl(offset, length, secret, nonce, label);
            String jceAlgo = SecurityUtil.getSecretKeyAlgorithm(algorithm);
            SecretKey returnKey = dkt.generateSymmetricKey(jceAlgo);
            return returnKey;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WSS1366.unable.generateSymmetricKey.DKT", e);
            throw new XWSSecurityException(e);
        }
    }

    static {
        keyResolver = new KeySelectorImpl();
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private Key pk;

        SimpleKeySelectorResult(Key pk) {
            this.pk = pk;
        }

        public Key getKey() {
            return this.pk;
        }
    }
}

