/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.localization.LocalizationMessages;
import com.sun.xml.ws.rx.mc.runtime.MakeConnectionSenderTask;
import com.sun.xml.ws.rx.mc.runtime.McConfiguration;
import com.sun.xml.ws.rx.mc.runtime.McResponseHandlerBase;
import com.sun.xml.ws.rx.mc.runtime.spi.ProtocolMessageHandler;
import com.sun.xml.ws.rx.util.ResumeFiberException;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import java.util.Map;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WsMcResponseHandler
extends McResponseHandlerBase {
    private static final Logger LOGGER = Logger.getLogger(WsMcResponseHandler.class);
    private final Map<String, ProtocolMessageHandler> actionToProtocolHandlerMap;

    public WsMcResponseHandler(McConfiguration configuration, MakeConnectionSenderTask mcSenderTask, SuspendedFiberStorage suspendedFiberStorage, Map<String, ProtocolMessageHandler> protocolHandlerMap) {
        super(configuration, mcSenderTask, suspendedFiberStorage);
        this.actionToProtocolHandlerMap = protocolHandlerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletion(Packet response) {
        try {
            Header wsaRelatesToHeader;
            Message responseMessage = response.getMessage();
            if (responseMessage == null) {
                LOGGER.warning(LocalizationMessages.WSMC_0112_NO_RESPONSE_RETURNED());
                return;
            }
            if (!responseMessage.hasHeaders()) {
                LOGGER.severe(LocalizationMessages.WSMC_0113_NO_WSMC_HEADERS_IN_RESPONSE());
                return;
            }
            super.processMakeConnectionHeaders(responseMessage);
            if (responseMessage.isFault()) {
                String faultAction = responseMessage.getHeaders().getAction(this.configuration.getAddressingVersion(), this.configuration.getSoapVersion());
                if (this.configuration.getMcVersion().isMcFault(faultAction)) {
                    SOAPFault fault = null;
                    try {
                        fault = responseMessage.readAsSOAPMessage().getSOAPBody().getFault();
                    }
                    catch (SOAPException ex) {
                        throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSMC_0114_ERROR_UNMARSHALLING_SOAP_FAULT(), ex))));
                    }
                    throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSMC_0115_UNEXPECTED_PROTOCOL_ERROR(fault.getFaultString())))));
                }
            }
            if ((wsaRelatesToHeader = responseMessage.getHeaders().get(this.configuration.getAddressingVersion().relatesToTag, false)) != null) {
                this.setCorrelationId(wsaRelatesToHeader.getStringContent());
                try {
                    this.resumeParentFiber(response);
                }
                catch (ResumeFiberException ex) {
                    LOGGER.warning(LocalizationMessages.WSMC_0116_RESUME_PARENT_FIBER_ERROR(), (Throwable)((Object)ex));
                }
            }
            LOGGER.finer(LocalizationMessages.WSMC_0117_PROCESSING_RESPONSE_AS_PROTOCOL_MESSAGE());
            Header wsaActionHeader = responseMessage.getHeaders().get(this.configuration.getAddressingVersion().actionTag, false);
            if (wsaActionHeader != null) {
                String wsaAction = wsaActionHeader.getStringContent();
                ProtocolMessageHandler handler = this.actionToProtocolHandlerMap.get(wsaAction);
                if (handler != null) {
                    LOGGER.finer(LocalizationMessages.WSMC_0118_PROCESSING_RESPONSE_IN_PROTOCOL_HANDLER(wsaAction, handler.getClass().getName()));
                    handler.processProtocolMessage(response);
                } else {
                    LOGGER.warning(LocalizationMessages.WSMC_0119_UNABLE_TO_FIND_PROTOCOL_HANDLER(wsaAction));
                }
            } else {
                LOGGER.severe(LocalizationMessages.WSMC_0120_WSA_ACTION_HEADER_MISSING());
            }
        }
        finally {
            this.mcSenderTask.clearMcRequestPendingFlag();
        }
    }

    @Override
    public void onCompletion(Throwable error) {
        try {
            throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSMC_0121_FAILED_TO_SEND_WSMC_REQUEST(), error))));
        }
        catch (Throwable throwable) {
            this.mcSenderTask.clearMcRequestPendingFlag();
            throw throwable;
        }
    }
}

