/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.client;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.assembler.ClientTubelineAssemblyContext;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.tx.at.ATCoordinator;
import com.sun.xml.ws.tx.client.LocalizationMessages;
import com.sun.xml.ws.tx.common.ATAssertion;
import com.sun.xml.ws.tx.common.StatefulWebserviceFactoryFactory;
import com.sun.xml.ws.tx.common.TxBasePipe;
import com.sun.xml.ws.tx.common.TxJAXBContext;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.coordinator.ContextFactory;
import com.sun.xml.ws.tx.coordinator.CoordinationContextInterface;
import com.sun.xml.ws.tx.coordinator.CoordinationManager;
import com.sun.xml.ws.tx.webservice.member.coord.CoordinationContext;
import com.sun.xml.ws.tx.webservice.member.coord.CoordinationContextType;
import java.util.logging.Level;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class TxClientPipe
extends TxBasePipe {
    private static TxLogger logger = TxLogger.getCoordLogger(TxClientPipe.class);
    final QName COORD_CTX_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/10/wscoor", "CoordinationContext");
    private final PolicyMap policyMap;
    private final WSDLPort wsdlPort;
    private final SOAPVersion soapVersion;
    private Marshaller marshaller;
    private static boolean reportCheckCurrentJTAStacktrace = true;

    public TxClientPipe(ClientTubelineAssemblyContext context, Pipe next) {
        super(next);
        this.policyMap = context.getPolicyMap();
        this.wsdlPort = context.getWsdlPort();
        this.soapVersion = context.getBinding().getSOAPVersion();
        this.marshaller = TxJAXBContext.createMarshaller();
    }

    private TxClientPipe(TxClientPipe orig, PipeCloner cloner) {
        super(cloner.copy(orig.next));
        cloner.add(orig, this);
        this.policyMap = orig.policyMap;
        this.wsdlPort = orig.wsdlPort;
        this.soapVersion = orig.soapVersion;
        this.marshaller = TxJAXBContext.createMarshaller();
    }

    public Pipe copy(PipeCloner cloner) {
        return new TxClientPipe(this, cloner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet process(Packet pkt) {
        Packet responsePacket;
        block19: {
            Message msg = pkt.getMessage();
            responsePacket = null;
            Transaction currentTxn = this.checkCurrentJTATransaction(msg, this.wsdlPort);
            if (currentTxn == null) {
                return this.next.process(pkt);
            }
            WSDLBoundOperation wsdlBoundOp = msg.getOperation(this.wsdlPort);
            ATAssertion atAssertion = this.getOperationATPolicy((PolicyMap)this.policyMap, (WSDLPort)this.wsdlPort, (WSDLBoundOperation)wsdlBoundOp).atAssertion;
            if (atAssertion == ATAssertion.NOT_ALLOWED) {
                if (logger.isLogging(Level.FINE)) {
                    logger.fine("process", "no ws-at policy asssertion for " + wsdlBoundOp.getName().toString());
                }
                return this.next.process(pkt);
            }
            if (!(atAssertion != ATAssertion.MANDATORY && atAssertion != ATAssertion.ALLOWED || StatefulWebserviceFactoryFactory.getInstance().isWSTXServiceAvailable())) {
                logger.warning("TxClientPipe", LocalizationMessages.WSAT_TXN_CONTEXT_NOT_FLOWED_1001(msg.getOperation(this.wsdlPort).getName().toString()));
                return this.next.process(pkt);
            }
            CoordinationContextInterface context = this.lookupOrCreateCoordinationContext(atAssertion);
            CoordinationContext CC = (CoordinationContext)context.getValue();
            if (atAssertion == ATAssertion.MANDATORY || atAssertion == ATAssertion.ALLOWED) {
                CoordinationContextType.Identifier id = CC.getIdentifier();
                CC.getOtherAttributes().put(new QName(this.soapVersion.nsUri, "mustUnderstand"), "true");
                Header ccHeader = Headers.create(this.soapVersion, this.marshaller, this.COORD_CTX_QNAME, CC);
                msg.getHeaders().add(ccHeader);
            }
            try {
                currentTxn = this.txnMgr.suspend();
            }
            catch (SystemException ex) {
                throw new WebServiceException(ex.getMessage(), (Throwable)ex);
            }
            Exception rethrow = null;
            try {
                responsePacket = this.next.process(pkt);
            }
            catch (Exception e) {
                rethrow = e;
                return rethrow;
            }
            finally {
                try {
                    this.txnMgr.resume(currentTxn);
                }
                catch (Exception ex) {
                    if (rethrow != null) {
                        rethrow.initCause(ex);
                        throw new WebServiceException(ex.getMessage(), (Throwable)rethrow);
                    }
                    rethrow = ex;
                }
                if (rethrow == null) break block19;
                throw new WebServiceException(rethrow.getMessage(), (Throwable)rethrow);
            }
        }
        return responsePacket;
    }

    private CoordinationContextInterface lookupOrCreateCoordinationContext(ATAssertion assertion) {
        Transaction currentTxn;
        CoordinationContextInterface result = null;
        try {
            currentTxn = this.txnMgr.getTransaction();
        }
        catch (SystemException e) {
            throw new WebServiceException(e.getMessage(), (Throwable)e);
        }
        if (currentTxn == null && assertion == ATAssertion.MANDATORY) {
            throw new WebServiceException(LocalizationMessages.MISSING_TX_SCOPE_1000());
        }
        if (currentTxn != null && (result = this.txnMgr.getCoordinationContext()) == null) {
            long EXPIRES = (long)this.txnMgr.getRemainingTimeout() * 1000L;
            result = ContextFactory.createContext("http://schemas.xmlsoap.org/ws/2004/10/wsat", EXPIRES);
            ATCoordinator coord = new ATCoordinator(result);
            coord.setTransaction(currentTxn);
            CoordinationManager.getInstance().putCoordinator(coord);
            this.txnMgr.setCoordinationContext(result);
        }
        return result;
    }

    private Transaction checkCurrentJTATransaction(Message msg, WSDLPort wsdlModel) {
        Transaction currentTxn;
        block4: {
            currentTxn = null;
            try {
                currentTxn = this.txnMgr.getTransaction();
            }
            catch (Throwable t) {
                if (!logger.isLogging(Level.FINEST)) break block4;
                if (reportCheckCurrentJTAStacktrace) {
                    reportCheckCurrentJTAStacktrace = false;
                    logger.finest("checkCurrentJTATransaction", "handled exception thrown during checkCurrentJTATransaction", t);
                }
                logger.finest("checkCurrentJTATransaction", "handled exception thrown during checkCurrentJTATransaction");
            }
        }
        if (currentTxn == null && logger.isLogging(Level.FINEST)) {
            logger.finest("process", "no current JTA transaction for invoked operation " + msg.getOperation(wsdlModel).getName().toString());
        }
        return currentTxn;
    }
}

