/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.runtime.MakeConnectionSenderTask;
import com.sun.xml.ws.rx.mc.runtime.McConfiguration;
import com.sun.xml.ws.rx.mc.runtime.McResponseHandlerBase;
import com.sun.xml.ws.rx.mc.runtime.spi.ProtocolMessageHandler;
import com.sun.xml.ws.rx.util.ResumeFiberException;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import java.util.Map;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WsMcResponseHandler
extends McResponseHandlerBase {
    private static final Logger LOGGER = Logger.getLogger(WsMcResponseHandler.class);
    private final Map<String, ProtocolMessageHandler> actionToProtocolHandlerMap;

    public WsMcResponseHandler(McConfiguration configuration, MakeConnectionSenderTask mcSenderTask, SuspendedFiberStorage suspendedFiberStorage, Map<String, ProtocolMessageHandler> protocolHandlerMap) {
        super(configuration, mcSenderTask, suspendedFiberStorage);
        this.actionToProtocolHandlerMap = protocolHandlerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletion(Packet response) {
        try {
            Header wsaRelatesToHeader;
            Message responseMessage = response.getMessage();
            if (responseMessage == null) {
                LOGGER.warning("No response returned for a WS-MakeConnection request");
                return;
            }
            if (!responseMessage.hasHeaders()) {
                LOGGER.severe("Unable to find a proper response receiver: The response to a WS-MakeConnection request does not contain any headers.");
                return;
            }
            super.processMakeConnectionHeaders(responseMessage);
            if (responseMessage.isFault()) {
                String faultAction = responseMessage.getHeaders().getAction(this.configuration.getAddressingVersion(), this.configuration.getSoapVersion());
                if (this.configuration.getMcVersion().isMcFault(faultAction)) {
                    SOAPFault fault = null;
                    try {
                        fault = responseMessage.readAsSOAPMessage().getSOAPBody().getFault();
                    }
                    catch (SOAPException ex) {
                        throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException("Unable to unmarshall SOAP fault from the SOAP message.", ex))));
                    }
                    throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(String.format("Unexpected WS-MakeConnection protocol error: %s", fault.getFaultString())))));
                }
            }
            if ((wsaRelatesToHeader = responseMessage.getHeaders().get(this.configuration.getAddressingVersion().relatesToTag, false)) != null) {
                this.setCorrelationId(wsaRelatesToHeader.getStringContent());
                try {
                    this.resumeParentFiber(response);
                }
                catch (ResumeFiberException ex) {
                    LOGGER.warning("Unable to resume parent fiber for a response to a WS-MakeConnection request", (Throwable)((Object)ex));
                }
            }
            LOGGER.finer("Proceeding with processing the response as a protocol message.");
            Header wsaActionHeader = responseMessage.getHeaders().get(this.configuration.getAddressingVersion().actionTag, false);
            if (wsaActionHeader != null) {
                String wsaAction = wsaActionHeader.getStringContent();
                ProtocolMessageHandler handler = this.actionToProtocolHandlerMap.get(wsaAction);
                if (handler != null) {
                    LOGGER.finer(String.format("Processing WS-MC response with WS-Addressing action [ %s ] using ProtocolMessageHandler of class [ %s ]", wsaAction, handler.getClass().getName()));
                    handler.processProtocolMessage(response);
                } else {
                    LOGGER.warning(String.format("Unable to find a ProtocolMessageHandler to process WS-MC response with WS-Addressing action [ %s ]", wsaAction));
                }
            } else {
                LOGGER.severe("Unable to find a proper response receiver: The response to a WS-MakeConnection request does not contain WS-Addressing Action header.");
            }
        }
        finally {
            this.mcSenderTask.clearMcRequestPendingFlag();
        }
    }

    @Override
    public void onCompletion(Throwable error) {
        try {
            throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException("Sening WS-MakeConnection request failed", error))));
        }
        catch (Throwable throwable) {
            this.mcSenderTask.clearMcRequestPendingFlag();
            throw throwable;
        }
    }
}

