/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.policy.assertion.wsrm200702;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.ComplexAssertion;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.spi.AssertionCreationException;
import com.sun.xml.ws.rx.policy.assertion.AssertionInstantiator;
import com.sun.xml.ws.rx.policy.assertion.AssertionNamespace;
import com.sun.xml.ws.rx.rm.ReliableMessagingFeature;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import java.util.Collection;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryAssuranceAssertion
extends ComplexAssertion {
    private static final Logger LOGGER = Logger.getLogger(DeliveryAssuranceAssertion.class);
    private static final QName EXACTLY_ONCE_QNAME = AssertionNamespace.WSRMP_200702.getQName("ExactlyOnce");
    private static final QName AT_LEAST_ONCE_QNAME = AssertionNamespace.WSRMP_200702.getQName("AtLeastOnce");
    private static final QName AT_MOST_ONCE_QNAME = AssertionNamespace.WSRMP_200702.getQName("AtMostOnce");
    private static final QName IN_ORDER_QNAME = AssertionNamespace.WSRMP_200702.getQName("InOrder");
    public static final QName NAME = AssertionNamespace.WSRMP_200702.getQName("DeliveryAssurance");
    private static AssertionInstantiator instantiator = new AssertionInstantiator(){

        @Override
        public PolicyAssertion newInstance(AssertionData data, Collection<PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
            return new DeliveryAssuranceAssertion(data, assertionParameters, nestedAlternative);
        }
    };
    private final ReliableMessagingFeature.DeliveryAssurance deliveryAssurance;
    private final boolean orderedDelivery;

    public static AssertionInstantiator getInstantiator() {
        return instantiator;
    }

    private DeliveryAssuranceAssertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
        super(data, assertionParameters, nestedAlternative);
        ReliableMessagingFeature.DeliveryAssurance _deliveryAssurance = null;
        boolean _orderedDelivery = false;
        if (nestedAlternative != null) {
            for (PolicyAssertion nestedAssertion : nestedAlternative) {
                if (EXACTLY_ONCE_QNAME.equals(nestedAssertion.getName())) {
                    _deliveryAssurance = this.evaluateDeliveryAssurance(_deliveryAssurance == null, ReliableMessagingFeature.DeliveryAssurance.EXACTLY_ONCE, data);
                    continue;
                }
                if (AT_LEAST_ONCE_QNAME.equals(nestedAssertion.getName())) {
                    _deliveryAssurance = this.evaluateDeliveryAssurance(_deliveryAssurance == null, ReliableMessagingFeature.DeliveryAssurance.AT_LEAST_ONCE, data);
                    continue;
                }
                if (AT_MOST_ONCE_QNAME.equals(nestedAssertion.getName())) {
                    _deliveryAssurance = this.evaluateDeliveryAssurance(_deliveryAssurance == null, ReliableMessagingFeature.DeliveryAssurance.AT_MOST_ONCE, data);
                    continue;
                }
                if (!IN_ORDER_QNAME.equals(nestedAssertion.getName())) continue;
                _orderedDelivery = true;
            }
        }
        this.deliveryAssurance = _deliveryAssurance == null ? ReliableMessagingFeature.DeliveryAssurance.getDefault() : _deliveryAssurance;
        this.orderedDelivery = _orderedDelivery;
    }

    public ReliableMessagingFeature.DeliveryAssurance getDeliveryAssurance() {
        return this.deliveryAssurance;
    }

    public boolean isOrderedDelivery() {
        return this.orderedDelivery;
    }

    private ReliableMessagingFeature.DeliveryAssurance evaluateDeliveryAssurance(boolean successCondition, ReliableMessagingFeature.DeliveryAssurance daOnSuccess, AssertionData data) throws AssertionCreationException {
        if (successCondition) {
            return daOnSuccess;
        }
        throw (AssertionCreationException)LOGGER.logSevereException((Throwable)new AssertionCreationException(data, LocalizationMessages.WSRM_1003_MUTLIPLE_DA_TYPES_IN_POLICY()));
    }
}

