/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.protocol;

import com.sun.istack.NotNull;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcknowledgementData {
    private String ackedSequenceId;
    private List<Sequence.AckRange> ackedRanges;
    private String ackRequestedSequenceId;

    public static Builder getBuilder() {
        return new Builder();
    }

    private AcknowledgementData(String ackedSequenceId, List<Sequence.AckRange> ackedRanges, String ackRequestedSequenceId) {
        this.ackedSequenceId = ackedSequenceId;
        this.ackedRanges = ackedRanges;
        this.ackRequestedSequenceId = ackRequestedSequenceId;
    }

    public String getAcknowledgedSequenceId() {
        return this.ackedSequenceId;
    }

    @NotNull
    public List<Sequence.AckRange> getAcknowledgedRanges() {
        if (this.ackedRanges != null) {
            return this.ackedRanges;
        }
        return Collections.emptyList();
    }

    public String getAckReqestedSequenceId() {
        return this.ackRequestedSequenceId;
    }

    public boolean containsSequenceAcknowledgementData() {
        return this.ackedSequenceId != null && this.ackedRanges != null && !this.ackedRanges.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        private String ackedSequenceId;
        private List<Sequence.AckRange> ackedRanges;
        private String ackRequestedSequenceId;

        private Builder() {
        }

        public void acknowledgements(@NotNull String ackedSequenceId, List<Sequence.AckRange> acknowledgedMessageIds) {
            assert (ackedSequenceId != null);
            this.ackedSequenceId = ackedSequenceId;
            this.ackedRanges = acknowledgedMessageIds;
        }

        public void ackReqestedSequenceId(String ackRequestedSequenceId) {
            this.ackRequestedSequenceId = ackRequestedSequenceId;
        }

        public AcknowledgementData build() {
            return new AcknowledgementData(this.ackedSequenceId, this.ackedRanges, this.ackRequestedSequenceId);
        }
    }
}

