/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.server;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.ConfigReader;
import com.sun.xml.ws.api.config.management.EndpointStarter;
import com.sun.xml.ws.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.api.config.management.NamedParameters;
import com.sun.xml.ws.commons.DelayedTaskManager;
import com.sun.xml.ws.commons.MaintenanceTaskExecutor;
import com.sun.xml.ws.config.management.ManagementUtil;
import com.sun.xml.ws.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.ws.config.management.server.ReDelegate;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.sql.DataSource;
import javax.xml.ws.WebServiceException;

public class JDBCConfigReader
implements ConfigReader {
    private static final Logger LOGGER = Logger.getLogger(ConfigPoller.class);
    private volatile ConfigPoller poller = null;

    public synchronized void init(NamedParameters parameters) {
        if (this.poller != null) {
            throw new IllegalStateException(String.format("Duplicate initialization detected: This instance of [ %s ] class has already been initialized", this.getClass().getName()));
        }
        this.poller = new ConfigPoller(parameters, 10000L);
    }

    public synchronized void start() {
        if (this.poller == null) {
            throw new IllegalStateException(String.format("Unable to start poller task: This instance of [ %s ] class has not been initialized yet. Please call init() method first.", this.getClass().getName()));
        }
        this.poller.start();
    }

    public synchronized void stop() {
        if (this.poller == null) {
            throw new IllegalStateException(String.format("Unable to stop poller task: This instance of [ %s ] class has not been initialized yet. Please call init() method first.", this.getClass().getName()));
        }
        this.poller.stop();
    }

    private static class ConfigPoller
    implements DelayedTaskManager.DelayedTask {
        private final ManagedEndpoint endpoint;
        private final EndpointStarter endpointStarter;
        private final String dataSourceName;
        private final NamedParameters configParameters;
        private final long executionDelay;
        private volatile boolean stopped;
        private volatile long version = 0L;

        public ConfigPoller(NamedParameters parameters, long executionDelay) {
            this.endpoint = (ManagedEndpoint)parameters.get("ENDPOINT_INSTANCE");
            this.endpointStarter = (EndpointStarter)parameters.get("ENDPOINT_STARTER");
            this.configParameters = parameters;
            ManagedServiceAssertion assertion = ManagementUtil.getAssertion(this.endpoint);
            this.dataSourceName = assertion.getJDBCDataSourceName();
            this.executionDelay = executionDelay;
            this.stopped = true;
            String start = assertion.getStart();
            if (start == null || !start.equals("notify")) {
                this.endpointStarter.startEndpoint();
            }
        }

        public String getName() {
            return "JDBC configuration management reader";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(DelayedTaskManager manager) {
            if (this.stopped) {
                return;
            }
            Connection connection = null;
            try {
                DataSource source = ManagementUtil.getManagementDS(this.dataSourceName);
                connection = source.getConnection();
                this.pollData(connection, this.endpoint.getId());
                connection.close();
            }
            catch (SQLException e) {
                LOGGER.logSevereException((Throwable)e);
            }
            catch (WebServiceException e) {
                LOGGER.logSevereException((Throwable)e);
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    LOGGER.logException((Throwable)e, Level.WARNING);
                }
                if (!this.stopped) {
                    MaintenanceTaskExecutor.INSTANCE.register(this, this.executionDelay, TimeUnit.MILLISECONDS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void start() {
            LOGGER.entering();
            try {
                if (this.stopped) {
                    this.stopped = false;
                    MaintenanceTaskExecutor.INSTANCE.register(this, 0L, TimeUnit.MILLISECONDS);
                } else {
                    LOGGER.warning(String.format("Duplicate start of [ %s ] instance detected: Instance already runing", this.getName()));
                }
            }
            finally {
                LOGGER.exiting();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void stop() {
            LOGGER.entering();
            try {
                this.stopped = true;
            }
            finally {
                LOGGER.exiting();
            }
        }

        private void pollData(Connection connection, String endpointId) {
            Statement statement = null;
            try {
                String query = "SELECT version, config FROM METRO_CONFIG WHERE id = ? AND version > ?";
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Executing SQL command: SELECT version, config FROM METRO_CONFIG WHERE id = ? AND version > ?");
                }
                statement = connection.prepareStatement("SELECT version, config FROM METRO_CONFIG WHERE id = ? AND version > ?");
                statement.setString(1, endpointId);
                statement.setLong(2, this.version);
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("SQL query found updated configuration data");
                    }
                    this.version = result.getLong("version");
                    Reader data = result.getCharacterStream("config");
                    this.reconfigure(data);
                } else if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finer("SQL query did not find any updated configuration data");
                }
            }
            catch (SQLException e) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)e));
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)e));
                    }
                }
            }
        }

        private void reconfigure(Reader reader) {
            this.configParameters.put("CONFIGURATION_DATA", ManagementUtil.convert(reader));
            ReDelegate redelegate = new ReDelegate();
            redelegate.recreate(this.configParameters);
            this.endpointStarter.startEndpoint();
        }
    }
}

