/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.util.DelayedTaskManager;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;

public class SequenceMaintenanceTask
implements DelayedTaskManager.DelayedTask {
    private static final Logger LOGGER = Logger.getLogger(SequenceMaintenanceTask.class);
    private final WeakReference<SequenceManager> smReference;
    private final long period;
    private final TimeUnit timeUnit;
    private final String endpointUid;

    public SequenceMaintenanceTask(@NotNull SequenceManager sequenceManager, long period, @NotNull TimeUnit timeUnit) {
        assert (sequenceManager != null);
        assert (period > 0L);
        assert (timeUnit != null);
        this.smReference = new WeakReference<SequenceManager>(sequenceManager);
        this.period = period;
        this.timeUnit = timeUnit;
        this.endpointUid = sequenceManager.uniqueEndpointId();
    }

    public void run(DelayedTaskManager manager) {
        SequenceManager sequenceManager = (SequenceManager)this.smReference.get();
        if (sequenceManager != null) {
            boolean registrationSuccesfull;
            sequenceManager.onMaintenance();
            if (!manager.isClosed() && !(registrationSuccesfull = manager.register(this, this.period, this.timeUnit))) {
                LOGGER.config(String.format("Unable to re-schedule the sequence maintenance task for an endpoint UID [ %s ].", this.endpointUid));
            }
        } else {
            LOGGER.config(String.format("Terminating sequence maintenance task for an endpoint UID [ %s ]: Sequence manager instance has been garbage-collected", this.endpointUid));
        }
    }
}

