/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.ws.policy.spi.PolicyAssertionValidator;

public final class AssertionValidationProcessor {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(AssertionValidationProcessor.class);
    private static AssertionValidationProcessor processor = new AssertionValidationProcessor();
    private static final PolicyAssertionValidator[] validators = PolicyUtils.ServiceProvider.load(PolicyAssertionValidator.class);

    private AssertionValidationProcessor() {
    }

    public static AssertionValidationProcessor getInstance() throws PolicyException {
        if (validators.length == 0) {
            throw (PolicyException)LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0076_NO_SERVICE_PROVIDERS_FOUND(PolicyAssertionValidator.class.getName())));
        }
        return processor;
    }

    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion assertion) throws PolicyException {
        PolicyAssertionValidator validator;
        PolicyAssertionValidator.Fitness assertionFitness = PolicyAssertionValidator.Fitness.UNKNOWN;
        PolicyAssertionValidator[] arr$ = validators;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (assertionFitness = assertionFitness.combine((validator = arr$[i$]).validateClientSide(assertion))) != PolicyAssertionValidator.Fitness.SUPPORTED; ++i$) {
        }
        return assertionFitness;
    }

    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion assertion) throws PolicyException {
        PolicyAssertionValidator validator;
        PolicyAssertionValidator.Fitness assertionFitness = PolicyAssertionValidator.Fitness.UNKNOWN;
        PolicyAssertionValidator[] arr$ = validators;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (assertionFitness = assertionFitness.combine((validator = arr$[i$]).validateServerSide(assertion))) != PolicyAssertionValidator.Fitness.SUPPORTED; ++i$) {
        }
        return assertionFitness;
    }
}

