/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.config.management;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.CommunicationServer;
import com.sun.xml.ws.api.config.management.ConfigReader;
import com.sun.xml.ws.api.config.management.ConfigSaver;
import com.sun.xml.ws.api.config.management.Configurator;
import com.sun.xml.ws.api.config.management.NamedParameters;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.policy.ManagedServiceAssertion;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactory {
    private static final Logger LOGGER = Logger.getLogger(ManagementFactory.class);
    private static final String DEFAULT_COMMUNICATION_SERVER_CLASS_NAME = "com.sun.xml.ws.config.management.jmx.JMXAgent";
    private static final String DEFAULT_CONFIGURATOR_CLASS_NAME = "com.sun.xml.ws.config.management.server.DefaultConfigurator";
    private static final String DEFAULT_CONFIG_READER_CLASS_NAME = "com.sun.xml.ws.config.management.server.JDBCConfigReader";
    private static final String DEFAULT_CONFIG_SAVER_CLASS_NAME = "com.sun.xml.ws.config.management.persistence.JDBCConfigSaver";
    private final ManagedServiceAssertion assertion;

    public ManagementFactory(ManagedServiceAssertion assertion) {
        this.assertion = assertion;
    }

    public Collection<CommunicationServer> createCommunicationImpls(NamedParameters parameters) throws WebServiceException {
        LinkedList<CommunicationServer> result = new LinkedList<CommunicationServer>();
        Collection<String> communicationServerNames = this.assertion.getCommunicationServerImplementations();
        if (communicationServerNames.isEmpty()) {
            CommunicationServer implementation = ManagementFactory.instantiateImplementation(CommunicationServer.class, DEFAULT_COMMUNICATION_SERVER_CLASS_NAME);
            implementation.init(parameters);
            result.add(implementation);
        } else {
            for (String communicationServerName : communicationServerNames) {
                CommunicationServer implementation = ManagementFactory.instantiateImplementation(CommunicationServer.class, communicationServerName);
                implementation.init(parameters);
                result.add(implementation);
            }
        }
        return result;
    }

    public Configurator createConfiguratorImpl() throws WebServiceException {
        String configuratorName = this.assertion.getConfiguratorImplementation();
        if (configuratorName == null) {
            configuratorName = DEFAULT_CONFIGURATOR_CLASS_NAME;
        }
        return ManagementFactory.instantiateImplementation(Configurator.class, configuratorName);
    }

    public ConfigSaver createConfigSaverImpl() throws WebServiceException {
        String configSaverName = this.assertion.getConfigSaverImplementation();
        if (configSaverName == null) {
            configSaverName = DEFAULT_CONFIG_SAVER_CLASS_NAME;
        }
        return ManagementFactory.instantiateImplementation(ConfigSaver.class, configSaverName);
    }

    public ConfigReader createConfigReaderImpl(NamedParameters parameters) throws WebServiceException {
        String configReaderName = this.assertion.getConfigReaderImplementation();
        if (configReaderName == null) {
            configReaderName = DEFAULT_CONFIG_READER_CLASS_NAME;
        }
        ConfigReader reader = ManagementFactory.instantiateImplementation(ConfigReader.class, configReaderName);
        reader.init(parameters);
        return reader;
    }

    private static <T> T instantiateImplementation(Class<T> type, String className) throws WebServiceException {
        try {
            Class<?> implementation = Class.forName(className);
            return type.cast(implementation.newInstance());
        }
        catch (ClassNotFoundException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5015_FAILED_LOAD_CLASS(className), (Throwable)e));
        }
        catch (InstantiationException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5016_FAILED_INSTANTIATE_OBJECT(type.getName()), (Throwable)e));
        }
        catch (IllegalAccessException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5016_FAILED_INSTANTIATE_OBJECT(type.getName()), (Throwable)e));
        }
    }
}

