/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.DefaultNonceManager;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.net.URL;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="per-VM NonceManager")
@AMXMetadata(type="NonceManager")
public abstract class NonceManager {
    public static final String nonceManager = "com.sun.xml.xwss.NonceManager";
    private static final String NONCE_MANAGER = "NonceManager";
    private static NonceManager nonceMgr = null;
    private long maxNonceAge;

    @ManagedAttribute
    public long getMaxNonceAge() {
        return this.maxNonceAge;
    }

    public void setMaxNonceAge(long maxNonceAge) {
        this.maxNonceAge = maxNonceAge;
    }

    public abstract boolean validateNonce(String var1, String var2) throws NonceException;

    public static synchronized NonceManager getInstance(long maxNonceAge, WSEndpoint endpoint) {
        if (nonceMgr != null) {
            endpoint.getManagedObjectManager().registerAtRoot((Object)nonceMgr, NONCE_MANAGER);
            return nonceMgr;
        }
        URL url = SecurityUtil.loadFromClasspath("/META-INF/services/com.sun.xml.xwss.NonceManager");
        if (url != null) {
            Object obj = SecurityUtil.loadSPIClass(url, nonceManager);
            if (obj != null && !(obj instanceof NonceManager)) {
                throw new XWSSecurityRuntimeException("Class :" + obj.getClass().getName() + " is not a valid NonceManager");
            }
            nonceMgr = (NonceManager)obj;
        }
        if (nonceMgr == null) {
            nonceMgr = new DefaultNonceManager();
        }
        nonceMgr.setMaxNonceAge(maxNonceAge);
        endpoint.getManagedObjectManager().registerAtRoot((Object)nonceMgr, NONCE_MANAGER);
        return nonceMgr;
    }

    public static class NonceException
    extends XWSSecurityException {
        public NonceException(String message) {
            super(message);
        }

        public NonceException(String message, Throwable cause) {
            super(message, cause);
        }

        public NonceException(Throwable cause) {
            super(cause);
        }
    }
}

