/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.xml.ws.rx.rm.runtime.MaintenanceTaskExecutor;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.InboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.OutboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceMaintenanceTask;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.InVmSequenceData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InVmSequenceManager
implements SequenceManager {
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final Map<String, AbstractSequence> sequences = new HashMap<String, AbstractSequence>();
    private final Map<String, String> boundSequences = new HashMap<String, String>();
    private final DeliveryQueueBuilder inboundQueueBuilder;
    private final DeliveryQueueBuilder outboundQueueBuilder;
    private final String uniqueEndpointId;
    private final long sequenceInactivityTimeout;

    public InVmSequenceManager(String uniqueEndpointId, DeliveryQueueBuilder inboundQueueBuilder, DeliveryQueueBuilder outboundQueueBuilder, RmConfiguration configuration) {
        this.uniqueEndpointId = uniqueEndpointId;
        this.inboundQueueBuilder = inboundQueueBuilder;
        this.outboundQueueBuilder = outboundQueueBuilder;
        this.sequenceInactivityTimeout = configuration.getSequenceInactivityTimeout();
        ManagedObjectManager managedObjectManager = configuration.getManagedObjectManager();
        if (managedObjectManager != null) {
            managedObjectManager.registerAtRoot((Object)this, "RMSequenceManager");
        }
        MaintenanceTaskExecutor.INSTANCE.register(new SequenceMaintenanceTask(this, configuration.getSequenceManagerMaintenancePeriod(), TimeUnit.MILLISECONDS), configuration.getSequenceManagerMaintenancePeriod(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public String uniqueEndpointId() {
        return this.uniqueEndpointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Sequence> sequences() {
        try {
            this.dataLock.readLock().lock();
            HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>(this.sequences);
            return hashMap;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> boundSequences() {
        try {
            this.dataLock.readLock().lock();
            HashMap<String, String> hashMap = new HashMap<String, String>(this.boundSequences);
            return hashMap;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    @Override
    public Sequence createOutboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        InVmSequenceData data = new InVmSequenceData(this, sequenceId, strId, expirationTime, 0L, this.currentTimeInMillis());
        return this.registerSequence(new OutboundSequence(data, this.outboundQueueBuilder, this));
    }

    @Override
    public Sequence createInboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        InVmSequenceData data = new InVmSequenceData(this, sequenceId, strId, expirationTime, 0L, this.currentTimeInMillis());
        return this.registerSequence(new InboundSequence(data, this.inboundQueueBuilder, this));
    }

    @Override
    public String generateSequenceUID() {
        return "uuid:" + UUID.randomUUID();
    }

    @Override
    public Sequence closeSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        sequence.close();
        return sequence;
    }

    @Override
    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.readLock().lock();
            if (this.sequences.containsKey(sequenceId)) {
                Sequence sequence = this.sequences.get(sequenceId);
                if (this.shouldTeminate(sequence)) {
                    this.dataLock.readLock().unlock();
                    this.tryTerminateSequence(sequenceId);
                    this.dataLock.readLock().lock();
                }
                Sequence sequence2 = sequence;
                return sequence2;
            }
            throw new UnknownSequenceException(sequenceId);
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(String sequenceId) {
        try {
            this.dataLock.readLock().lock();
            Sequence s = this.sequences.get(sequenceId);
            boolean bl = s != null && s.getState() != Sequence.State.TERMINATING;
            return bl;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence tryTerminateSequence(String sequenceId) {
        try {
            this.dataLock.writeLock().lock();
            if (this.sequences.containsKey(sequenceId)) {
                AbstractSequence sequence = this.sequences.get(sequenceId);
                if (sequence.getState() != Sequence.State.TERMINATING) {
                    sequence.preDestroy();
                }
                AbstractSequence abstractSequence = sequence;
                return abstractSequence;
            }
            Sequence sequence = null;
            return sequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public Sequence terminateSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.tryTerminateSequence(sequenceId);
        if (sequence == null) {
            throw new UnknownSequenceException(sequenceId);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindSequences(String referenceSequenceId, String boundSequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.writeLock().lock();
            if (!this.sequences.containsKey(referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            if (!this.sequences.containsKey(boundSequenceId)) {
                throw new UnknownSequenceException(boundSequenceId);
            }
            this.boundSequences.put(referenceSequenceId, boundSequenceId);
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getBoundSequence(String referenceSequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.readLock().lock();
            if (!this.isValid(referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            AbstractSequence abstractSequence = this.boundSequences.containsKey(referenceSequenceId) ? this.sequences.get(this.boundSequences.get(referenceSequenceId)) : null;
            return abstractSequence;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence registerSequence(AbstractSequence sequence) throws DuplicateSequenceException {
        try {
            this.dataLock.writeLock().lock();
            if (this.sequences.containsKey(sequence.getId())) {
                throw new DuplicateSequenceException(sequence.getId());
            }
            this.sequences.put(sequence.getId(), sequence);
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public long currentTimeInMillis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMaintenance() {
        try {
            this.dataLock.writeLock().lock();
            for (String key : this.sequences.keySet()) {
                AbstractSequence sequence = this.sequences.get(key);
                if (this.shouldRemove(sequence)) {
                    this.sequences.remove(key);
                    if (!this.boundSequences.containsKey(sequence.getId())) continue;
                    this.boundSequences.remove(sequence.getId());
                    continue;
                }
                if (!this.shouldTeminate(sequence)) continue;
                this.tryTerminateSequence(sequence.getId());
            }
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    private boolean shouldTeminate(Sequence sequence) {
        return sequence.getState() != Sequence.State.TERMINATING && (sequence.isExpired() || sequence.getLastActivityTime() + this.sequenceInactivityTimeout < this.currentTimeInMillis());
    }

    private boolean shouldRemove(Sequence sequence) {
        return sequence.getState() == Sequence.State.TERMINATING;
    }
}

