/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management;

import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.config.management.ManagementConstants;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import javax.xml.ws.WebServiceException;

public class ManagementUtil {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(ManagementUtil.class);

    public static ManagedServiceAssertion getAssertion(WSEndpoint endpoint) {
        LOGGER.entering(new Object[]{endpoint});
        try {
            AssertionSet assertionSet;
            Iterator<PolicyAssertion> assertions;
            Iterator<AssertionSet> assertionSets;
            PolicyMapKey key;
            Policy policy;
            PolicyAssertion assertion = null;
            PolicyMap policyMap = endpoint.getPolicyMap();
            if (policyMap != null && (policy = policyMap.getEndpointEffectivePolicy(key = PolicyMap.createWsdlEndpointScopeKey(endpoint.getServiceName(), endpoint.getPortName()))) != null && (assertionSets = policy.iterator()).hasNext() && (assertions = (assertionSet = assertionSets.next()).get(ManagementConstants.SERVICE_ASSERTION_QNAME).iterator()).hasNext()) {
                assertion = assertions.next();
            }
            LOGGER.exiting(assertion);
            return assertion == null ? null : assertion.getImplementation(ManagedServiceAssertion.class);
        }
        catch (PolicyException ex) {
            throw (WebServiceException)LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5003_FAILED_ASSERTION(), (Throwable)ex));
        }
    }

    public static String convert(Reader reader) {
        try {
            int count;
            StringBuilder data = new StringBuilder();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) >= 0) {
                data.append(buffer, 0, count);
            }
            return data.toString();
        }
        catch (IOException e) {
            throw (WebServiceException)LOGGER.logSevereException(new WebServiceException((Throwable)e));
        }
    }
}

