/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.config.management;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.HttpMetadataPublisher;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManagedHttpMetadataPublisher
extends HttpMetadataPublisher
implements EndpointComponent {
    ManagedHttpMetadataPublisher() {
    }

    @Override
    public <T> T getSPI(Class<T> spiType) {
        if (spiType.isAssignableFrom(this.getClass())) {
            return spiType.cast(this);
        }
        return null;
    }

    @Override
    public boolean handleMetadataRequest(HttpAdapter adapter, WSHTTPConnection connection) throws IOException {
        if (this.isWSDLQuery(connection.getQueryString())) {
            this.publishWSDL(connection, adapter);
            return true;
        }
        return false;
    }

    private boolean isWSDLQuery(String query) {
        return query != null && (query.equals("WSDL") || query.startsWith("wsdl"));
    }

    private void publishWSDL(@NotNull WSHTTPConnection connection, @NotNull HttpAdapter adapter) throws IOException {
        ServiceDefinition currentServiceDefinition = adapter.getEndpoint().getServiceDefinition();
        if (adapter.getServiceDefinition() != currentServiceDefinition) {
            adapter.initWSDLMap(currentServiceDefinition);
        }
        adapter.publishWSDL(connection);
    }
}

