/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RedeliveryTask;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;

class SourceMessageHandler
implements RedeliveryTask.DeliveryHandler {
    private volatile SequenceManager sequenceManager;

    SourceMessageHandler(@Nullable SequenceManager sequenceManager) {
        this.sequenceManager = sequenceManager;
    }

    void setSequenceManager(SequenceManager sequenceManager) {
        this.sequenceManager = sequenceManager;
    }

    public void registerMessage(@NotNull ApplicationMessage outMessage, @NotNull String outboundSequenceId) throws DuplicateMessageRegistrationException, UnknownSequenceException {
        assert (this.sequenceManager != null);
        assert (outMessage != null);
        assert (outboundSequenceId != null);
        Sequence outboundSequence = this.sequenceManager.getSequence(outboundSequenceId);
        outboundSequence.registerMessage(outMessage, true);
    }

    public void attachAcknowledgementInfo(@NotNull ApplicationMessage outMessage) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        assert (outMessage != null);
        assert (outMessage.getSequenceId() != null);
        outMessage.setAcknowledgementData(this.getAcknowledgementData(outMessage.getSequenceId()));
    }

    public AcknowledgementData getAcknowledgementData(String outboundSequenceId) throws UnknownSequenceException {
        Sequence outboundSequence;
        assert (this.sequenceManager != null);
        AcknowledgementData.Builder ackDataBuilder = AcknowledgementData.getBuilder();
        Sequence inboundSequence = this.sequenceManager.getBoundSequence(outboundSequenceId);
        if (inboundSequence != null && inboundSequence.isAckRequested()) {
            ackDataBuilder.acknowledgements(inboundSequence.getId(), inboundSequence.getAcknowledgedMessageNumbers());
            inboundSequence.clearAckRequestedFlag();
        }
        if ((outboundSequence = this.sequenceManager.getSequence(outboundSequenceId)).hasUnacknowledgedMessages()) {
            ackDataBuilder.ackReqestedSequenceId(outboundSequenceId);
            outboundSequence.updateLastAcknowledgementRequestTime();
        }
        AcknowledgementData acknowledgementData = ackDataBuilder.build();
        return acknowledgementData;
    }

    public void putToDeliveryQueue(ApplicationMessage message) throws RxRuntimeException {
        assert (this.sequenceManager != null);
        this.sequenceManager.getSequence(message.getSequenceId()).getDeliveryQueue().put(message);
    }
}

