/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.tools.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.gmbal.generic.BinaryFunction;
import org.glassfish.gmbal.tools.file.Block;
import org.glassfish.gmbal.tools.file.FileWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockParser {
    public static final String COMMENT_BLOCK_TAG = "CommentBlock";

    private BlockParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Block getBlock(FileWrapper fw) throws IOException {
        fw.open(FileWrapper.OpenMode.READ);
        try {
            ArrayList<String> data = new ArrayList<String>();
            String line = fw.readLine();
            while (line != null) {
                data.add(line);
                line = fw.readLine();
            }
            Block block = new Block(data);
            return block;
        }
        finally {
            fw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Block> parseBlocks(FileWrapper fw, String prefix) throws IOException {
        boolean inComment = false;
        final ArrayList<Block> result = new ArrayList<Block>();
        fw.open(FileWrapper.OpenMode.READ);
        try {
            List<String> data = new ArrayList<String>();
            BinaryFunction<List<String>, String, List<String>> newBlock = new BinaryFunction<List<String>, String, List<String>>(){

                @Override
                public List<String> evaluate(List<String> data, String tag) {
                    if (data.size() == 0) {
                        return data;
                    }
                    Block bl = new Block(data);
                    if (tag != null) {
                        bl.addTag(tag);
                    }
                    result.add(bl);
                    return new ArrayList<String>();
                }
            };
            String line = fw.readLine();
            while (line != null) {
                if (inComment) {
                    if (!line.startsWith(prefix)) {
                        inComment = false;
                        data = (List)newBlock.evaluate(data, COMMENT_BLOCK_TAG);
                    }
                } else if (line.startsWith(prefix)) {
                    inComment = true;
                    data = (List)newBlock.evaluate(data, null);
                }
                data.add(line);
                line = fw.readLine();
            }
            Block bl = new Block(data);
            if (inComment) {
                bl.addTag(COMMENT_BLOCK_TAG);
            }
            result.add(bl);
            ArrayList<Block> arrayList = result;
            return arrayList;
        }
        finally {
            fw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Block> parseBlocks(FileWrapper fw, String start, String end) throws IOException {
        boolean inComment = false;
        final ArrayList<Block> result = new ArrayList<Block>();
        fw.open(FileWrapper.OpenMode.READ);
        try {
            List<String> data = new ArrayList<String>();
            BinaryFunction<List<String>, String, List<String>> newBlock = new BinaryFunction<List<String>, String, List<String>>(){

                @Override
                public List<String> evaluate(List<String> data, String tag) {
                    if (data.size() == 0) {
                        return data;
                    }
                    Block bl = new Block(data);
                    if (tag != null) {
                        bl.addTag(tag);
                    }
                    result.add(bl);
                    return new ArrayList<String>();
                }
            };
            String line = fw.readLine();
            while (line != null) {
                if (inComment) {
                    data.add(line);
                    if (line.contains(end)) {
                        inComment = false;
                        data = (List)newBlock.evaluate(data, COMMENT_BLOCK_TAG);
                    }
                } else {
                    if (line.contains(start)) {
                        inComment = true;
                        data = (List)newBlock.evaluate(data, null);
                    }
                    data.add(line);
                    if (line.contains(end)) {
                        inComment = false;
                        data = (List)newBlock.evaluate(data, COMMENT_BLOCK_TAG);
                    }
                }
                line = fw.readLine();
            }
            Block bl = new Block(data);
            if (inComment) {
                bl.addTag(COMMENT_BLOCK_TAG);
            }
            result.add(bl);
            ArrayList<Block> arrayList = result;
            return arrayList;
        }
        finally {
            fw.close();
        }
    }
}

