/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.policy;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapExtender;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.SimpleAssertion;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapUpdateProvider;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.transport.SelectOptimalTransportFeature;
import com.sun.xml.ws.transport.tcp.wsit.TCPConstants;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class OptimalTransportMapUpdateProvider
implements PolicyMapUpdateProvider {
    private static final Logger LOGGER = Logger.getLogger(OptimalTransportMapUpdateProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(PolicyMapExtender policyMapMutator, PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        try {
            LOGGER.entering(policyMapMutator, policyMap, model, wsBinding);
            if (policyMapMutator == null) {
                return;
            }
            this.updateOptimalTransportSettings(wsBinding, model, policyMap, policyMapMutator);
        }
        finally {
            LOGGER.exiting();
        }
    }

    private void updateOptimalTransportSettings(WSBinding wsBinding, SEIModel model, PolicyMap policyMap, PolicyMapExtender policyMapMutator) throws PolicyException, IllegalArgumentException {
        Policy existingPolicy;
        SelectOptimalTransportFeature optimalTransportFeature = wsBinding.getFeature(SelectOptimalTransportFeature.class);
        if (optimalTransportFeature == null || !optimalTransportFeature.isEnabled()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Make Optimal transport feature enabled on service '%s', port '%s'", model.getServiceQName(), model.getPortName()));
        }
        PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(model.getServiceQName(), model.getPortName());
        Policy policy = existingPolicy = policyMap != null ? policyMap.getEndpointEffectivePolicy(endpointKey) : null;
        if (existingPolicy == null || !existingPolicy.contains(TCPConstants.SELECT_OPTIMAL_TRANSPORT_ASSERTION)) {
            Policy mcPolicy = this.createOptimalTransportPolicy(model.getBoundPortTypeName());
            policyMapMutator.putEndpointSubject(endpointKey, new PolicySubject((Object)model.getBoundPortTypeName(), mcPolicy));
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Added Optimal transport policy with ID '%s' to binding element '%s'", mcPolicy.getIdOrName(), model.getBoundPortTypeName()));
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Make Optimal transport assertion is already present in the endpoint policy");
        }
    }

    private Policy createOptimalTransportPolicy(QName bindingName) {
        return Policy.createPolicy(null, bindingName.getLocalPart() + "_OptimalTransport_Policy", Arrays.asList(AssertionSet.createAssertionSet(Arrays.asList(new OptimalTransportAssertion()))));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OptimalTransportAssertion
    extends SimpleAssertion {
        public OptimalTransportAssertion() {
            this(AssertionData.createAssertionData(TCPConstants.SELECT_OPTIMAL_TRANSPORT_ASSERTION), null);
        }

        public OptimalTransportAssertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters) {
            super(data, assertionParameters);
        }
    }
}

