/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.policy;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.encoding.policy.EncodingConstants;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapExtender;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapUpdateProvider;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.MTOMFeature;

public class MtomMapUpdateProvider
implements PolicyMapUpdateProvider {
    private static final PolicyLogger logger = PolicyLogger.getLogger(MtomMapUpdateProvider.class);

    public void update(PolicyMapExtender policyMapMutator, PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        logger.entering(policyMapMutator, policyMap, model, wsBinding);
        if (policyMap != null) {
            MTOMFeature mtomFeature = wsBinding.getFeature(MTOMFeature.class);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("mtomFeature = " + mtomFeature);
            }
            if (mtomFeature != null && mtomFeature.isEnabled()) {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(model.getServiceQName(), model.getPortName());
                Policy existingPolicy = policyMap.getEndpointEffectivePolicy(endpointKey);
                if (existingPolicy == null || !existingPolicy.contains(EncodingConstants.OPTIMIZED_MIME_SERIALIZATION_ASSERTION)) {
                    QName bindingName = model.getBoundPortTypeName();
                    Policy mtomPolicy = this.createMtomPolicy(bindingName);
                    PolicySubject mtomPolicySubject = new PolicySubject((Object)bindingName, mtomPolicy);
                    PolicyMapKey aKey = PolicyMap.createWsdlEndpointScopeKey(model.getServiceQName(), model.getPortName());
                    policyMapMutator.putEndpointSubject(aKey, mtomPolicySubject);
                    logger.fine("Added MTOM policy with ID \"" + mtomPolicy.getIdOrName() + "\" to binding element \"" + bindingName + "\"");
                } else {
                    logger.fine("MTOM policy exists already, doing nothing");
                }
            }
        }
        logger.exiting();
    }

    private Policy createMtomPolicy(QName bindingName) {
        ArrayList<AssertionSet> assertionSets = new ArrayList<AssertionSet>(1);
        ArrayList<MtomAssertion> assertions = new ArrayList<MtomAssertion>(1);
        assertions.add(new MtomAssertion());
        assertionSets.add(AssertionSet.createAssertionSet(assertions));
        return Policy.createPolicy(null, bindingName.getLocalPart() + "_MTOM_Policy", assertionSets);
    }

    static class MtomAssertion
    extends PolicyAssertion {
        private static final AssertionData mtomData = AssertionData.createAssertionData(EncodingConstants.OPTIMIZED_MIME_SERIALIZATION_ASSERTION);

        MtomAssertion() {
            super(mtomData, null, null);
        }
    }
}

