/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.assembler;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubelineAssembler;
import com.sun.xml.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.assembler.ClientTubelineAssemblyContext;
import com.sun.xml.ws.assembler.ServerTubelineAssemblyContext;
import com.sun.xml.ws.assembler.TubeCreator;
import com.sun.xml.ws.assembler.TubelineAssemblyController;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.dump.WrapperDumpTube;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.WsdlDocumentFilter;
import java.util.Collection;
import java.util.logging.Level;

public final class TubelineAssemblerFactoryImpl
extends TubelineAssemblerFactory {
    public TubelineAssembler doCreate(BindingID bindingId) {
        return new MetroTubelineAssembler(bindingId);
    }

    private static class MetroTubelineAssembler
    implements TubelineAssembler {
        private static final Logger LOGGER = Logger.getLogger(MetroTubelineAssembler.class);
        private final BindingID bindingId;
        private final TubelineAssemblyController tubelineAssemblyController;

        MetroTubelineAssembler(BindingID bindingId) {
            this.bindingId = bindingId;
            this.tubelineAssemblyController = new TubelineAssemblyController();
        }

        @NotNull
        public Tube createClient(@NotNull ClientTubeAssemblerContext jaxwsContext) {
            ClientTubelineAssemblyContext context = new ClientTubelineAssemblyContext(jaxwsContext);
            Collection<TubeCreator> tubeCreators = this.tubelineAssemblyController.getTubeCreators(context);
            for (TubeCreator tubeCreator : tubeCreators) {
                tubeCreator.updateContext(context);
            }
            for (TubeCreator tubeCreator : tubeCreators) {
                context.setTubelineHead(this.setupMessageDumping(tubeCreator.getMessageDumpPropertyBase(), tubeCreator.createTube(context), Side.Client));
            }
            return context.getTubelineHead();
        }

        @NotNull
        public Tube createServer(@NotNull ServerTubeAssemblerContext jaxwsContext) {
            ServerTubelineAssemblyContext context = new ServerTubelineAssemblyContext(jaxwsContext);
            ServiceDefinition sd = context.getEndpoint().getServiceDefinition();
            if (sd != null) {
                sd.addFilter(new WsdlDocumentFilter());
            }
            Collection<TubeCreator> tubeCreators = this.tubelineAssemblyController.getTubeCreators(context);
            for (TubeCreator tubeCreator : tubeCreators) {
                tubeCreator.updateContext(context);
            }
            for (TubeCreator tubeCreator : tubeCreators) {
                context.setTubelineHead(this.setupMessageDumping(tubeCreator.getMessageDumpPropertyBase(), tubeCreator.createTube(context), Side.Endpoint));
            }
            return context.getTubelineHead();
        }

        private Tube setupMessageDumping(String msgDumpSystemPropertyBase, Tube newTube, Side side) {
            boolean logBefore = false;
            boolean logAfter = false;
            Level logLevel = Level.INFO;
            Boolean value = this.getBooleanValue(msgDumpSystemPropertyBase);
            if (value != null) {
                logBefore = value;
                logAfter = value;
            }
            logBefore = (value = this.getBooleanValue(msgDumpSystemPropertyBase + ".before")) != null ? value : logBefore;
            value = this.getBooleanValue(msgDumpSystemPropertyBase + ".after");
            logAfter = value != null ? value : logAfter;
            Level levelValue = this.getLevelValue(msgDumpSystemPropertyBase + ".level");
            if (levelValue != null) {
                logLevel = levelValue;
            }
            if ((value = this.getBooleanValue(msgDumpSystemPropertyBase = msgDumpSystemPropertyBase + "." + side.toString())) != null) {
                logBefore = value;
                logAfter = value;
            }
            logBefore = (value = this.getBooleanValue(msgDumpSystemPropertyBase + ".before")) != null ? value : logBefore;
            value = this.getBooleanValue(msgDumpSystemPropertyBase + ".after");
            logAfter = value != null ? value : logAfter;
            levelValue = this.getLevelValue(msgDumpSystemPropertyBase + ".level");
            if (levelValue != null) {
                logLevel = levelValue;
            }
            if (logBefore || logAfter) {
                return new WrapperDumpTube(logBefore, logAfter, logLevel, newTube);
            }
            return newTube;
        }

        private Boolean getBooleanValue(String propertyName) {
            Boolean retVal = null;
            String stringValue = System.getProperty(propertyName);
            if (stringValue != null) {
                retVal = Boolean.valueOf(stringValue);
                LOGGER.fine(String.format("%s system property detected to be set to value %b", propertyName, retVal));
            }
            return retVal;
        }

        private Level getLevelValue(String propertyName) {
            Level retVal = null;
            String stringValue = System.getProperty(propertyName);
            if (stringValue != null) {
                LOGGER.fine(String.format("%s system property detected to be set to value %s", propertyName, stringValue));
                try {
                    retVal = Level.parse(stringValue);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warning(String.format("Illegal logging level value stored in %s system property: '%s'. Using default logging level.", propertyName, stringValue), ex);
                }
            }
            return retVal;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Side {
            Client("client"),
            Endpoint("endpoint");

            private final String name;

            private Side(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

