/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser;

import com.sun.xml.xsom.parser.XMLParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jvnet.wom.api.WSDLSet;
import org.jvnet.wom.api.parser.WOMParser;
import org.jvnet.wom.api.parser.WSDLExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.mime.MimeMultipartParser;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPAddressExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPBindingExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPBodyExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPFaultExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPHeaderExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPHeaderFaultExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPOperationExtensionHandler;
import org.jvnet.wom.impl.parser.Patch;
import org.jvnet.wom.impl.parser.PatcherManager;
import org.jvnet.wom.impl.parser.WSDLContentHandlerEx;
import org.jvnet.wom.impl.parser.WSDLDocumentImpl;
import org.jvnet.wom.impl.parser.WSDLSetImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserContext {
    public final WSDLSetImpl wsdlSet = new WSDLSetImpl();
    private final WOMParser owner;
    final XMLParser parser;
    private final Set<WSDLExtensionHandler> extensionMap = new HashSet<WSDLExtensionHandler>();
    private ContentHandler schemaContentHandler;
    private final Vector<Patch> patchers = new Vector();
    private final Vector<Patch> errorCheckers = new Vector();
    public final Map<WSDLDocumentImpl, WSDLDocumentImpl> parsedDocuments = new HashMap<WSDLDocumentImpl, WSDLDocumentImpl>();
    private boolean hadError = false;
    final PatcherManager patcherManager = new PatcherManager(){

        public void addPatcher(Patch patch) {
            ParserContext.this.patchers.add(patch);
        }

        public void addErrorChecker(Patch patch) {
            ParserContext.this.errorCheckers.add(patch);
        }

        public void reportError(String msg, Locator src) throws SAXException {
            ParserContext.this.setErrorFlag();
            SAXParseException e = new SAXParseException(msg, src);
            if (ParserContext.this.errorHandler == null) {
                throw e;
            }
            ParserContext.this.errorHandler.error(e);
        }
    };
    final ErrorHandler errorHandler = new ErrorHandler(){

        private ErrorHandler getErrorHandler() {
            if (ParserContext.this.owner.getErrorHandler() == null) {
                return ParserContext.this.noopHandler;
            }
            return ParserContext.this.owner.getErrorHandler();
        }

        public void warning(SAXParseException e) throws SAXException {
            this.getErrorHandler().warning(e);
        }

        public void error(SAXParseException e) throws SAXException {
            ParserContext.this.setErrorFlag();
            this.getErrorHandler().error(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            ParserContext.this.setErrorFlag();
            this.getErrorHandler().fatalError(e);
        }
    };
    final ErrorHandler noopHandler = new ErrorHandler(){

        public void warning(SAXParseException e) {
        }

        public void error(SAXParseException e) {
        }

        public void fatalError(SAXParseException e) {
            ParserContext.this.setErrorFlag();
        }
    };

    private void addKnownWSDLExtensionHandler(WSDLExtensionHandler ... extensionHandlers) {
        for (WSDLExtensionHandler extensionHandler : extensionHandlers) {
            this.extensionMap.add(extensionHandler);
        }
    }

    public ParserContext(WOMParser owner, XMLParser parser) {
        this.owner = owner;
        this.parser = parser;
        this.addKnownWSDLExtensionHandler(new SOAPAddressExtensionHandler(this.errorHandler, owner.getEntityResolver()), new SOAPBindingExtensionHandler(this.errorHandler, owner.getEntityResolver()), new SOAPBodyExtensionHandler(this.errorHandler, owner.getEntityResolver()), new SOAPFaultExtensionHandler(this.errorHandler, owner.getEntityResolver()), new SOAPHeaderExtensionHandler(this.errorHandler, owner.getEntityResolver()), new SOAPHeaderFaultExtensionHandler(this.errorHandler, owner.getEntityResolver()), new SOAPOperationExtensionHandler(this.errorHandler, owner.getEntityResolver()), new MimeMultipartParser(this.errorHandler, owner.getEntityResolver()));
    }

    public EntityResolver getEntityResolver() {
        return this.owner.getEntityResolver();
    }

    public void parse(InputSource source) throws SAXException {
        this.createWSDLContentHandler().parseEntity(source, null, null);
    }

    public WSDLSet getResult() throws SAXException {
        for (Patch patcher : this.patchers) {
            patcher.run();
        }
        this.patchers.clear();
        for (Patch patcher : this.errorCheckers) {
            patcher.run();
        }
        this.errorCheckers.clear();
        if (this.hadError) {
            return null;
        }
        return this.wsdlSet;
    }

    public WSDLContentHandlerEx createWSDLContentHandler() {
        return new WSDLContentHandlerEx(this);
    }

    void setErrorFlag() {
        this.hadError = true;
    }

    public ContentHandler getSchemaContentHandler() {
        return this.schemaContentHandler;
    }

    public void setSchemaContentHandler(ContentHandler schemaContentHandler) {
        this.schemaContentHandler = schemaContentHandler;
    }

    public void addWSDLExtensionHandler(WSDLExtensionHandler extension) {
        this.extensionMap.add(extension);
    }

    public Set<WSDLExtensionHandler> getWSDLExtensionHandlers() {
        return this.extensionMap;
    }
}

