/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.rm.runtime.ClientSession;
import com.sun.xml.ws.rx.util.TimestampedCollection;
import java.util.logging.Level;

final class FiberResumeTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(FiberResumeTask.class);
    private final TimestampedCollection<Object, FiberRegistration> suspendedFibers = new TimestampedCollection();
    private final ClientSession session;

    public FiberResumeTask(ClientSession session) {
        this.session = session;
    }

    public void run() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Periodic fiber resume task executed - suspended queue size: [ %d ]", this.suspendedFibers.size()));
        }
        while (!this.suspendedFibers.isEmpty() && this.expired(this.suspendedFibers.getOldestRegistrationTimestamp())) {
            FiberRegistration registration = this.suspendedFibers.removeOldest();
            registration.fiber.resume(this.session.appendOutgoingAcknowledgementHeaders(registration.packet));
            if (!LOGGER.isLoggable(Level.FINER)) continue;
            LOGGER.finer(String.format("Fiber %s resumed with packet%n%s", registration.fiber, registration.packet));
        }
    }

    private final boolean expired(long resumeTime) {
        return System.currentTimeMillis() >= resumeTime;
    }

    final boolean register(@NotNull Fiber fiber, Packet packet, long executionTime) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Fiber %s registered for resume with packet%n%s", fiber, packet));
        }
        return this.suspendedFibers.register(executionTime, new FiberRegistration(fiber, packet));
    }

    private static class FiberRegistration {
        @NotNull
        private final Fiber fiber;
        private final Packet packet;

        FiberRegistration(Fiber fiber, Packet packet) {
            this.fiber = fiber;
            this.packet = packet;
        }
    }
}

