/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.java.JavaInterface;
import com.sun.tools.ws.resources.GeneratorMessages;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.document.PortType;
import com.sun.xml.bind.api.JAXBRIContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;
import org.xml.sax.Locator;

public class ServiceGenerator
extends GeneratorBase {
    public static void generate(Model model, WsimportOptions options, ErrorReceiver receiver) {
        ServiceGenerator serviceGenerator = new ServiceGenerator(model, options, receiver);
        serviceGenerator.doGeneration();
    }

    private ServiceGenerator(Model model, WsimportOptions options, ErrorReceiver receiver) {
        super(model, options, receiver);
    }

    public void visit(Service service) {
        JDefinedClass cls;
        JavaInterface intf = service.getJavaInterface();
        String className = Names.customJavaTypeClassName(intf);
        if (this.donotOverride && GeneratorUtil.classExists(this.options, className)) {
            this.log("Class " + className + " exists. Not overriding.");
            return;
        }
        try {
            cls = this.getClass(className, ClassType.CLASS);
        }
        catch (JClassAlreadyExistsException e) {
            this.receiver.error(service.getLocator(), GeneratorMessages.GENERATOR_SERVICE_CLASS_ALREADY_EXIST(className, service.getName()));
            return;
        }
        cls._extends(javax.xml.ws.Service.class);
        String serviceFieldName = JAXBRIContext.mangleNameToClassName((String)service.getName().getLocalPart()).toUpperCase();
        String wsdlLocationName = serviceFieldName + "_WSDL_LOCATION";
        JFieldVar urlField = cls.field(28, URL.class, wsdlLocationName);
        String serviceName = serviceFieldName + "_QNAME";
        cls.field(28, QName.class, serviceName, (JExpression)JExpr._new((JClass)this.cm.ref(QName.class)).arg(service.getName().getNamespaceURI()).arg(service.getName().getLocalPart()));
        cls.field(28, Logger.class, "logger", (JExpression)this.cm.ref(Logger.class).staticInvoke("getLogger").arg((JExpression)JExpr.dotclass((JClass)this.cm.ref(className)).invoke("getName")));
        JClass qNameCls = this.cm.ref(QName.class);
        JInvocation inv = JExpr._new((JClass)qNameCls);
        inv.arg("namespace");
        inv.arg("localpart");
        JBlock staticBlock = cls.init();
        JVar urlVar = staticBlock.decl((JType)this.cm.ref(URL.class), "url", JExpr._null());
        JTryBlock tryBlock = staticBlock._try();
        JVar baseUrl = tryBlock.body().decl((JType)this.cm.ref(URL.class), "baseUrl");
        tryBlock.body().assign((JAssignmentTarget)baseUrl, (JExpression)JExpr.dotclass((JClass)this.cm.ref(className)).invoke("getResource").arg("."));
        tryBlock.body().assign((JAssignmentTarget)urlVar, (JExpression)JExpr._new((JClass)this.cm.ref(URL.class)).arg((JExpression)baseUrl).arg(this.wsdlLocation));
        JCatchBlock catchBlock = tryBlock._catch(this.cm.ref(MalformedURLException.class));
        catchBlock.param("e");
        catchBlock.body().directStatement("logger.warning(\"Failed to create URL for the wsdl Location: " + JExpr.quotify((char)'\'', (String)this.wsdlLocation) + ", retrying as a local file\");");
        catchBlock.body().directStatement("logger.warning(e.getMessage());");
        staticBlock.assign((JAssignmentTarget)urlField, (JExpression)urlVar);
        JDocComment comment = cls.javadoc();
        if (service.getJavaDoc() != null) {
            comment.add((Object)service.getJavaDoc());
            comment.add((Object)"\n\n");
        }
        for (String doc : this.getJAXWSClassComment()) {
            comment.add((Object)doc);
        }
        JMethod constructor1 = cls.constructor(1);
        String constructor1Str = String.format("super(%s, %s);", wsdlLocationName, serviceName);
        constructor1.body().directStatement(constructor1Str);
        if (this.options.target.isLaterThan(Options.Target.V2_2)) {
            JMethod constructor2 = cls.constructor(1);
            constructor2.varParam(WebServiceFeature.class, "features");
            String constructor2Str = String.format("super(%s, %s, features);", wsdlLocationName, serviceName);
            constructor2.body().directStatement(constructor2Str);
        }
        JMethod constructor3 = cls.constructor(1);
        constructor3.param(URL.class, "wsdlLocation");
        String constructor3Str = String.format("super(wsdlLocation, %s);", serviceName);
        constructor3.body().directStatement(constructor3Str);
        if (this.options.target.isLaterThan(Options.Target.V2_2)) {
            JMethod constructor4 = cls.constructor(1);
            constructor4.param(URL.class, "wsdlLocation");
            constructor4.varParam(WebServiceFeature.class, "features");
            String constructor4Str = String.format("super(wsdlLocation, %s, features);", serviceName);
            constructor4.body().directStatement(constructor4Str);
        }
        JMethod constructor5 = cls.constructor(1);
        constructor5.param(URL.class, "wsdlLocation");
        constructor5.param(QName.class, "serviceName");
        constructor5.body().directStatement("super(wsdlLocation, serviceName);");
        if (this.options.target.isLaterThan(Options.Target.V2_2)) {
            JMethod constructor6 = cls.constructor(1);
            constructor6.param(URL.class, "wsdlLocation");
            constructor6.param(QName.class, "serviceName");
            constructor6.varParam(WebServiceFeature.class, "features");
            constructor6.body().directStatement("super(wsdlLocation, serviceName, features);");
        }
        JAnnotationUse webServiceClientAnn = cls.annotate(this.cm.ref(WebServiceClient.class));
        this.writeWebServiceClientAnnotation(service, webServiceClientAnn);
        this.writeHandlerConfig(Names.customJavaTypeClassName(service.getJavaInterface()), cls, this.options);
        for (Port port : service.getPorts()) {
            JDefinedClass retType;
            if (port.isProvider()) continue;
            try {
                retType = this.getClass(port.getJavaInterface().getName(), ClassType.INTERFACE);
            }
            catch (JClassAlreadyExistsException e) {
                PortType pt;
                QName portTypeName = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLPortTypeName");
                Locator loc = null;
                if (portTypeName != null && (pt = port.portTypes.get(portTypeName)) != null) {
                    loc = pt.getLocator();
                }
                this.receiver.error(loc, GeneratorMessages.GENERATOR_SEI_CLASS_ALREADY_EXIST(port.getJavaInterface().getName(), portTypeName));
                return;
            }
            this.writeDefaultGetPort(port, (JType)retType, cls);
            if (!this.options.target.isLaterThan(Options.Target.V2_1)) continue;
            this.writeGetPort(port, (JType)retType, cls);
        }
    }

    private void writeGetPort(Port port, JType retType, JDefinedClass cls) {
        JMethod m = cls.method(1, retType, port.getPortGetter());
        JDocComment methodDoc = m.javadoc();
        if (port.getJavaDoc() != null) {
            methodDoc.add((Object)port.getJavaDoc());
        }
        JCommentPart ret = methodDoc.addReturn();
        JCommentPart paramDoc = methodDoc.addParam("features");
        paramDoc.append((Object)"A list of ");
        paramDoc.append((Object)("{@link " + WebServiceFeature.class.getName() + "}"));
        paramDoc.append((Object)"to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.");
        ret.add((Object)("returns " + retType.name()));
        m.varParam(WebServiceFeature.class, "features");
        JBlock body = m.body();
        StringBuffer statement = new StringBuffer("return ");
        statement.append("super.getPort(new QName(\"").append(port.getName().getNamespaceURI()).append("\", \"").append(port.getName().getLocalPart()).append("\"), ");
        statement.append(retType.name());
        statement.append(".class, features);");
        body.directStatement(statement.toString());
        this.writeWebEndpoint(port, m);
    }

    private void writeDefaultGetPort(Port port, JType retType, JDefinedClass cls) {
        String portGetter = port.getPortGetter();
        JMethod m = cls.method(1, retType, portGetter);
        JDocComment methodDoc = m.javadoc();
        if (port.getJavaDoc() != null) {
            methodDoc.add((Object)port.getJavaDoc());
        }
        JCommentPart ret = methodDoc.addReturn();
        ret.add((Object)("returns " + retType.name()));
        JBlock body = m.body();
        StringBuffer statement = new StringBuffer("return ");
        statement.append("super.getPort(new QName(\"").append(port.getName().getNamespaceURI()).append("\", \"").append(port.getName().getLocalPart()).append("\"), ");
        statement.append(retType.name());
        statement.append(".class);");
        body.directStatement(statement.toString());
        this.writeWebEndpoint(port, m);
    }

    private void writeWebServiceClientAnnotation(Service service, JAnnotationUse wsa) {
        String serviceName = service.getName().getLocalPart();
        String serviceNS = service.getName().getNamespaceURI();
        wsa.param("name", serviceName);
        wsa.param("targetNamespace", serviceNS);
        wsa.param("wsdlLocation", this.wsdlLocation);
    }

    private void writeWebEndpoint(Port port, JMethod m) {
        JAnnotationUse webEndpointAnn = m.annotate(this.cm.ref(WebEndpoint.class));
        webEndpointAnn.param("name", port.getName().getLocalPart());
    }
}

