/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.typelib;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.gmbal.generic.Graph;
import org.glassfish.gmbal.generic.Predicate;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatedClassAnalyzer {
    private static final Graph.Finder<EvaluatedClassDeclaration> finder = new Graph.Finder<EvaluatedClassDeclaration>(){

        @Override
        public List<EvaluatedClassDeclaration> evaluate(EvaluatedClassDeclaration arg) {
            return arg.inheritance();
        }
    };
    private List<EvaluatedClassDeclaration> classInheritance;
    private String contents = null;

    private EvaluatedClassAnalyzer(Graph<EvaluatedClassDeclaration> gr) {
        ArrayList<EvaluatedClassDeclaration> result = new ArrayList<EvaluatedClassDeclaration>(gr.getPostorderList());
        Collections.reverse(result);
        this.classInheritance = result;
    }

    public EvaluatedClassAnalyzer(EvaluatedClassDeclaration cls) {
        this(new Graph<EvaluatedClassDeclaration>(cls, finder));
    }

    public EvaluatedClassAnalyzer(List<EvaluatedClassDeclaration> decls) {
        this(new Graph<EvaluatedClassDeclaration>((EvaluatedClassDeclaration)((Object)decls), finder));
    }

    public <T extends EvaluatedDeclaration> Predicate<T> forAnnotation(final ManagedObjectManagerInternal mom, final Class<? extends Annotation> annotation, Class<T> type) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T elem) {
                if (mom == null) {
                    return elem.annotation(annotation) != null;
                }
                return mom.getAnnotation((EvaluatedDeclaration)elem, annotation) != null;
            }
        };
    }

    public List<EvaluatedClassDeclaration> findClasses(Predicate<EvaluatedClassDeclaration> pred) {
        ArrayList<EvaluatedClassDeclaration> result = new ArrayList<EvaluatedClassDeclaration>();
        for (EvaluatedClassDeclaration c : this.classInheritance) {
            if (!pred.evaluate(c)) continue;
            result.add(c);
        }
        return result;
    }

    public List<EvaluatedMethodDeclaration> findMethods(Predicate<EvaluatedMethodDeclaration> pred) {
        ArrayList<EvaluatedMethodDeclaration> result = new ArrayList<EvaluatedMethodDeclaration>();
        for (EvaluatedClassDeclaration c : this.classInheritance) {
            for (EvaluatedMethodDeclaration m : c.methods()) {
                if (!pred.evaluate(m)) continue;
                result.add(m);
            }
        }
        return result;
    }

    public synchronized String toString() {
        if (this.contents == null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            sb.append("ClassAnalyzer[");
            for (EvaluatedClassDeclaration cls : this.classInheritance) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" ");
                }
                sb.append(cls.name());
            }
            sb.append("]");
            this.contents = sb.toString();
        }
        return this.contents;
    }
}

