/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.runtime.ClientSession;
import com.sun.xml.ws.rx.rm.runtime.PacketAdapter;
import com.sun.xml.ws.rx.rm.runtime.RmClientTube;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.rx.util.TimestampedCollection;
import java.util.logging.Level;

public class RequestResendTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(RequestResendTask.class);
    private final TimestampedCollection<Object, RequestRegistration> scheduledPackets = new TimestampedCollection();
    private final Communicator communicator;
    private final ClientSession session;

    RequestResendTask(@NotNull Communicator communicator, @NotNull ClientSession session) {
        this.communicator = communicator;
        this.session = session;
    }

    public void run() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Periodic request resend task executed - suspended queue size: [ %d ]", this.scheduledPackets.size()));
        }
        while (!this.scheduledPackets.isEmpty() && this.expired(this.scheduledPackets.getOldestRegistrationTimestamp())) {
            RequestRegistration requestRegistration = this.scheduledPackets.removeOldest();
            PacketAdapter request = PacketAdapter.getInstance(this.session.configuration, requestRegistration.request);
            if (!this.session.isRequestAcknowledged(request)) {
                Packet requestPacketCopy = request.getPacket().copy(true);
                this.communicator.sendAsync(this.session.appendOutgoingAcknowledgementHeaders(request.getPacket()), new RequestResendCallbackHandler(this.session, requestPacketCopy, requestRegistration.nextResendAttemptNumber + 1));
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.finer(String.format("Resending request packet with message id [ %d ] on the sequence [ %s ]", request.getMessageNumber(), request.getSequenceId()));
                continue;
            }
            if (!LOGGER.isLoggable(Level.FINER)) continue;
            LOGGER.finer(String.format("Request packet with message id [ %d ] on the sequence [ %s ] already acknowledged - resend cancelled.", request.getMessageNumber(), request.getSequenceId()));
        }
    }

    private final boolean expired(long resumeTime) {
        return System.currentTimeMillis() >= resumeTime;
    }

    final boolean register(@NotNull Packet request, int resendCounter, long executionTime) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("A packet has been scheduled for a resend:%n%s", request));
        }
        return this.scheduledPackets.register(executionTime, new RequestRegistration(request, resendCounter));
    }

    private static final class RequestRegistration {
        final Packet request;
        final int nextResendAttemptNumber;

        public RequestRegistration(Packet request, int nextResendAttemptNumber) {
            this.request = request;
            this.nextResendAttemptNumber = nextResendAttemptNumber;
        }
    }

    private static final class RequestResendCallbackHandler
    implements Fiber.CompletionCallback {
        private final Packet requestPacketCopy;
        private final ClientSession session;
        private final int nextResendAttemptNumber;

        public RequestResendCallbackHandler(ClientSession session, Packet requestCopy, int nextResendAttemptNumber) {
            this.requestPacketCopy = requestCopy;
            this.session = session;
            this.nextResendAttemptNumber = nextResendAttemptNumber;
        }

        public void onCompletion(Packet response) {
            if (!this.session.isRequestAcknowledged(this.requestPacketCopy)) {
                this.session.registerForResend(this.requestPacketCopy, this.nextResendAttemptNumber);
            }
        }

        public void onCompletion(Throwable error) {
            if (!RmClientTube.isResendPossible(error) || this.session.isRequestAcknowledged(this.requestPacketCopy)) {
                PacketAdapter request = PacketAdapter.getInstance(this.session.configuration, this.requestPacketCopy);
                throw LOGGER.logSevereException(new RxRuntimeException(String.format("Resend of a one-way message with message id [ %d ] on the sequence [ %s ] failed with an exception", request.getMessageNumber(), request.getSequenceId()), error));
            }
            this.session.registerForResend(this.requestPacketCopy, this.nextResendAttemptNumber);
        }
    }
}

