/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.xml.stream.buffer.AbstractCreatorProcessor;
import com.sun.xml.stream.buffer.XMLStreamBufferMark;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBValidateContext;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.KeySelectorImpl;
import com.sun.xml.ws.security.opt.impl.incoming.StreamWriterData;
import com.sun.xml.ws.security.opt.impl.incoming.URIResolver;
import com.sun.xml.ws.security.opt.impl.incoming.processor.KeyValueProcessor;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.math.BigInteger;
import java.security.Key;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;

public class SecurityTokenProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.token", "com.sun.xml.wss.logging.impl.opt.token.LogStrings");
    private static String SECURITY_TOKEN_REF = "SecurityTokenReference";
    private static String DIRECT_REFERENCE_ELEMENT = "Reference";
    private static String KEYIDENTIFIER_ELEMENT = "KeyIdentifier";
    private static String THUMBPRINT_ELEMENT = "Thumbprint";
    private static final String KEY_VALUE = "KeyValue";
    private static final String X509DATA_ELEMENT = "X509Data";
    private static final String X509ISSUERSERIAL_ELEMENT = "X509IssuerSerial";
    private static final String X509ISSUERNAME_ELEMENT = "X509IssuerName";
    private static final String X509SERIALNUMBER_ELEMENT = "X509SerialNumber";
    private static final String KEY_NAME = "KeyName";
    private static final int DIRECT_REFERENCE = 1;
    private static final int KEYIDENTIFIER = 2;
    private static final int THUMBPRINT = 3;
    private static final int KEY_VALUE_ELEMENT = 4;
    private static final int X509DATA = 5;
    private static final int X509ISSUERSERIAL = 6;
    private static final int X509ISSUERNAME = 7;
    private static final int X509SERIALNUMBER = 8;
    private static final int SECURITY_TOKEN_REFERENCE = 9;
    private static final int KEY_NAME_ELEMENT = 10;
    private JAXBFilterProcessingContext pc = null;
    private XMLStreamWriter canonWriter = null;
    private KeySelector.Purpose purpose = null;
    private String id = "";

    public SecurityTokenProcessor(JAXBFilterProcessingContext context, KeySelector.Purpose purpose) {
        this.pc = context;
        this.purpose = purpose;
    }

    public SecurityTokenProcessor(JAXBFilterProcessingContext context, XMLStreamWriter canonWriter, KeySelector.Purpose purpose) {
        this.pc = context;
        this.canonWriter = canonWriter;
        this.purpose = purpose;
    }

    public Key resolveReference(XMLStreamReader reader) throws XWSSecurityException {
        Key resolvedKey = null;
        try {
            if (this.canonWriter != null) {
                StreamUtil.writeStartElement(reader, this.canonWriter);
            }
            this.id = reader.getAttributeValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            if (this.id != null && this.id.length() > 0 && reader instanceof AbstractCreatorProcessor) {
                Map<String, String> emptyMap = Collections.emptyMap();
                XMLStreamBufferMark marker = new XMLStreamBufferMark(emptyMap, (AbstractCreatorProcessor)((Object)reader));
                this.pc.getElementCache().put(this.id, new StreamWriterData(marker));
            }
            if (reader.getLocalName() == SECURITY_TOKEN_REF && reader.getNamespaceURI() == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
                while (reader.hasNext() && !StreamUtil._break(reader, SECURITY_TOKEN_REF, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) {
                    reader.next();
                    int refType = this.getReferenceType(reader);
                    switch (refType) {
                        case 1: {
                            resolvedKey = this.processDirectReference(reader);
                            break;
                        }
                        case 2: {
                            resolvedKey = this.processKeyIdentifier(reader);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            if (this.canonWriter != null) {
                                StreamUtil.writeCurrentEvent(reader, this.canonWriter);
                            }
                            resolvedKey = new KeyValueProcessor(this.pc, this.canonWriter).processKeyValue(reader);
                            break;
                        }
                        case 5: {
                            resolvedKey = this.processX509Data(reader);
                            break;
                        }
                        case 9: {
                            if (!this.pc.isBSP()) break;
                            logger.log(Level.SEVERE, LogStringsMessages.BSP_3057_STR_NOT_REF_STR());
                            throw new XWSSecurityException(LogStringsMessages.BSP_3057_STR_NOT_REF_STR());
                        }
                        case 10: {
                            if (!this.pc.isBSP()) break;
                            logger.log(Level.SEVERE, LogStringsMessages.BSP_3058_STR_VALUE_TYPE_NOTEMPTY());
                            throw new XWSSecurityException(LogStringsMessages.BSP_3058_STR_VALUE_TYPE_NOTEMPTY());
                        }
                    }
                }
            }
            if (this.canonWriter != null) {
                this.canonWriter.writeEndElement();
            }
            if (reader.hasNext()) {
                reader.next();
            }
        }
        catch (XMLStreamException xe) {
            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1815_ERROR_PROCESSING_STR());
            throw new XWSSecurityException(com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1815_ERROR_PROCESSING_STR(), xe);
        }
        return resolvedKey;
    }

    private int getReferenceType(XMLStreamReader reader) {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == DIRECT_REFERENCE_ELEMENT) {
                return 1;
            }
            if (reader.getLocalName() == KEYIDENTIFIER_ELEMENT) {
                return 2;
            }
            if (reader.getLocalName() == THUMBPRINT_ELEMENT) {
                return 3;
            }
            if (reader.getLocalName() == KEY_VALUE) {
                return 4;
            }
            if (reader.getLocalName() == X509DATA_ELEMENT) {
                return 5;
            }
            if (reader.getLocalName() == KEY_NAME) {
                return 10;
            }
            if (reader.getLocalName() == SECURITY_TOKEN_REF) {
                return 9;
            }
        }
        return -1;
    }

    private boolean moveToNextElement(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            reader.next();
            return true;
        }
        return false;
    }

    private Key processDirectReference(XMLStreamReader reader) throws XWSSecurityException {
        try {
            if (this.canonWriter != null) {
                StreamUtil.writeStartElement(reader, this.canonWriter);
            }
            String uri = reader.getAttributeValue(null, "URI");
            if (this.pc.isBSP() && uri == null) {
                logger.log(Level.SEVERE, LogStringsMessages.BSP_3062_STR_URIATTRIBUTE());
                throw new XWSSecurityException(LogStringsMessages.BSP_3062_STR_URIATTRIBUTE());
            }
            String vt = reader.getAttributeValue(null, "ValueType");
            if (this.pc.isBSP() && (vt == null || vt.length() == 0)) {
                logger.log(Level.SEVERE, LogStringsMessages.BSP_3058_STR_VALUE_TYPE_NOTEMPTY());
                throw new XWSSecurityException(LogStringsMessages.BSP_3058_STR_VALUE_TYPE_NOTEMPTY());
            }
            String wscInstance = reader.getAttributeValue(this.pc.getWSSCVersion(this.pc.getSecurityPolicyVersion()), "Instance");
            if (wscInstance != null) {
                this.pc.setWSCInstance(wscInstance);
            }
            if (this.canonWriter != null) {
                this.canonWriter.writeEndElement();
            }
            URIResolver resolver = new URIResolver(this.pc);
            JAXBValidateContext validateContext = new JAXBValidateContext();
            validateContext.setURIDereferencer(resolver);
            validateContext.put("http://wss.sun.com#processingContext", this.pc);
            reader.next();
            reader.next();
            return KeySelectorImpl.resolveDirectReference(validateContext, vt, uri, this.purpose);
        }
        catch (KeySelectorException kse) {
            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1816_ERROR_REFERENCE_MECHANISM("Direct Reference"));
            throw new XWSSecurityException(com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1816_ERROR_REFERENCE_MECHANISM("Direct Reference"), kse);
        }
        catch (XMLStreamException xse) {
            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1817_ERROR_REFERENCE_CANWRITER("Direct Reference"));
            throw new XWSSecurityException(com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1817_ERROR_REFERENCE_CANWRITER("Direct Reference"), xse);
        }
    }

    private Key processX509Data(XMLStreamReader reader) throws XWSSecurityException {
        try {
            Key returnKey = null;
            if (this.canonWriter != null) {
                StreamUtil.writeStartElement(reader, this.canonWriter);
            }
            while (reader.hasNext() && !StreamUtil._break(reader, X509DATA_ELEMENT, "http://www.w3.org/2000/09/xmldsig#")) {
                reader.next();
                int eventType = this.getEventTypeForX509Data(reader);
                switch (eventType) {
                    case 6: {
                        returnKey = this.processX509IssuerSerial(reader);
                    }
                }
            }
            return returnKey;
        }
        catch (XMLStreamException xse) {
            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1817_ERROR_REFERENCE_CANWRITER("Issuer Serial"));
            throw new XWSSecurityException(com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1817_ERROR_REFERENCE_CANWRITER("Issuer Serial"), xse);
        }
    }

    private int getEventTypeForX509Data(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() == 1 && reader.getLocalName() == X509ISSUERSERIAL_ELEMENT) {
            return 6;
        }
        return -1;
    }

    private Key processX509IssuerSerial(XMLStreamReader reader) throws XWSSecurityException {
        try {
            Key returnKey = null;
            if (this.canonWriter != null) {
                StreamUtil.writeStartElement(reader, this.canonWriter);
            }
            BigInteger serialNumber = null;
            String issuerName = null;
            block7: while (reader.hasNext() && !StreamUtil._break(reader, X509ISSUERSERIAL_ELEMENT, "http://www.w3.org/2000/09/xmldsig#")) {
                reader.next();
                int eventType = this.getEventTypeForX509IssuerSerial(reader);
                switch (eventType) {
                    case 7: {
                        if (this.canonWriter != null) {
                            StreamUtil.writeStartElement(reader, this.canonWriter);
                        }
                        reader.next();
                        issuerName = StreamUtil.getCV(reader);
                        if (this.canonWriter == null) continue block7;
                        this.canonWriter.writeCharacters(issuerName);
                        continue block7;
                    }
                    case 8: {
                        if (this.canonWriter != null) {
                            StreamUtil.writeStartElement(reader, this.canonWriter);
                        }
                        reader.next();
                        String tmp = StreamUtil.getCV(reader);
                        serialNumber = new BigInteger(tmp);
                        if (this.canonWriter == null) continue block7;
                        this.canonWriter.writeCharacters(tmp);
                        continue block7;
                    }
                }
                if (this.canonWriter == null) continue;
                StreamUtil.writeCurrentEvent(reader, this.canonWriter);
            }
            if (issuerName != null && serialNumber != null) {
                URIResolver resolver = new URIResolver(this.pc);
                JAXBValidateContext validateContext = new JAXBValidateContext();
                validateContext.setURIDereferencer(resolver);
                validateContext.put("http://wss.sun.com#processingContext", this.pc);
                returnKey = KeySelectorImpl.resolveIssuerSerial(validateContext, issuerName, serialNumber, this.id, this.purpose);
            }
            return returnKey;
        }
        catch (KeySelectorException kse) {
            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1816_ERROR_REFERENCE_MECHANISM("Issuer Serial"));
            throw new XWSSecurityException(com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1816_ERROR_REFERENCE_MECHANISM("Issuer Serial"), kse);
        }
        catch (XMLStreamException xse) {
            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1817_ERROR_REFERENCE_CANWRITER("Issuer Serial"));
            throw new XWSSecurityException(com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1817_ERROR_REFERENCE_CANWRITER("Issuer Serial"), xse);
        }
    }

    private int getEventTypeForX509IssuerSerial(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == X509ISSUERNAME_ELEMENT) {
                return 7;
            }
            if (reader.getLocalName() == X509SERIALNUMBER_ELEMENT) {
                return 8;
            }
        }
        return -1;
    }

    private Key processKeyIdentifier(XMLStreamReader reader) throws XWSSecurityException {
        try {
            String et;
            if (this.canonWriter != null) {
                StreamUtil.writeStartElement(reader, this.canonWriter);
            }
            String valueType = reader.getAttributeValue(null, "ValueType");
            if (this.pc.isBSP() && ((et = reader.getAttributeValue(null, "EncodingType")) == null || et.length() == 0)) {
                logger.log(Level.SEVERE, LogStringsMessages.BSP_3071_STR_ENCODING_TYPE());
                throw new XWSSecurityException(LogStringsMessages.BSP_3071_STR_ENCODING_TYPE());
            }
            String keyIdentifier = null;
            if (reader instanceof XMLStreamReaderEx) {
                reader.next();
                if (reader.getEventType() == 4) {
                    CharSequence charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                    if (charSeq instanceof Base64Data) {
                        Base64Data bd = (Base64Data)charSeq;
                        keyIdentifier = bd.toString();
                    } else {
                        keyIdentifier = StreamUtil.getCV((XMLStreamReaderEx)reader);
                    }
                }
            } else {
                keyIdentifier = StreamUtil.getCV(reader);
            }
            if (this.canonWriter != null) {
                this.canonWriter.writeCharacters(keyIdentifier);
                this.canonWriter.writeEndElement();
            }
            reader.next();
            URIResolver resolver = new URIResolver(this.pc);
            JAXBValidateContext validateContext = new JAXBValidateContext();
            validateContext.setURIDereferencer(resolver);
            validateContext.put("http://wss.sun.com#processingContext", this.pc);
            return KeySelectorImpl.resolveKeyIdentifier(validateContext, valueType, keyIdentifier, this.id, this.purpose);
        }
        catch (KeySelectorException kse) {
            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1816_ERROR_REFERENCE_MECHANISM("KeyIdentifier"));
            throw new XWSSecurityException(com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1816_ERROR_REFERENCE_MECHANISM("KeyIdentifier"), kse);
        }
        catch (XMLStreamException xe) {
            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1817_ERROR_REFERENCE_CANWRITER("KeyIdentifier"));
            throw new XWSSecurityException(com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages.WSS_1817_ERROR_REFERENCE_CANWRITER("KeyIdentifier"), xe);
        }
    }
}

