/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.jaxws.impl;

import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.security.secconv.client.SCTokenConfiguration;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenManager;
import com.sun.xml.ws.api.security.trust.client.STSIssuedTokenConfiguration;
import com.sun.xml.ws.assembler.WsitClientTubeAssemblyContext;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.impl.kerberos.KerberosContext;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.policy.IssuedToken;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secconv.impl.client.DefaultSCTokenConfiguration;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.impl.client.DefaultSTSIssuedTokenConfiguration;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.DefaultCallbackHandler;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.jaxws.impl.ClientPipeConfiguration;
import com.sun.xml.wss.jaxws.impl.Constants;
import com.sun.xml.wss.jaxws.impl.PolicyResolverImpl;
import com.sun.xml.wss.jaxws.impl.SecurityTubeBase;
import com.sun.xml.wss.jaxws.impl.logging.LogStringsMessages;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.bind.JAXBElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityClientTube
extends SecurityTubeBase
implements SecureConversationInitiator {
    private IssuedTokenManager itm = IssuedTokenManager.getInstance();
    private Hashtable<String, String> scPolicyIDtoSctIdMap = new Hashtable();
    private Set trustConfig = null;
    private Set wsscConfig = null;
    private Engine fiberEngine;

    public SecurityClientTube(WsitClientTubeAssemblyContext wsitContext, Tube nextTube) {
        super(new ClientPipeConfiguration(wsitContext.getPolicyMap(), wsitContext.getWsdlPort(), wsitContext.getBinding()), nextTube);
        CallbackHandler handler = null;
        try {
            Iterator it = this.outMessagePolicyMap.values().iterator();
            SecurityPolicyHolder holder = (SecurityPolicyHolder)it.next();
            Set configAssertions = holder.getConfigAssertions("http://schemas.sun.com/2006/03/wss/client");
            this.trustConfig = holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/trust/client");
            this.wsscConfig = holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/sc/client");
            Properties props = new Properties();
            handler = this.configureClientHandler(configAssertions, props);
            this.secEnv = new DefaultSecurityEnvironmentImpl(handler, props);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0023_ERROR_CREATING_NEW_INSTANCE_SEC_CLIENT_TUBE(), e);
            throw new RuntimeException(LogStringsMessages.WSSTUBE_0023_ERROR_CREATING_NEW_INSTANCE_SEC_CLIENT_TUBE(), e);
        }
    }

    protected SecurityClientTube(SecurityClientTube that, TubeCloner cloner) {
        super(that, cloner);
        this.trustConfig = that.trustConfig;
        this.wsscConfig = that.wsscConfig;
        this.scPolicyIDtoSctIdMap = that.scPolicyIDtoSctIdMap;
    }

    @Override
    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new SecurityClientTube(this, cloner);
    }

    @Override
    public NextAction processRequest(Packet packet) {
        try {
            packet = this.processClientRequestPacket(packet);
        }
        catch (Throwable t2) {
            WebServiceException t2;
            if (!(t2 instanceof WebServiceException)) {
                t2 = new WebServiceException(t2);
            }
            return this.doThrow(t2);
        }
        return this.doInvoke(this.next, packet);
    }

    public Packet processClientRequestPacket(Packet packet) {
        boolean isTrustMsg = false;
        if ("true".equals(packet.invocationProperties.get("isTrustMessage"))) {
            isTrustMsg = true;
            String action = (String)packet.invocationProperties.get("trustAction");
            HeaderList headers = packet.getMessage().getHeaders();
            headers.fillRequestAddressingHeaders(packet, this.addVer, this.soapVersion, false, action);
        }
        Message msg = packet.getMessage();
        boolean isSCMessage = this.isSCMessage(packet);
        if (!isSCMessage && !this.isSCCancel(packet)) {
            this.invokeSCPlugin(packet);
        }
        this.invokeTrustPlugin(packet, isSCMessage);
        ProcessingContext ctx = this.initializeOutgoingProcessingContext(packet, isSCMessage);
        ((ProcessingContextImpl)ctx).setIssuedTokenContextMap(this.issuedTokenContextMap);
        ((ProcessingContextImpl)ctx).setSCPolicyIDtoSctIdMap(this.scPolicyIDtoSctIdMap);
        ctx.isClient(true);
        try {
            if (this.hasKerberosTokenPolicy()) {
                this.populateKerberosContext(packet, (ProcessingContextImpl)ctx, isSCMessage);
            }
        }
        catch (XWSSecurityException xwsse) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0024_ERROR_SECURING_OUTBOUND_MSG(), xwsse);
            throw new WebServiceException(LogStringsMessages.WSSTUBE_0024_ERROR_SECURING_OUTBOUND_MSG(), xwsse);
        }
        if (this.isSCRenew(packet)) {
            DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(this.wsscVer.getNamespaceURI(), (MessagePolicy)ctx.getSecurityPolicy());
            IssuedTokenContext itc = this.itm.createIssuedTokenContext(config, packet.endpointAddress.toString());
            try {
                this.itm.renewIssuedToken(itc);
            }
            catch (WSTrustException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
                throw new WebServiceException(LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
            }
        }
        try {
            if (!this.optimized) {
                if (!isSCMessage) {
                    this.cacheOperation(msg);
                }
                SOAPMessage soapMessage = msg.readAsSOAPMessage();
                soapMessage = this.secureOutboundMessage(soapMessage, ctx);
                msg = Messages.create(soapMessage);
            } else {
                msg = this.secureOutboundMessage(msg, ctx);
            }
        }
        catch (WssSoapFaultException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0024_ERROR_SECURING_OUTBOUND_MSG(), ex);
            throw new WebServiceException(LogStringsMessages.WSSTUBE_0024_ERROR_SECURING_OUTBOUND_MSG(), this.getSOAPFaultException(ex));
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0024_ERROR_SECURING_OUTBOUND_MSG(), se);
            throw new WebServiceException(LogStringsMessages.WSSTUBE_0024_ERROR_SECURING_OUTBOUND_MSG(), se);
        }
        packet.setMessage(msg);
        if (this.isSCRenew(packet)) {
            Token scToken = (Token)packet.invocationProperties.get(Constants.SC_ASSERTION);
            DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(this.wsscVer.getNamespaceURI(), this.getOutgoingXWSBootstrapPolicy(scToken), false);
            IssuedTokenContext itc = this.itm.createIssuedTokenContext(config, packet.endpointAddress.toString());
            try {
                this.itm.renewIssuedToken(itc);
            }
            catch (WSTrustException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
                throw new WebServiceException(LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
            }
        }
        return packet;
    }

    @Override
    public NextAction processResponse(Packet ret) {
        try {
            ret = this.processClientResponsePacket(ret);
        }
        catch (Throwable t2) {
            WebServiceException t2;
            if (!(t2 instanceof WebServiceException)) {
                t2 = new WebServiceException(t2);
            }
            return this.doThrow(t2);
        }
        return this.doReturnWith(ret);
    }

    public Packet processClientResponsePacket(Packet ret) {
        boolean isTrustMsg = false;
        if ("true".equals(ret.invocationProperties.get("isTrustMessage"))) {
            isTrustMsg = true;
        }
        if (ret == null || ret.getMessage() == null) {
            return ret;
        }
        ProcessingContext ctx = this.initializeInboundProcessingContext(ret);
        ctx.isClient(true);
        ((ProcessingContextImpl)ctx).setIssuedTokenContextMap(this.issuedTokenContextMap);
        ((ProcessingContextImpl)ctx).setSCPolicyIDtoSctIdMap(this.scPolicyIDtoSctIdMap);
        ctx.setExtraneousProperty("OperationResolver", new PolicyResolverImpl(this.inMessagePolicyMap, this.inProtocolPM, this.cachedOperation, this.pipeConfig, this.addVer, true, this.rmVer));
        Message msg = null;
        try {
            msg = ret.getMessage();
            if (msg == null) {
                return ret;
            }
            if (!this.optimized) {
                SOAPMessage soapMessage = msg.readAsSOAPMessage();
                soapMessage = this.verifyInboundMessage(soapMessage, ctx);
                if (msg.isFault()) {
                    SOAPFault fault = soapMessage.getSOAPBody().getFault();
                    throw new SOAPFaultException(fault);
                }
                msg = Messages.create(soapMessage);
            } else {
                msg = this.verifyInboundMessage(msg, ctx);
            }
        }
        catch (XWSSecurityException xwse) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0025_ERROR_VERIFY_INBOUND_MSG(), xwse);
            throw new WebServiceException(LogStringsMessages.WSSTUBE_0025_ERROR_VERIFY_INBOUND_MSG(), this.getSOAPFaultException(xwse));
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0025_ERROR_VERIFY_INBOUND_MSG(), se);
            throw new WebServiceException(LogStringsMessages.WSSTUBE_0025_ERROR_VERIFY_INBOUND_MSG(), se);
        }
        this.resetCachedOperation();
        ret.setMessage(msg);
        if (isTrustMsg) {
            this.getAction(ret);
        }
        return ret;
    }

    @Override
    public NextAction processException(Throwable t) {
        if (!(t instanceof WebServiceException)) {
            t = new WebServiceException(t);
        }
        return this.doThrow(t);
    }

    private void invokeSCPlugin(Packet packet) {
        List<PolicyAssertion> policies = this.getOutBoundSCP(packet.getMessage());
        PolicyAssertion scClientAssertion = null;
        if (this.wsscConfig != null) {
            Iterator it = this.wsscConfig.iterator();
            while (it != null && it.hasNext()) {
                scClientAssertion = (PolicyAssertion)it.next();
            }
        }
        for (PolicyAssertion scAssertion : policies) {
            Token scToken = (Token)((Object)scAssertion);
            if (this.issuedTokenContextMap.get(scToken.getTokenId()) != null) continue;
            try {
                DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(this.wsscVer.getNamespaceURI(), (SecureConversationToken)scToken, this.pipeConfig.getWSDLPort(), this.pipeConfig.getBinding(), this, packet, this.addVer, scClientAssertion, this.next);
                IssuedTokenContext ctx = this.itm.createIssuedTokenContext(config, packet.endpointAddress.toString());
                this.itm.getIssuedToken(ctx);
                this.issuedTokenContextMap.put(scToken.getTokenId(), ctx);
                SCTokenConfiguration sctConfig = (SCTokenConfiguration)ctx.getSecurityPolicy().get(0);
                this.scPolicyIDtoSctIdMap.put(scToken.getTokenId(), sctConfig.getTokenId());
                this.fiberEngine = Fiber.current().owner;
            }
            catch (WSTrustException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
                throw new WebServiceException(LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
            }
        }
    }

    protected List<PolicyAssertion> getIssuedTokenPolicies(Packet packet, String scope) {
        if (this.outMessagePolicyMap == null) {
            return new ArrayList<PolicyAssertion>();
        }
        WSDLBoundOperation operation = null;
        operation = this.isTrustMessage(packet) ? this.getWSDLOpFromAction(packet, false) : this.getOperation(packet.getMessage());
        SecurityPolicyHolder sph = (SecurityPolicyHolder)this.outMessagePolicyMap.get(operation);
        if (sph == null) {
            return EMPTY_LIST;
        }
        return sph.getIssuedTokens();
    }

    @Override
    public JAXBElement startSecureConversation(Packet packet) throws WSSecureConversationException {
        List<PolicyAssertion> toks = this.getOutBoundSCP(packet.getMessage());
        if (toks.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WSSTUBE_0026_NO_POLICY_FOUND_FOR_SC());
            }
            return null;
        }
        Token tok = (Token)((Object)toks.get(0));
        IssuedTokenContext ctx = (IssuedTokenContext)this.issuedTokenContextMap.get(tok.getTokenId());
        PolicyAssertion scClientAssertion = null;
        if (this.wsscConfig != null) {
            Iterator it = this.wsscConfig.iterator();
            while (it != null && it.hasNext()) {
                scClientAssertion = (PolicyAssertion)it.next();
            }
        }
        if (ctx == null) {
            try {
                DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(this.wsscVer.getNamespaceURI(), (SecureConversationToken)tok, this.pipeConfig.getWSDLPort(), this.pipeConfig.getBinding(), this, packet, this.addVer, scClientAssertion, this.next);
                ctx = this.itm.createIssuedTokenContext(config, packet.endpointAddress.toString());
                this.itm.getIssuedToken(ctx);
                this.issuedTokenContextMap.put(tok.getTokenId(), ctx);
                SCTokenConfiguration sctConfig = (SCTokenConfiguration)ctx.getSecurityPolicy().get(0);
                this.scPolicyIDtoSctIdMap.put(tok.getTokenId(), sctConfig.getTokenId());
                this.fiberEngine = Fiber.current().owner;
            }
            catch (WSTrustException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
                throw new WebServiceException(LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
            }
        }
        SecurityTokenReference str = (SecurityTokenReference)ctx.getUnAttachedSecurityTokenReference();
        return WSTrustElementFactory.newInstance().toJAXBElement(str);
    }

    private void cancelSecurityContextToken() {
        Enumeration keys = this.issuedTokenContextMap.keys();
        while (keys.hasMoreElements()) {
            String id = (String)keys.nextElement();
            IssuedTokenContext ctx = (IssuedTokenContext)this.issuedTokenContextMap.get(id);
            if (!(ctx.getSecurityToken() instanceof SecurityContextToken)) continue;
            try {
                this.itm.cancelIssuedToken(ctx);
                this.issuedTokenContextMap.remove(id);
                this.scPolicyIDtoSctIdMap.remove(id);
            }
            catch (WSTrustException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
                throw new WebServiceException(LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
            }
        }
    }

    @Override
    public void preDestroy() {
        this.cancelSecurityContextToken();
        if (this.next != null) {
            this.next.preDestroy();
        }
    }

    private void invokeTrustPlugin(Packet packet, boolean isSCMessage) {
        List<PolicyAssertion> policies = null;
        if (isSCMessage) {
            Token scToken = (Token)packet.invocationProperties.get(Constants.SC_ASSERTION);
            policies = this.getIssuedTokenPoliciesFromBootstrapPolicy(scToken);
        } else {
            policies = this.getIssuedTokenPolicies(packet, Constants.OPERATION_SCOPE);
        }
        PolicyAssertion preSetSTSAssertion = null;
        if (this.trustConfig != null) {
            Iterator it = this.trustConfig.iterator();
            while (it != null && it.hasNext()) {
                preSetSTSAssertion = (PolicyAssertion)it.next();
            }
        }
        for (PolicyAssertion issuedTokenAssertion : policies) {
            if (this.issuedTokenContextMap.get(((Token)((Object)issuedTokenAssertion)).getTokenId()) != null) continue;
            try {
                STSIssuedTokenConfiguration config = null;
                String stsEndpoint = (String)packet.invocationProperties.get("sts-endpoint");
                if (stsEndpoint != null) {
                    String stsMEXAddress = (String)packet.invocationProperties.get("sts-mex-address");
                    if (stsMEXAddress == null) {
                        String stsNamespace = (String)packet.invocationProperties.get("sts-namespace");
                        String stsWSDLLocation = (String)packet.invocationProperties.get("sts-wsdlLocation");
                        String stsServiceName = (String)packet.invocationProperties.get("sts-service-name");
                        String stsPortName = (String)packet.invocationProperties.get("sts-port-name");
                        config = new DefaultSTSIssuedTokenConfiguration(this.wsTrustVer.getNamespaceURI(), stsEndpoint, stsWSDLLocation, stsServiceName, stsPortName, stsNamespace);
                    } else {
                        config = new DefaultSTSIssuedTokenConfiguration(this.wsTrustVer.getNamespaceURI(), stsEndpoint, stsMEXAddress);
                    }
                }
                if (config == null) {
                    config = new DefaultSTSIssuedTokenConfiguration(this.wsTrustVer.getNamespaceURI(), (IssuedToken)((Object)issuedTokenAssertion), preSetSTSAssertion);
                }
                config.getOtherOptions().putAll(packet.invocationProperties);
                IssuedTokenContext ctx = this.itm.createIssuedTokenContext(config, packet.endpointAddress.toString());
                this.itm.getIssuedToken(ctx);
                this.issuedTokenContextMap.put(((Token)((Object)issuedTokenAssertion)).getTokenId(), ctx);
                this.updateMPForIssuedTokenAsEncryptedSupportingToken(packet, ctx, ((Token)((Object)issuedTokenAssertion)).getTokenId());
            }
            catch (WSTrustException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
                throw new WebServiceException(LogStringsMessages.WSSTUBE_0035_ERROR_ISSUEDTOKEN_CREATION(), se);
            }
        }
    }

    @Override
    protected SecurityPolicyHolder addOutgoingMP(WSDLBoundOperation operation, Policy policy) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, false, false);
        this.outMessagePolicyMap.put(operation, sph);
        return sph;
    }

    @Override
    protected SecurityPolicyHolder addIncomingMP(WSDLBoundOperation operation, Policy policy) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, false, true);
        this.inMessagePolicyMap.put(operation, sph);
        return sph;
    }

    @Override
    protected void addIncomingProtocolPolicy(Policy effectivePolicy, String protocol) throws PolicyException {
        this.inProtocolPM.put(protocol, this.constructPolicyHolder(effectivePolicy, false, true, true));
    }

    @Override
    protected void addOutgoingProtocolPolicy(Policy effectivePolicy, String protocol) throws PolicyException {
        this.outProtocolPM.put(protocol, this.constructPolicyHolder(effectivePolicy, false, false, false));
    }

    @Override
    protected void addIncomingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, false, true);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected void addOutgoingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, false, false);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected String getAction(WSDLOperation operation, boolean inComming) {
        if (!inComming) {
            return operation.getInput().getAction();
        }
        return operation.getOutput().getAction();
    }

    protected void populateKerberosContext(Packet packet, ProcessingContextImpl ctx, boolean isSCMessage) throws XWSSecurityException {
        List<PolicyAssertion> toks = this.getOutBoundKTP(packet, isSCMessage);
        if (toks.isEmpty()) {
            return;
        }
        Token tok = (Token)((Object)toks.get(0));
        String tokId = tok.getTokenId();
        KerberosContext krbContext = ctx.getSecurityEnvironment().doKerberosLogin();
        try {
            byte[] krbSha1 = MessageDigest.getInstance("SHA-1").digest(krbContext.getKerberosToken());
            String encKrbSha1 = Base64.encode(krbSha1);
            ctx.setExtraneousProperty("KerbSHA1Value", encKrbSha1);
            ctx.setKerberosContext(krbContext);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XWSSecurityException(nsae);
        }
    }

    private void updateMPForIssuedTokenAsEncryptedSupportingToken(Packet packet, IssuedTokenContext ctx, String issuedTokenPolicyId) {
        Message message = packet.getMessage();
        WSDLBoundOperation operation = message.getOperation(this.pipeConfig.getWSDLPort());
        SecurityPolicyHolder sph = (SecurityPolicyHolder)this.outMessagePolicyMap.get(operation);
        if (sph != null && sph.isIssuedTokenAsEncryptedSupportingToken()) {
            MessagePolicy policy = sph.getMessagePolicy();
            ArrayList list = policy.getPrimaryPolicies();
            Iterator i = list.iterator();
            boolean breakOuterLoop = false;
            while (i.hasNext()) {
                SecurityPolicy primaryPolicy = (SecurityPolicy)i.next();
                if (!PolicyTypeUtil.encryptionPolicy(primaryPolicy)) continue;
                EncryptionPolicy encPolicy = (EncryptionPolicy)primaryPolicy;
                EncryptionPolicy.FeatureBinding featureBinding = (EncryptionPolicy.FeatureBinding)encPolicy.getFeatureBinding();
                ArrayList targetList = featureBinding.getTargetBindings();
                ListIterator iterator = targetList.listIterator();
                while (iterator.hasNext()) {
                    EncryptionTarget encryptionTarget = (EncryptionTarget)iterator.next();
                    String targetURI = encryptionTarget.getValue();
                    if (!targetURI.equals(issuedTokenPolicyId) || ctx == null) continue;
                    GenericToken issuedToken = (GenericToken)ctx.getSecurityToken();
                    encryptionTarget.setValue(issuedToken.getId());
                    sph.setMessagePolicy(policy);
                    this.outMessagePolicyMap.put(operation, sph);
                    breakOuterLoop = true;
                    break;
                }
                if (!breakOuterLoop) continue;
                break;
            }
        }
    }

    private CallbackHandler configureClientHandler(Set configAssertions, Properties props) {
        String ret = this.populateConfigProperties(configAssertions, props);
        try {
            if (ret != null) {
                Class handler = this.loadClass(ret);
                Object obj = handler.newInstance();
                if (!(obj instanceof CallbackHandler)) {
                    log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0033_INVALID_CALLBACK_HANDLER_CLASS(ret));
                    throw new RuntimeException(LogStringsMessages.WSSTUBE_0033_INVALID_CALLBACK_HANDLER_CLASS(ret));
                }
                return (CallbackHandler)obj;
            }
            return new DefaultCallbackHandler("client", props);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSTUBE_0027_ERROR_CONFIGURE_CLIENT_HANDLER(), e);
            throw new RuntimeException(LogStringsMessages.WSSTUBE_0027_ERROR_CONFIGURE_CLIENT_HANDLER(), e);
        }
    }
}

