/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.verifier;

import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.WSSAssertion;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.spi.PolicyVerifier;

public class EncryptionPolicyVerifier
implements PolicyVerifier {
    FilterProcessingContext context;

    public EncryptionPolicyVerifier(FilterProcessingContext context) {
        this.context = context;
    }

    public void verifyPolicy(SecurityPolicy configPolicy, SecurityPolicy recvdPolicy) throws PolicyViolationException {
        if (PolicyTypeUtil.encryptionPolicy(configPolicy) && PolicyTypeUtil.encryptionPolicy(recvdPolicy)) {
            EncryptionPolicy rEP = (EncryptionPolicy)recvdPolicy;
            EncryptionPolicy cEP = (EncryptionPolicy)configPolicy;
            EncryptionPolicy.FeatureBinding rfBinding = (EncryptionPolicy.FeatureBinding)rEP.getFeatureBinding();
            EncryptionPolicy.FeatureBinding cfBinding = (EncryptionPolicy.FeatureBinding)cEP.getFeatureBinding();
            String rDA = rfBinding.getDataEncryptionAlgorithm();
            String cDA = cfBinding.getDataEncryptionAlgorithm();
            if (cDA != null && cDA.length() > 0 && !cDA.equals(rDA)) {
                throw new PolicyViolationException("Receiver side requirement verification failed, DataEncryptionAlgorithm specified in the receiver requirements did match with DataEncryptionAlgorithm used to encrypt the message.Configured DataEncryptionAlgorithm is " + cDA + "  DataEncryptionAlgorithm used in the" + "message is " + rDA);
            }
        }
    }

    private void checkSAMLAssertionBinding(AuthenticationTokenPolicy.SAMLAssertionBinding configPolicy, AuthenticationTokenPolicy.SAMLAssertionBinding recvdPolicy) throws PolicyViolationException {
        boolean matched = true;
        String _cAI = configPolicy.getAuthorityIdentifier();
        String _rAI = recvdPolicy.getAuthorityIdentifier();
        if (_cAI != null && _cAI.length() > 0 && _rAI != null) {
            matched = _cAI.equals(_rAI);
            this._throwError(configPolicy, recvdPolicy, matched);
        }
    }

    private void checkX509CertificateBinding(AuthenticationTokenPolicy.X509CertificateBinding configPolicy, AuthenticationTokenPolicy.X509CertificateBinding recvdPolicy) throws PolicyViolationException {
        boolean matched = true;
        configPolicy = this.setReferenceType(configPolicy);
        String ckeyAlg = configPolicy.getKeyAlgorithm();
        String rkeyAlg = recvdPolicy.getKeyAlgorithm();
        if (ckeyAlg != null && ckeyAlg.length() > 0 && rkeyAlg.length() > 0) {
            matched = ckeyAlg.equals(rkeyAlg);
        }
        this._throwError(configPolicy, recvdPolicy, matched);
        String cVT = configPolicy.getValueType();
        String rVT = recvdPolicy.getValueType();
        if (cVT != null && cVT.length() > 0) {
            matched = cVT.equals(rVT);
        }
        this._throwError(configPolicy, recvdPolicy, matched);
    }

    private final void _throwError(SecurityPolicy configPolicy, SecurityPolicy recvdPolicy, boolean matched) throws PolicyViolationException {
        if (!matched) {
            throw new PolicyViolationException("KeyType used to Encrypt the message doesnot match with  the receiver side requirements. Configured KeyType is " + configPolicy + " KeyType inferred from the message is  " + recvdPolicy);
        }
    }

    private AuthenticationTokenPolicy.X509CertificateBinding setReferenceType(AuthenticationTokenPolicy.X509CertificateBinding configPolicy) {
        if (configPolicy.policyTokenWasSet()) {
            if (AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_NEVER.equals(configPolicy.getIncludeToken())) {
                WSSAssertion wssAssertion = this.context.getWSSAssertion();
                if ("Direct".equals(configPolicy.getReferenceType())) {
                    if (wssAssertion != null) {
                        if (wssAssertion.getRequiredProperties().contains("MustSupportRefKeyIdentifier")) {
                            configPolicy.setReferenceType("Identifier");
                        } else if (wssAssertion.getRequiredProperties().contains("MustSupportRefThumbprint")) {
                            configPolicy.setReferenceType("Thumbprint");
                        }
                    } else {
                        configPolicy.setReferenceType("Identifier");
                    }
                }
            }
        }
        return configPolicy;
    }
}

