/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.AssertionUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ImportSamlAssertionFilter {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static void process(FilterProcessingContext context) throws XWSSecurityException {
        SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
        SecurityHeader wsseSecurity = secureMessage.findSecurityHeader();
        Assertion samlAssertion = null;
        SOAPElement samlElement = null;
        if (context.getMode() == 0 || context.getMode() == 2 || context.getMode() == 3) {
            AuthenticationTokenPolicy policy;
            AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy;
            NodeList nl = null;
            Element elem = null;
            Iterator iter = wsseSecurity.getChildElements();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof Text || !(obj instanceof Element)) continue;
                elem = (Element)obj;
                if (elem.getAttributeNode("ID") != null) {
                    nl = wsseSecurity.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
                    break;
                }
                if (elem.getAttributeNode("AssertionID") == null) continue;
                nl = wsseSecurity.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
                break;
            }
            if (nl == null) {
                throw new XWSSecurityException("SAMLAssertion is null");
            }
            int nodeListLength = nl.getLength();
            int countSamlInsideAdviceElement = 0;
            for (int i = 0; i < nodeListLength; ++i) {
                if (!nl.item(i).getParentNode().getLocalName().equals("Advice")) continue;
                ++countSamlInsideAdviceElement;
            }
            if (nodeListLength == 0) {
                throw new XWSSecurityException("No SAML Assertion found, Reciever requirement not met");
            }
            samlElement = (SOAPElement)nl.item(0);
            try {
                samlAssertion = AssertionUtil.fromElement(samlElement);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0418.saml.import.exception");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Exception while importing SAML Token", e);
            }
            if (context.getMode() == 0 && !"".equals((samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)(policy = (AuthenticationTokenPolicy)context.getSecurityPolicy()).getFeatureBinding()).getAuthorityIdentifier()) && !samlPolicy.getAuthorityIdentifier().equals(samlAssertion.getSamlIssuer())) {
                XWSSecurityException xwse = new XWSSecurityException("Invalid Assertion Issuer, expected " + samlPolicy.getAuthorityIdentifier() + ", found " + samlAssertion.getSamlIssuer());
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Received SAML Assertion has invalid Issuer", xwse);
            }
        } else {
            if (context.getMode() == 1) {
                throw new XWSSecurityException("Internal Error: Called ImportSAMLAssertionFilter in POSTHOC Mode");
            }
            if (context.getMode() == 3) {
                AuthenticationTokenPolicy.SAMLAssertionBinding bind = new AuthenticationTokenPolicy.SAMLAssertionBinding();
                context.getInferredSecurityPolicy().append(bind);
            }
            try {
                samlAssertion = AssertionUtil.fromElement(wsseSecurity.getCurrentHeaderElement());
            }
            catch (Exception ex) {
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Exception while importing SAML Assertion", ex);
            }
        }
        HashMap tokenCache = context.getTokenCache();
        tokenCache.put(samlAssertion.getAssertionID(), samlAssertion);
        context.getSecurityEnvironment().validateSAMLAssertion(context.getExtraneousProperties(), samlElement);
        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), samlAssertion);
        AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = new AuthenticationTokenPolicy.SAMLAssertionBinding();
        samlPolicy.setUUID(samlAssertion.getAssertionID());
        context.getInferredSecurityPolicy().append(samlPolicy);
    }
}

