/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.service;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.assembler.WsitServerTubeAssemblyContext;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.tx.at.ATCoordinator;
import com.sun.xml.ws.tx.at.ATSubCoordinator;
import com.sun.xml.ws.tx.common.ATAssertion;
import com.sun.xml.ws.tx.common.Message;
import com.sun.xml.ws.tx.common.TxBasePipe;
import com.sun.xml.ws.tx.common.TxFault;
import com.sun.xml.ws.tx.common.TxJAXBContext;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.common.WsaHelper;
import com.sun.xml.ws.tx.coordinator.CoordinationContextInterface;
import com.sun.xml.ws.tx.coordinator.CoordinationManager;
import com.sun.xml.ws.tx.service.LocalizationMessages;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class TxServerPipe
extends TxBasePipe {
    private static TxLogger logger = TxLogger.getLogger(TxServerPipe.class);
    private final Unmarshaller unmarshaller;
    private final WSDLPort port;
    private final WSBinding wsbinding;
    private Map<QName, TxBasePipe.OperationATPolicy> opPolicyCache = new HashMap<QName, TxBasePipe.OperationATPolicy>();
    private static TxBasePipe.OperationATPolicy DEFAULT = new TxBasePipe.OperationATPolicy();

    public TxServerPipe(WsitServerTubeAssemblyContext context, Pipe next) {
        super(next);
        this.unmarshaller = TxJAXBContext.createUnmarshaller();
        this.port = context.getWsdlPort();
        this.wsbinding = context.getEndpoint().getBinding();
        this.cacheOperationToPolicyMappings(context.getPolicyMap(), context.getWsdlPort().getBinding());
    }

    private TxServerPipe(TxServerPipe from, PipeCloner cloner) {
        super(cloner.copy(from.next));
        cloner.add(from, this);
        this.port = from.port;
        this.wsbinding = from.wsbinding;
        this.unmarshaller = TxJAXBContext.createUnmarshaller();
        this.opPolicyCache = from.opPolicyCache;
    }

    public Pipe copy(PipeCloner cloner) {
        return new TxServerPipe(this, cloner);
    }

    public Packet process(Packet pkt) {
        CoordinationContextInterface coordTxnCtx;
        String bindingName;
        TxBasePipe.OperationATPolicy msgOpATPolicy;
        QName msgOperation;
        WSDLBoundOperation msgOp;
        Message msg;
        block30: {
            String METHOD_NAME = "TxServerPipe.process";
            if (logger.isLogging(Level.FINER)) {
                Object[] params = new Object[]{pkt};
                logger.entering("TxServerPipe.process", params);
            }
            msg = new Message(pkt.getMessage(), this.wsbinding);
            msgOp = msg.getOperation(this.port);
            msgOperation = msgOp.getName();
            msgOpATPolicy = this.getATPolicy(msgOperation);
            bindingName = this.port.getBinding().getName().toString();
            coordTxnCtx = null;
            this.assertNoCurrentTransaction(LocalizationMessages.INVALID_JTA_TRANSACTION_ENTERING_5002(bindingName, msgOperation.getLocalPart()));
            try {
                coordTxnCtx = msg.getCoordinationContext(this.unmarshaller);
            }
            catch (JAXBException je) {
                String invalidMsg = LocalizationMessages.INVALID_COORDINATION_CONTEXT_5006(msg.getMessageID(), bindingName, msgOperation.getLocalPart(), je.getLocalizedMessage());
                logger.warning("TxServerPipe.process", invalidMsg, je);
                String englishReason = "WSTX-SERVICE-5006: Unable to read CoordinationContext in request message, msgId=" + msg.getMessageID() + ", sent to endpoint:operation " + bindingName + ":" + msgOperation.getLocalPart() + " due to JAXException " + je.getMessage();
                WSEndpointReference replyTo = msg.getReplyTo();
                if (replyTo == null) break block30;
                WsaHelper.sendFault(msg.getFaultTo(), replyTo.toSpec(), SOAPVersion.SOAP_11, TxFault.InvalidParameters, englishReason, msg.getMessageID());
            }
        }
        if (coordTxnCtx != null) {
            if (coordTxnCtx.getCoordinationType().equals("http://schemas.xmlsoap.org/ws/2004/10/wsat")) {
                if (logger.isLogging(Level.FINEST)) {
                    logger.finest("TxServerPipe.process", "Processing wscoor:CoordinationContext(protocol=" + coordTxnCtx.getCoordinationType() + "coordId=" + coordTxnCtx.getIdentifier() + ") for binding:" + bindingName + "operation:" + msgOp.getName());
                }
                msg.setCoordCtxUnderstood();
            } else {
                logger.info("TxServerPipe.process", LocalizationMessages.IGNORING_UNRECOGNIZED_PROTOCOL_5005(coordTxnCtx.getCoordinationType(), coordTxnCtx.getIdentifier(), bindingName, msgOperation.getLocalPart()));
                coordTxnCtx = null;
            }
        }
        if (msgOpATPolicy.atAssertion == ATAssertion.MANDATORY && coordTxnCtx == null) {
            String inconsistencyMsg = LocalizationMessages.MUST_FLOW_WSAT_COORDINATION_CONTEXT_5000(bindingName, msgOperation.getLocalPart(), msg.getMessageID());
            logger.warning("TxServerPipe.process", inconsistencyMsg);
            throw new WebServiceException(inconsistencyMsg);
        }
        if (coordTxnCtx != null && msgOpATPolicy.atAssertion == ATAssertion.NOT_ALLOWED) {
            logger.info("TxServerPipe.process", LocalizationMessages.UNEXPECTED_FLOWED_TXN_CONTEXT_5004(bindingName, msgOperation.getLocalPart(), msg.getMessageID(), coordTxnCtx.getIdentifier()));
        }
        boolean importedTxn = false;
        Packet responsePkt = null;
        Transaction jtaTxn = null;
        Exception rethrow = null;
        ATCoordinator coord = null;
        if (coordTxnCtx != null) {
            coord = (ATCoordinator)CoordinationManager.getInstance().lookupOrCreateCoordinator(coordTxnCtx);
            assert (coord != null);
            jtaTxn = coord.getTransaction();
            if (jtaTxn != null) {
                if (logger.isLogging(Level.FINER)) {
                    logger.finer("TxServerPipe.process", "Resume JTA Txn already associated with coordId=" + coordTxnCtx.getIdentifier());
                }
                coord.resumeTransaction();
                try {
                    responsePkt = this.next.process(pkt);
                }
                catch (Exception e) {
                    logger.warning("TxServerPipe.process", LocalizationMessages.HANDLE_EXCEPTION_TO_COMPLETE_TRANSACTION_5012(coordTxnCtx.getIdentifier(), jtaTxn.toString()), e);
                    rethrow = e;
                    this.txnMgr.setRollbackOnly();
                }
                coord.suspendTransaction();
            } else if (coord.isSubordinateCoordinator()) {
                if (logger.isLogging(Level.FINER)) {
                    logger.finer("TxServerPipe.process", "importing ws-at activity id:" + coordTxnCtx.getIdentifier() + " from external WS-AT coordinator");
                }
                importedTxn = true;
                ((ATSubCoordinator)coord).beginImportTransaction();
                try {
                    responsePkt = this.next.process(pkt);
                }
                catch (Exception e) {
                    jtaTxn = coord.getTransaction();
                    String jtaTxnString = jtaTxn == null ? "" : jtaTxn.toString();
                    logger.warning("TxServerPipe.process", LocalizationMessages.HANDLE_EXCEPTION_TO_RELEASE_IMPORTED_TXN_5013(coordTxnCtx.getIdentifier(), jtaTxnString), e);
                    rethrow = e;
                    this.txnMgr.setRollbackOnly();
                }
                ((ATSubCoordinator)coord).endImportTransaction();
            } else {
                responsePkt = this.next.process(pkt);
            }
        } else if (msgOpATPolicy.ATAlwaysCapability) {
            if (this.isServlet(pkt)) {
                this.beginTransaction();
                if (logger.isLogging(Level.FINER)) {
                    logger.finer("TxServerPipe.process", "create JTA Transaction, no CoordinationContext flowed with operation and wsat:ATAlwaysCapability is enabled");
                }
            }
            try {
                responsePkt = this.next.process(pkt);
            }
            catch (Exception e) {
                rethrow = e;
                logger.warning("TxServerPipe.process", LocalizationMessages.HANDLE_EXCEPTION_TO_COMMIT_CREATED_TXN_5015(), e);
                this.txnMgr.setRollbackOnly();
            }
            if (this.isServlet(pkt)) {
                this.commitTransaction();
            }
        } else {
            responsePkt = this.next.process(pkt);
        }
        this.assertNoCurrentTransaction(LocalizationMessages.INVALID_JTA_TRANSACTION_RETURNING_5003(bindingName, msgOperation.getLocalPart()));
        if (rethrow != null) {
            String exMsg = LocalizationMessages.WSTXRETHROW_5014(bindingName, msgOperation.toString());
            throw new WebServiceException(exMsg, rethrow);
        }
        logger.exiting("TxServerPipe.process", responsePkt);
        return responsePkt;
    }

    private boolean isServlet(Packet pkt) {
        ServletContext sCtx = pkt.endpoint.getContainer().getSPI(ServletContext.class);
        return sCtx != null;
    }

    private TxBasePipe.OperationATPolicy getDefaultATPolicy() {
        return DEFAULT;
    }

    private TxBasePipe.OperationATPolicy getATPolicy(QName operationName) {
        TxBasePipe.OperationATPolicy result = this.opPolicyCache.get(operationName);
        if (result == null) {
            result = this.getDefaultATPolicy();
        }
        return result;
    }

    private void cacheOperationToPolicyMappings(PolicyMap pmap, WSDLBoundPortType binding) {
        for (WSDLBoundOperation wSDLBoundOperation : binding.getBindingOperations()) {
            TxBasePipe.OperationATPolicy opat = DEFAULT;
            try {
                opat = this.getOperationATPolicy(pmap, this.port, wSDLBoundOperation);
                this.opPolicyCache.put(wSDLBoundOperation.getName(), opat);
            }
            catch (WebServiceException wse) {
                logger.warning("cacheOperationToPolicyMappings", LocalizationMessages.WSAT_POLICY_PROCESSING_FAILURE_5017(binding.getName(), wSDLBoundOperation.getName()), wse);
            }
            if (!logger.isLogging(Level.FINE)) continue;
            logger.fine("cacheOperationToPolicyMappings", "Operation: " + binding.getName() + ":" + wSDLBoundOperation.getName() + " WS-AT Policy Assertions: ATAssertion:" + (Object)((Object)opat.atAssertion) + " ATAlwaysCapability:" + opat.ATAlwaysCapability);
        }
    }

    private void beginTransaction() {
        try {
            this.txnMgr.getUserTransaction().begin();
        }
        catch (NotSupportedException ex) {
            String handlerMsg = LocalizationMessages.TXN_MGR_OPERATION_FAILED_5011("getUserTransaction().begin()");
            logger.warning("beginTransaction", handlerMsg, ex);
            throw new WebServiceException(handlerMsg, ex);
        }
        catch (SystemException ex) {
            String handlerMsg = LocalizationMessages.TXN_MGR_OPERATION_FAILED_5011("getUserTransaction().begin()");
            logger.warning("beginTransaction", handlerMsg, ex);
            throw new WebServiceException(handlerMsg, ex);
        }
    }

    private void commitTransaction() {
        try {
            this.txnMgr.getUserTransaction().commit();
        }
        catch (Exception ex) {
            String commitExceptionMsg = LocalizationMessages.EXCEPTION_DURING_COMMIT_5008();
            logger.warning("commitTransaction", commitExceptionMsg, ex);
            throw new WebServiceException(commitExceptionMsg, ex);
        }
    }

    private void assertNoCurrentTransaction(String message) {
        Transaction txn = null;
        try {
            txn = this.txnMgr.getTransaction();
        }
        catch (SystemException ex) {
            String handlerMsg = LocalizationMessages.TXN_MGR_OPERATION_FAILED_5011("getTransaction");
            logger.warning("assertNoCurrentTransaction", handlerMsg);
            throw new WebServiceException(handlerMsg, ex);
        }
        if (txn != null) {
            logger.severe("TxServerPipe.process", message + " " + txn.toString());
            try {
                this.txnMgr.suspend();
            }
            catch (SystemException ex) {
                String handlerMsg = LocalizationMessages.TXN_MGR_OPERATION_FAILED_5011("suspend");
                logger.warning("assertNoCurrentTransaction", handlerMsg);
                throw new WebServiceException(handlerMsg, ex);
            }
        }
    }
}

