/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.common;

import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.tx.common.ATAssertion;
import com.sun.xml.ws.tx.common.Constants;
import com.sun.xml.ws.tx.common.TransactionManagerImpl;
import javax.xml.ws.WebServiceException;

public abstract class TxBasePipe
implements Pipe {
    protected final TransactionManagerImpl txnMgr;
    protected final Pipe next;

    public TxBasePipe(Pipe next) {
        this.next = next;
        this.txnMgr = TransactionManagerImpl.getInstance();
    }

    public void preDestroy() {
        this.next.preDestroy();
    }

    protected OperationATPolicy getOperationATPolicy(PolicyMap pmap, WSDLPort wsdlModel, WSDLBoundOperation wsdlBoundOp) throws WebServiceException {
        OperationATPolicy opat = new OperationATPolicy();
        try {
            if (pmap != null) {
                PolicyMapKey opKey = PolicyMap.createWsdlOperationScopeKey(wsdlModel.getOwner().getName(), wsdlModel.getName(), wsdlBoundOp.getName());
                Policy effectivePolicy = pmap.getOperationEffectivePolicy(opKey);
                if (effectivePolicy != null) {
                    for (AssertionSet assertionSet : effectivePolicy) {
                        for (PolicyAssertion pa : assertionSet) {
                            if (pa.getName().equals(Constants.AT_ASSERTION)) {
                                String optionalBoolValue;
                                ATAssertion aTAssertion = opat.atAssertion = pa.isOptional() ? ATAssertion.ALLOWED : ATAssertion.MANDATORY;
                                if (opat.atAssertion != ATAssertion.MANDATORY || (optionalBoolValue = pa.getAttributeValue(Constants.WSP2002_OPTIONAL)) == null || !Boolean.valueOf(optionalBoolValue).booleanValue()) continue;
                                opat.atAssertion = ATAssertion.ALLOWED;
                                continue;
                            }
                            if (!pa.getName().equals(Constants.AT_ALWAYS_CAPABILITY)) continue;
                            opat.ATAlwaysCapability = true;
                        }
                    }
                }
            }
        }
        catch (PolicyException pe) {
            throw new WebServiceException(pe.getMessage(), pe);
        }
        return opat;
    }

    public static class OperationATPolicy {
        public ATAssertion atAssertion = ATAssertion.NOT_ALLOWED;
        public boolean ATAlwaysCapability = false;
    }
}

