/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.client;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.resources.ClientMessages;
import com.sun.xml.ws.transport.Headers;
import com.sun.xml.ws.transport.http.client.HttpClientTransport;
import com.sun.xml.ws.transport.http.client.HttpResponseProperties;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.util.RuntimeVersion;
import com.sun.xml.ws.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTransportPipe
extends AbstractTubeImpl {
    private final Codec codec;
    private final WSBinding binding;
    private static final List<String> USER_AGENT;
    public static boolean dump;

    public HttpTransportPipe(Codec codec, WSBinding binding) {
        this.codec = codec;
        this.binding = binding;
    }

    private HttpTransportPipe(HttpTransportPipe that, TubeCloner cloner) {
        this(that.codec.copy(), that.binding);
        cloner.add(that, this);
    }

    @Override
    public NextAction processException(@NotNull Throwable t) {
        throw new IllegalStateException("HttpTransportPipe's processException shouldn't be called.");
    }

    @Override
    public NextAction processRequest(@NotNull Packet request) {
        return this.doReturnWith(this.process(request));
    }

    @Override
    public NextAction processResponse(@NotNull Packet response) {
        throw new IllegalStateException("HttpTransportPipe's processResponse shouldn't be called.");
    }

    @Override
    public Packet process(Packet request) {
        try {
            Headers reqHeaders = new Headers();
            Map userHeaders = (Map)request.invocationProperties.get("javax.xml.ws.http.request.headers");
            boolean addUserAgent = true;
            if (userHeaders != null) {
                reqHeaders.putAll(userHeaders);
                if (userHeaders.get("User-Agent") != null) {
                    addUserAgent = false;
                }
            }
            if (addUserAgent) {
                reqHeaders.put("User-Agent", USER_AGENT);
            }
            HttpClientTransport con = new HttpClientTransport(request, reqHeaders);
            request.addSatellite(new HttpResponseProperties(con));
            ContentType ct = this.codec.getStaticContentType(request);
            if (ct == null) {
                ByteArrayBuffer buf = new ByteArrayBuffer();
                ct = this.codec.encode(request, buf);
                reqHeaders.put("Content-Length", Collections.singletonList(Integer.toString(buf.size())));
                reqHeaders.put("Content-Type", Collections.singletonList(ct.getContentType()));
                if (ct.getAcceptHeader() != null) {
                    reqHeaders.put("Accept", Collections.singletonList(ct.getAcceptHeader()));
                }
                if (this.binding instanceof SOAPBinding) {
                    this.writeSOAPAction(reqHeaders, ct.getSOAPActionHeader(), request);
                }
                if (dump) {
                    this.dump(buf, "HTTP request", reqHeaders);
                }
                buf.writeTo(con.getOutput());
            } else {
                reqHeaders.put("Content-Type", Collections.singletonList(ct.getContentType()));
                if (ct.getAcceptHeader() != null) {
                    reqHeaders.put("Accept", Collections.singletonList(ct.getAcceptHeader()));
                }
                if (this.binding instanceof SOAPBinding) {
                    this.writeSOAPAction(reqHeaders, ct.getSOAPActionHeader(), request);
                }
                if (dump) {
                    ByteArrayBuffer buf = new ByteArrayBuffer();
                    this.codec.encode(request, buf);
                    this.dump(buf, "HTTP request - " + request.endpointAddress, reqHeaders);
                    OutputStream out = con.getOutput();
                    if (out != null) {
                        buf.writeTo(out);
                    }
                } else {
                    OutputStream os = con.getOutput();
                    if (os != null) {
                        this.codec.encode(request, os);
                    }
                }
            }
            con.closeOutput();
            return this.createResponsePacket(request, con);
        }
        catch (WebServiceException wex) {
            throw wex;
        }
        catch (Exception ex) {
            throw new WebServiceException(ex);
        }
    }

    private Packet createResponsePacket(Packet request, HttpClientTransport con) throws IOException {
        con.readResponseCodeAndMessage();
        InputStream responseStream = con.getInput();
        if (dump) {
            ByteArrayBuffer buf = new ByteArrayBuffer();
            if (responseStream != null) {
                buf.write(responseStream);
                responseStream.close();
            }
            this.dump(buf, "HTTP response - " + request.endpointAddress + " - " + con.statusCode, con.getHeaders());
            responseStream = buf.newInputStream();
        }
        int cl = con.contentLength;
        InputStream tempIn = null;
        if (cl == -1 && (tempIn = StreamUtils.hasSomeData(responseStream)) != null) {
            responseStream = tempIn;
        }
        if ((cl == 0 || cl == -1 && tempIn == null) && responseStream != null) {
            responseStream.close();
            responseStream = null;
        }
        this.checkStatusCode(responseStream, con);
        Packet reply = request.createClientResponse(null);
        reply.wasTransportSecure = con.isSecure();
        if (responseStream != null) {
            String contentType = con.getContentType();
            if (contentType != null && contentType.contains("text/html") && this.binding instanceof SOAPBinding) {
                throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(con.statusCode, con.statusMessage));
            }
            this.codec.decode(responseStream, contentType, reply);
        }
        return reply;
    }

    private void checkStatusCode(InputStream in, HttpClientTransport con) throws IOException {
        int statusCode = con.statusCode;
        String statusMessage = con.statusMessage;
        if (this.binding instanceof SOAPBinding) {
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                if (statusCode == 200 || statusCode == 202 || this.isErrorCode(statusCode)) {
                    if (this.isErrorCode(statusCode) && in == null) {
                        throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(statusCode, statusMessage));
                    }
                    return;
                }
            } else if (statusCode == 200 || statusCode == 202 || statusCode == 500) {
                if (statusCode == 500 && in == null) {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(statusCode, statusMessage));
                }
                return;
            }
            if (in != null) {
                in.close();
            }
            throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(statusCode, statusMessage));
        }
    }

    private boolean isErrorCode(int code) {
        return code == 500 || code == 400;
    }

    private void writeSOAPAction(Map<String, List<String>> reqHeaders, String soapAction, Packet packet) {
        if (SOAPVersion.SOAP_12.equals((Object)this.binding.getSOAPVersion())) {
            return;
        }
        if (soapAction != null) {
            reqHeaders.put("SOAPAction", Collections.singletonList(soapAction));
        } else {
            reqHeaders.put("SOAPAction", Collections.singletonList("\"\""));
        }
    }

    @Override
    public void preDestroy() {
    }

    @Override
    public HttpTransportPipe copy(TubeCloner cloner) {
        return new HttpTransportPipe(this, cloner);
    }

    private void dump(ByteArrayBuffer buf, String caption, Map<String, List<String>> headers) throws IOException {
        System.out.println("---[" + caption + "]---");
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            if (header.getValue().isEmpty()) {
                System.out.println(header.getValue());
                continue;
            }
            for (String value : header.getValue()) {
                System.out.println(header.getKey() + ": " + value);
            }
        }
        buf.writeTo(System.out);
        System.out.println("--------------------");
    }

    static {
        boolean b;
        USER_AGENT = Collections.singletonList(RuntimeVersion.VERSION.toString());
        try {
            b = Boolean.getBoolean(HttpTransportPipe.class.getName() + ".dump");
        }
        catch (Throwable t) {
            b = false;
        }
        dump = b;
    }
}

