/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.mex.server;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.mex.MessagesMessages;
import com.sun.xml.ws.mex.server.MEXAddressResolver;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;

public class WSDLRetriever {
    private final WSEndpoint endpoint;
    private static final Logger logger = Logger.getLogger(WSDLRetriever.class.getName());
    private static final DocumentAddressResolver dar = new DocumentAddressResolver(){

        public String getRelativeAddressFor(SDDocument doc1, SDDocument doc2) {
            return null;
        }
    };

    public WSDLRetriever(WSEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    void addDocuments(XMLStreamWriter writer, Packet request, String address) throws XMLStreamException {
        ServiceDefinition sDef = this.endpoint.getServiceDefinition();
        if (sDef == null) {
            return;
        }
        Iterator docs = sDef.iterator();
        while (docs.hasNext()) {
            this.writeDoc(writer, (SDDocument)docs.next(), address);
        }
    }

    private void writeDoc(XMLStreamWriter writer, SDDocument doc, String address) throws XMLStreamException {
        try {
            writer.writeStartElement("mex", "MetadataSection", "http://schemas.xmlsoap.org/ws/2004/09/mex");
            if (doc.isWSDL()) {
                writer.writeAttribute("Dialect", "http://schemas.xmlsoap.org/wsdl/");
                writer.writeAttribute("Identifier", ((SDDocument.WSDL)doc).getTargetNamespace());
            } else if (doc.isSchema()) {
                writer.writeAttribute("Dialect", "http://www.w3.org/2001/XMLSchema");
                writer.writeAttribute("Identifier", ((SDDocument.Schema)doc).getTargetNamespace());
            }
            doc.writeTo((PortAddressResolver)new MEXAddressResolver(this.endpoint.getServiceName(), this.endpoint.getPortName(), address), dar, writer);
            writer.writeEndElement();
        }
        catch (IOException ioe) {
            String exceptionMessage = MessagesMessages.MEX_0015_IOEXCEPTION_WHILE_WRITING_RESPONSE(address);
            logger.log(Level.SEVERE, exceptionMessage, ioe);
            throw new WebServiceException(exceptionMessage, ioe);
        }
    }
}

