/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import com.sun.enterprise.transaction.TransactionImport;
import com.sun.xml.ws.api.tx.Participant;
import com.sun.xml.ws.api.tx.Protocol;
import com.sun.xml.ws.api.tx.TXException;
import com.sun.xml.ws.tx.at.ATCoordinator;
import com.sun.xml.ws.tx.at.ATParticipant;
import com.sun.xml.ws.tx.at.CoordinationXid;
import com.sun.xml.ws.tx.at.LocalizationMessages;
import com.sun.xml.ws.tx.common.TransactionImportManager;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.coordinator.CoordinationContextInterface;
import com.sun.xml.ws.tx.coordinator.Coordinator;
import com.sun.xml.ws.tx.coordinator.Registrant;
import com.sun.xml.ws.tx.webservice.member.coord.CreateCoordinationContextType;
import java.util.logging.Level;
import javax.resource.spi.XATerminator;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;

public class ATSubCoordinator
extends ATCoordinator {
    private static TxLogger logger = TxLogger.getATLogger(ATCoordinator.class);
    final TransactionImport importTm = TransactionImportManager.getInstance();
    private ATParticipant rootVolatileParticipant = null;
    private ATParticipant rootDurableParticipant = null;
    private boolean guardTimeout = false;
    private boolean forgotten = false;
    private Xid xid = null;
    private XATerminator xaTerminator = null;

    public ATSubCoordinator(CoordinationContextInterface context, CreateCoordinationContextType request) {
        super(context, request);
        assert (this.getContext().getRootRegistrationService() != null);
    }

    public ATSubCoordinator(CoordinationContextInterface context) {
        super(context);
        assert (this.getContext().getRootRegistrationService() != null);
    }

    public void setTransaction(Transaction txn) {
        super.setTransaction(txn);
        if (txn == null) {
            this.xaTerminator = null;
        } else if (this.xaTerminator == null) {
            this.xaTerminator = this.importTm.getXATerminator();
        }
    }

    protected void registerWithVolatileParent() {
        if (this.rootVolatileParticipant == null) {
            if (logger.isLogging(Level.FINE)) {
                logger.fine("ATSubCoordinator.registerWithVolatileParent", "register volatile2PC with coordId:" + this.getIdValue());
            }
            this.rootVolatileParticipant = new ATParticipant((Coordinator)this, new VolatileParticipant());
            this.rootVolatileParticipant.register();
        }
    }

    protected boolean registerWithDurableParent() {
        boolean result = false;
        if (this.rootDurableParticipant == null) {
            if (logger.isLogging(Level.FINE)) {
                logger.fine("ATSubCoordinator.registerWithDurableParent", "register durable2PC with coordId:" + this.getIdValue());
            }
            this.rootDurableParticipant = new ATParticipant((Coordinator)this, new DurableParticipant());
            try {
                this.rootDurableParticipant.register();
                result = true;
            }
            catch (Exception e) {
                logger.severe("registerWithDurableParent", LocalizationMessages.REG_WITH_DURABLE_FAILED_0022(this.getCoordIdPartId(this.rootDurableParticipant)));
                throw new WebServiceException(LocalizationMessages.REG_WITH_DURABLE_FAILED_0022(this.getCoordIdPartId(this.rootDurableParticipant)), e);
            }
        }
        return result;
    }

    public boolean isSubordinateCoordinator() {
        return true;
    }

    public Xid getCoordinationXid() {
        if (this.xid == null) {
            this.xid = CoordinationXid.lookupOrCreate(this.getContext().getIdentifier());
        }
        return this.xid;
    }

    private XATerminator getXATerminator() {
        if (this.xaTerminator == null) {
            this.xaTerminator = this.importTm.getXATerminator();
        }
        return this.xaTerminator;
    }

    public void beforeCompletion() {
        throw new UnsupportedOperationException("No beforeCompletion for subordinate coordinator");
    }

    public void afterCompletion(int i) {
        throw new UnsupportedOperationException("No afterCompletion for subordinate coordinator");
    }

    public int prepare(Xid xid) throws XAException {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("XAResource_prepare(xid=" + xid + ")");
        }
        int result = 0;
        result = 0;
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("XAResource_prepare", result);
        }
        return result;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("XAResource_commit(xid=" + xid + " ,onePhase=" + onePhase + ")");
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("XAResource_commit");
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("XAResource_rollback(xid=" + xid + ")");
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("XAResource_rollback");
        }
    }

    public void addRegistrant(Registrant registrant, WebServiceContext wsContext) {
        if (this.registerWithRootRegistrationService(registrant)) {
            return;
        }
        super.addRegistrant(registrant, wsContext);
        switch (registrant.getProtocol()) {
            case VOLATILE: {
                this.registerWithVolatileParent();
                break;
            }
            case DURABLE: {
                this.registerWithDurableParent();
                break;
            }
            case COMPLETION: {
                throw new UnsupportedOperationException("can not register for completion with subordinate coordinator");
            }
        }
    }

    public Registrant getRegistrant(String id) {
        Registrant result = super.getRegistrant(id);
        if (result == null && this.rootVolatileParticipant != null && this.rootVolatileParticipant.getIdValue().equals(id)) {
            result = this.rootVolatileParticipant;
        }
        if (result == null && this.rootDurableParticipant != null && this.rootDurableParticipant.getIdValue().equals(id)) {
            result = this.rootDurableParticipant;
        }
        return result;
    }

    public void removeRegistrant(String id) {
        this.forget(id);
    }

    public boolean registerWithRootRegistrationService(Registrant participant) {
        if (participant == this.rootVolatileParticipant || participant == this.rootDurableParticipant) {
            return true;
        }
        return super.registerWithRootRegistrationService(participant);
    }

    public boolean hasOutstandingParticipants() {
        return this.rootDurableParticipant != null || this.rootVolatileParticipant != null || super.hasOutstandingParticipants();
    }

    public void forget(String partId) {
        if (this.rootVolatileParticipant != null && this.rootVolatileParticipant.getIdValue().equals(partId)) {
            this.rootVolatileParticipant = null;
            if (logger.isLogging(Level.FINE)) {
                logger.fine("forget", "forgot volatile participant link to parent " + this.getCoordIdPartId(partId));
            }
            if (!this.hasOutstandingParticipants()) {
                this.forget();
            }
            return;
        }
        if (this.rootDurableParticipant != null && this.rootDurableParticipant.getIdValue().equals(partId)) {
            this.rootDurableParticipant = null;
            if (logger.isLogging(Level.FINE)) {
                logger.fine("forget", "forgot durable participant link to parent " + this.getCoordIdPartId(partId));
            }
            if (!this.hasOutstandingParticipants()) {
                this.forget();
            }
            return;
        }
        super.forget(partId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expirationGuard() {
        ATSubCoordinator aTSubCoordinator = this;
        synchronized (aTSubCoordinator) {
            return this.guardTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget() {
        ATSubCoordinator aTSubCoordinator = this;
        synchronized (aTSubCoordinator) {
            if (this.forgotten) {
                return;
            }
            this.forgotten = true;
            if (this.rootVolatileParticipant != null) {
                this.rootVolatileParticipant.forget();
                this.rootVolatileParticipant = null;
            }
            if (this.rootDurableParticipant != null) {
                this.rootDurableParticipant.forget();
                this.rootDurableParticipant = null;
            }
            CoordinationXid.forget(this.getIdValue());
            super.forget();
        }
    }

    public void beginImportTransaction() {
        Transaction currentTxn = null;
        try {
            this.importTm.recreate(this.getCoordinationXid(), this.getExpires());
        }
        catch (IllegalStateException ex) {
            String message = LocalizationMessages.IMPORT_TRANSACTION_FAILED_0028(this.getIdValue(), this.getCoordinationXid().toString());
            logger.warning("beginImportTransaction", message, ex);
            throw new WebServiceException(message, ex);
        }
        try {
            currentTxn = tm.getTransaction();
        }
        catch (SystemException ex) {
            String message = LocalizationMessages.IMPORT_TXN_GET_TXN_FAILED_0030(this.getIdValue());
            logger.warning("beginImportTransaction", message, ex);
            throw new WebServiceException(message, ex);
        }
        assert (currentTxn != null);
        this.setTransaction(currentTxn);
        tm.setCoordinationContext(this.getContext());
    }

    public void endImportTransaction() {
        if (this.transaction != null) {
            try {
                this.importTm.release(this.getCoordinationXid());
            }
            catch (Error e) {
                logger.warning("endImportTransaction", LocalizationMessages.EXCEPTION_RELEASING_IMPORTED_TRANSACTION_0029(), e);
            }
            this.setTransaction(null);
        }
    }

    public class DurableParticipant
    implements Participant {
        int xaResult = 0;

        public Protocol getProtocol() {
            return Protocol.DURABLE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Participant.STATE prepare() throws TXException {
            Participant.STATE result = Participant.STATE.P_OK;
            String METHOD = "durableParticipant";
            if (logger.isLogging(Level.FINER)) {
                logger.entering("durableParticipant", ATSubCoordinator.this.getCoordIdPartId(ATSubCoordinator.this.rootDurableParticipant));
            }
            DurableParticipant durableParticipant = this;
            synchronized (durableParticipant) {
                ATSubCoordinator.this.initiateDurablePrepare();
                if (ATSubCoordinator.this.getXATerminator() != null) {
                    try {
                        if (logger.isLogging(Level.FINER)) {
                            logger.entering("XATerminator.prepare()");
                        }
                        this.xaResult = ATSubCoordinator.this.getXATerminator().prepare(ATSubCoordinator.this.getCoordinationXid());
                        if (logger.isLogging(Level.FINER)) {
                            logger.exiting("XATerminator.prepare()", this.xaResult);
                        }
                    }
                    catch (XAException ex) {
                        ATSubCoordinator.this.setAborting();
                        if (logger.isLogging(Level.FINEST)) {
                            logger.finest("durableParticipant", LocalizationMessages.XATERM_THREW_0023(ex.getClass().getName()), ex);
                        } else {
                            logger.info("durableParticipant", LocalizationMessages.XATERM_THREW_0023(ex.getClass().getName()));
                        }
                        throw new TXException(ex.getClass().getName());
                    }
                    ATSubCoordinator.this.waitForDurablePrepareResponse();
                    if (ATSubCoordinator.this.isAborting()) {
                        this.abort();
                    } else if (this.xaResult == 3 && ATSubCoordinator.this.getDurableParticipants().size() == 0) {
                        ATSubCoordinator.this.guardTimeout = true;
                        ATSubCoordinator.this.rootDurableParticipant.readonly();
                        result = Participant.STATE.P_READONLY;
                    } else if (this.xaResult == 0) {
                        ATSubCoordinator.this.guardTimeout = true;
                        ATSubCoordinator.this.rootDurableParticipant.prepared();
                    }
                }
            }
            if (logger.isLogging(Level.FINER)) {
                logger.exiting("ATSubCoordinator.durableParticipant", ATSubCoordinator.this.getCoordIdPartId(ATSubCoordinator.this.rootDurableParticipant));
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            String METHOD = "ATSubCoordinator.DurableParticipant.commit";
            boolean xaCommitFailed = false;
            DurableParticipant durableParticipant = this;
            synchronized (durableParticipant) {
                ATSubCoordinator.this.initiateDurableCommit();
                if (ATSubCoordinator.this.getXATerminator() != null && this.xaResult == 0) {
                    try {
                        ATSubCoordinator.this.getXATerminator().commit(ATSubCoordinator.this.getCoordinationXid(), false);
                    }
                    catch (XAException ex) {
                        xaCommitFailed = true;
                        logger.severe("ATSubCoordinator.DurableParticipant.commit", LocalizationMessages.XATERM_THREW_0023(ex.getLocalizedMessage()));
                    }
                }
                if (xaCommitFailed || ATSubCoordinator.this.isAborting()) {
                    logger.severe("ATSubCoordinator.DurableParticipant.commit", LocalizationMessages.ABORT_DURING_COMMIT_0024(ATSubCoordinator.this.getIdValue()));
                    ATSubCoordinator.this.rootDurableParticipant.aborted();
                } else {
                    logger.info("ATSubCoordinator.DurableParticipant.commit", LocalizationMessages.COMMITTED_SUB_COOR_0025(ATSubCoordinator.this.getIdValue()));
                    ATSubCoordinator.this.rootDurableParticipant.committed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            String METHOD = "ATSubCoordinator.DurableParticipant.abort";
            DurableParticipant durableParticipant = this;
            synchronized (durableParticipant) {
                if (ATSubCoordinator.this.getXATerminator() != null && this.xaResult == 0) {
                    try {
                        logger.severe("ATSubCoordinator.DurableParticipant.abort", LocalizationMessages.XATERM_ABORT_0026(ATSubCoordinator.this.getIdValue()));
                        ATSubCoordinator.this.getXATerminator().rollback(ATSubCoordinator.this.getCoordinationXid());
                    }
                    catch (XAException ex) {
                        logger.severe("ATSubCoordinator.DurableParticipant.abort", LocalizationMessages.CAUGHT_XAEX_0027(ex.getMessage()));
                    }
                }
                ATSubCoordinator.this.initiateDurableRollback();
                ATSubCoordinator.this.waitForCommitOrRollbackResponse(Protocol.DURABLE);
                ATSubCoordinator.this.rootDurableParticipant.aborted();
            }
        }
    }

    public class VolatileParticipant
    implements Participant {
        public Protocol getProtocol() {
            return Protocol.VOLATILE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Participant.STATE prepare() throws TXException {
            VolatileParticipant volatileParticipant = this;
            synchronized (volatileParticipant) {
                ATSubCoordinator.this.initiateVolatilePrepare();
                ATSubCoordinator.this.waitForVolatilePrepareResponse();
                if (ATSubCoordinator.this.isAborting()) {
                    ATSubCoordinator.this.rootVolatileParticipant.aborted();
                    throw new TXException("VolatileParticipant.prepare aborted");
                }
                if (ATSubCoordinator.this.getVolatileParticipants().size() == 0) {
                    ATSubCoordinator.this.rootVolatileParticipant.readonly();
                    return Participant.STATE.P_READONLY;
                }
                ATSubCoordinator.this.rootVolatileParticipant.prepared();
                ATSubCoordinator.this.guardTimeout = true;
            }
            return Participant.STATE.P_OK;
        }

        public void commit() {
            ATSubCoordinator.this.initiateVolatileCommit();
            ATSubCoordinator.this.rootVolatileParticipant.committed();
        }

        public void abort() {
            ATSubCoordinator.this.initiateVolatileRollback();
            ATSubCoordinator.this.rootVolatileParticipant.aborted();
        }
    }
}

