/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.wsit;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.assembler.WsitClientTubeAssemblyContext;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.WSDLPolicyMapWrapper;
import com.sun.xml.ws.transport.tcp.client.ServiceChannelTransportPipe;
import com.sun.xml.ws.transport.tcp.client.TCPTransportPipe;
import com.sun.xml.ws.transport.tcp.servicechannel.stubs.ServiceChannelWSImplService;
import com.sun.xml.ws.transport.tcp.wsit.PolicyConnectionManagementSettingsHolder;
import com.sun.xml.ws.transport.tcp.wsit.TCPConstants;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class TCPTransportPipeFactory
extends com.sun.xml.ws.transport.tcp.client.TCPTransportPipeFactory {
    private static final QName serviceChannelServiceName = new ServiceChannelWSImplService().getServiceName();

    public Pipe doCreate(@NotNull ClientPipeAssemblerContext context) {
        return TCPTransportPipeFactory.doCreate(context, true);
    }

    public static Pipe doCreate(@NotNull ClientPipeAssemblerContext context, boolean checkSchema) {
        if (checkSchema && !"vnd.sun.ws.tcp".equalsIgnoreCase(context.getAddress().getURI().getScheme())) {
            return null;
        }
        TCPTransportPipeFactory.initializeConnectionManagement(context.getWsdlModel());
        if (context.getService().getServiceName().equals(serviceChannelServiceName)) {
            return new ServiceChannelTransportPipe(context);
        }
        return new TCPTransportPipe(context);
    }

    public static Tube doCreate(@NotNull WsitClientTubeAssemblyContext context, boolean checkSchema) {
        if (checkSchema && !"vnd.sun.ws.tcp".equalsIgnoreCase(context.getAddress().getURI().getScheme())) {
            return null;
        }
        TCPTransportPipeFactory.initializeConnectionManagement(context.getWsdlPort());
        int customTCPPort = TCPTransportPipeFactory.retrieveCustomTCPPort(context.getWsdlPort());
        if (context.getService().getServiceName().equals(serviceChannelServiceName)) {
            return PipeAdapter.adapt(new ServiceChannelTransportPipe(context, customTCPPort));
        }
        return PipeAdapter.adapt(new TCPTransportPipe(context, customTCPPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeConnectionManagement(WSDLPort port) {
        PolicyConnectionManagementSettingsHolder instance = PolicyConnectionManagementSettingsHolder.getInstance();
        if (instance.clientSettings == null) {
            PolicyConnectionManagementSettingsHolder policyConnectionManagementSettingsHolder = instance;
            synchronized (policyConnectionManagementSettingsHolder) {
                if (instance.clientSettings == null) {
                    instance.clientSettings = PolicyConnectionManagementSettingsHolder.createSettingsInstance(port);
                }
            }
        }
    }

    private static int retrieveCustomTCPPort(WSDLPort port) {
        try {
            PolicyMapKey endpointKey;
            PolicyMap policyMap;
            Policy policy;
            WSDLModel model = port.getBinding().getOwner();
            WSDLPolicyMapWrapper mapWrapper = model.getExtension(WSDLPolicyMapWrapper.class);
            if (mapWrapper != null && (policy = (policyMap = mapWrapper.getPolicyMap()).getEndpointEffectivePolicy(endpointKey = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName()))) != null && policy.contains(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION)) {
                for (AssertionSet assertionSet : policy) {
                    for (PolicyAssertion assertion : assertionSet) {
                        if (!assertion.getName().equals(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION)) continue;
                        String value = assertion.getAttributeValue(new QName("port"));
                        if (value == null) {
                            return -1;
                        }
                        value = value.trim();
                        try {
                            return Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            return -1;
                        }
                    }
                }
            }
            return -1;
        }
        catch (PolicyException e) {
            throw new WebServiceException(e);
        }
    }
}

