/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.testing;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.assembler.WsitClientTubeAssemblyContext;
import com.sun.xml.ws.assembler.WsitServerTubeAssemblyContext;
import com.sun.xml.ws.rm.RmRuntimeException;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.policy.ConfigurationManager;
import com.sun.xml.ws.rm.runtime.testing.PacketFilter;
import com.sun.xml.ws.rm.runtime.testing.PacketFilteringFeature;
import java.io.IOException;
import java.util.List;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PacketFilteringTube
extends AbstractFilterTubeImpl {
    private static final RmLogger LOGGER = RmLogger.getLogger(PacketFilteringTube.class);
    private final boolean isClientSide;
    private final List<PacketFilter> filters;

    public PacketFilteringTube(PacketFilteringTube original, TubeCloner cloner) {
        super(original, cloner);
        this.isClientSide = original.isClientSide;
        this.filters = original.filters;
    }

    public PacketFilteringTube(WsitClientTubeAssemblyContext context) throws RmRuntimeException {
        super(context.getTubelineHead());
        this.isClientSide = true;
        Configuration[] configurations = ConfigurationManager.createClientConfigurationManager(context.getWsdlPort(), context.getBinding()).getConfigurationAlternatives();
        this.filters = this.getConfiguredFilters(context.getBinding(), configurations != null && configurations.length > 0 ? configurations[0] : null);
    }

    public PacketFilteringTube(WsitServerTubeAssemblyContext context) throws RmRuntimeException {
        super(context.getTubelineHead());
        this.isClientSide = false;
        Configuration[] configurations = ConfigurationManager.createServiceConfigurationManager(context.getWsdlPort(), context.getEndpoint().getBinding()).getConfigurationAlternatives();
        this.filters = this.getConfiguredFilters(context.getEndpoint().getBinding(), configurations != null && configurations.length > 0 ? configurations[0] : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketFilteringTube copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            PacketFilteringTube packetFilteringTube = new PacketFilteringTube(this, cloner);
            return packetFilteringTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    @Override
    public void preDestroy() {
        super.preDestroy();
    }

    @Override
    public NextAction processRequest(Packet request) {
        if (this.isClientSide) {
            try {
                for (PacketFilter filter : this.filters) {
                    if (request != null) {
                        request = filter.filterClientRequest(request);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.logSevereException(ex);
                if (ex instanceof RuntimeException) {
                    return this.doThrow(ex);
                }
                return this.doThrow(new WebServiceException(ex));
            }
            if (request == null) {
                return this.doThrow(new WebServiceException(new IOException("Simulated IO error while sending request")));
            }
        }
        return super.processRequest(request);
    }

    @Override
    public NextAction processResponse(Packet response) {
        if (!this.isClientSide) {
            try {
                for (PacketFilter filter : this.filters) {
                    if (response != null) {
                        response = filter.filterServerResponse(response);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.logSevereException(ex);
                if (ex instanceof RuntimeException) {
                    return this.doThrow(ex);
                }
                return this.doThrow(new WebServiceException(ex));
            }
        }
        return super.processResponse(response);
    }

    private List<PacketFilter> getConfiguredFilters(WSBinding binding, Configuration configuration) {
        PacketFilteringFeature pfFeature = binding.getFeature(PacketFilteringFeature.class);
        return pfFeature.createFilters(configuration);
    }
}

