/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.testing;

import com.sun.xml.ws.api.FeatureConstructor;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.runtime.testing.PacketFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PacketFilteringFeature
extends WebServiceFeature {
    public static final String ID = "com.sun.xml.ws.rm.runtime.testing.PacketFilteringFeature";
    private static final RmLogger LOGGER = RmLogger.getLogger(PacketFilteringFeature.class);
    private final List<Class<? extends PacketFilter>> filterClasses;

    public PacketFilteringFeature() {
        this.filterClasses = Collections.emptyList();
        this.enabled = true;
    }

    public PacketFilteringFeature(boolean enabled) {
        this.filterClasses = Collections.emptyList();
        this.enabled = enabled;
    }

    public PacketFilteringFeature(Class<? extends PacketFilter> ... filterClasses) {
        this(true, filterClasses);
    }

    @FeatureConstructor(value={"enabled", "filters"})
    public PacketFilteringFeature(boolean enabled, Class<? extends PacketFilter> ... filterClasses) {
        this.enabled = enabled;
        this.filterClasses = filterClasses != null && filterClasses.length > 0 ? Collections.unmodifiableList(Arrays.asList(filterClasses)) : Collections.emptyList();
    }

    @Override
    public String getID() {
        return ID;
    }

    List<PacketFilter> createFilters(Configuration configuration) {
        ArrayList<PacketFilter> filters = new ArrayList<PacketFilter>(this.filterClasses.size());
        for (Class<? extends PacketFilter> filterClass : this.filterClasses) {
            try {
                PacketFilter filter = filterClass.newInstance();
                filter.configure(configuration);
                filters.add(filter);
            }
            catch (InstantiationException ex) {
                LOGGER.warning("Error instantiating packet filter of class [" + filterClass.getName() + "]", ex);
            }
            catch (IllegalAccessException ex) {
                LOGGER.warning("Error instantiating packet filter of class [" + filterClass.getName() + "]", ex);
            }
        }
        return filters;
    }

    boolean hasFilters() {
        return !this.filterClasses.isEmpty();
    }
}

