/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.faults.AbstractRmSoapFault;
import com.sun.xml.ws.rm.faults.CreateSequenceRefusedFault;
import com.sun.xml.ws.rm.faults.UnknownSequenceFault;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.runtime.AbstractRmServerTube;
import com.sun.xml.ws.rm.runtime.PacketAdapter;
import com.sun.xml.ws.rm.runtime.Utilities;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.v200702.AcceptType;
import com.sun.xml.ws.rm.v200702.CloseSequenceElement;
import com.sun.xml.ws.rm.v200702.CloseSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.CreateSequenceElement;
import com.sun.xml.ws.rm.v200702.CreateSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.Identifier;
import com.sun.xml.ws.rm.v200702.OfferType;
import com.sun.xml.ws.rm.v200702.TerminateSequenceElement;
import com.sun.xml.ws.rm.v200702.TerminateSequenceResponseElement;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;

final class Rm11ServerTube
extends AbstractRmServerTube {
    private static final RmLogger LOGGER = RmLogger.getLogger(Rm11ServerTube.class);

    Rm11ServerTube(Configuration configuration, Tube tubelineHead) {
        super(configuration, tubelineHead);
    }

    Rm11ServerTube(Rm11ServerTube original, TubeCloner cloner) {
        super(original, cloner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rm11ServerTube copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            Rm11ServerTube rm11ServerTube = new Rm11ServerTube(this, cloner);
            return rm11ServerTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    PacketAdapter processVersionSpecificProtocolRequest(PacketAdapter requestAdapter) throws AbstractRmSoapFault {
        if (RmVersion.WSRM11.closeSequenceAction.equals(requestAdapter.getWsaAction())) {
            return this.handleCloseSequenceAction(requestAdapter);
        }
        if (RmVersion.WSRM11.makeConnectionAction.equals(requestAdapter.getWsaAction())) {
            return this.handleMakeConnectionAction(requestAdapter);
        }
        return super.processVersionSpecificProtocolRequest(requestAdapter);
    }

    PacketAdapter handleCreateSequenceAction(PacketAdapter requestAdapter) throws CreateSequenceRefusedFault {
        CreateSequenceElement csElement = (CreateSequenceElement)requestAdapter.unmarshallMessage();
        long expirationTime = -1L;
        if (csElement.getExpires() != null && !"PT0S".equals(csElement.getExpires().getValue().toString())) {
            expirationTime = csElement.getExpires().getValue().getTimeInMillis(Calendar.getInstance()) + System.currentTimeMillis();
        }
        String offeredId = null;
        long offeredExpirationTime = -1L;
        OfferType offerElement = csElement.getOffer();
        if (offerElement != null) {
            Identifier id = offerElement.getIdentifier();
            if (id != null && this.sequenceManager.isValid(offeredId = id.getValue())) {
                throw LOGGER.logSevereException(new CreateSequenceRefusedFault(this.configuration, requestAdapter.getPacket(), LocalizationMessages.WSRM_1137_OFFERED_ID_ALREADY_IN_USE(offeredId)));
            }
            if (offerElement.getExpires() != null && !"PT0S".equals(offerElement.getExpires().getValue().toString())) {
                offeredExpirationTime = offerElement.getExpires().getValue().getTimeInMillis(Calendar.getInstance()) + System.currentTimeMillis();
            }
        }
        SecurityTokenReferenceType strType = csElement.getSecurityTokenReference();
        String receivedSctId = null;
        if (strType != null) {
            String activeSctId = requestAdapter.getSecurityContextTokenId();
            if (activeSctId == null) {
                throw LOGGER.logSevereException(new CreateSequenceRefusedFault(this.configuration, requestAdapter.getPacket(), LocalizationMessages.WSRM_1133_NO_SECURITY_TOKEN_IN_REQUEST_PACKET()));
            }
            try {
                receivedSctId = Utilities.extractSecurityContextTokenId(strType);
            }
            catch (RmException ex) {
                throw LOGGER.logSevereException(new CreateSequenceRefusedFault(this.configuration, requestAdapter.getPacket(), ex.getMessage()));
            }
            if (!activeSctId.equals(receivedSctId)) {
                throw LOGGER.logSevereException(new CreateSequenceRefusedFault(this.configuration, requestAdapter.getPacket(), LocalizationMessages.WSRM_1131_SECURITY_TOKEN_AUTHORIZATION_ERROR(receivedSctId, activeSctId)));
            }
        }
        Sequence inboundSequence = this.sequenceManager.createInboundSequence(this.sequenceManager.generateSequenceUID(), receivedSctId, expirationTime);
        if (offeredId != null) {
            this.sequenceManager.createOutboundSequence(offeredId, receivedSctId, offeredExpirationTime);
            this.sequenceManager.bindSequences(inboundSequence.getId(), offeredId);
        }
        if (!requestAdapter.hasSession()) {
            Utilities.startSession(inboundSequence.getId());
        }
        CreateSequenceResponseElement crsElement = new CreateSequenceResponseElement();
        Identifier id2 = new Identifier();
        id2.setValue(inboundSequence.getId());
        crsElement.setIdentifier(id2);
        AcceptType accept = new AcceptType();
        if (offeredId != null) {
            URI dest;
            try {
                dest = new URI(requestAdapter.getDestination());
            }
            catch (URISyntaxException e) {
                throw LOGGER.logSevereException(new CreateSequenceRefusedFault(this.configuration, requestAdapter.getPacket(), LocalizationMessages.WSRM_1129_INVALID_VALUE_OF_MESSAGE_HEADER("To", "CreateSequence", requestAdapter.getDestination())), e);
            }
            catch (NullPointerException e) {
                throw LOGGER.logSevereException(new CreateSequenceRefusedFault(this.configuration, requestAdapter.getPacket(), LocalizationMessages.WSRM_1130_MISSING_MESSAGE_HEADER("To", "CreateSequence", requestAdapter.getDestination())), e);
            }
            WSEndpointReference wsepr = new WSEndpointReference(dest, this.configuration.getAddressingVersion());
            accept.setAcksTo(wsepr.toSpec());
            crsElement.setAccept(accept);
        }
        return requestAdapter.createServerResponse(crsElement, this.configuration.getRmVersion().createSequenceResponseAction);
    }

    PacketAdapter handleCloseSequenceAction(PacketAdapter requestAdapter) throws UnknownSequenceFault {
        CloseSequenceElement closeSeqElement = (CloseSequenceElement)requestAdapter.unmarshallMessage();
        Sequence inboundSequence = this.getSequenceOrSoapFault(requestAdapter.getPacket(), closeSeqElement.getIdentifier().getValue());
        inboundSequence.close();
        CloseSequenceResponseElement closeSeqResponseElement = new CloseSequenceResponseElement();
        closeSeqResponseElement.setIdentifier(new Identifier(inboundSequence.getId()));
        PacketAdapter responseAdapter = requestAdapter.createServerResponse(closeSeqResponseElement, RmVersion.WSRM11.closeSequenceResponseAction);
        responseAdapter.appendSequenceAcknowledgementHeader(inboundSequence);
        return responseAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PacketAdapter handleTerminateSequenceAction(PacketAdapter requestAdapter) throws UnknownSequenceFault {
        TerminateSequenceElement tsElement = (TerminateSequenceElement)requestAdapter.unmarshallMessage();
        Sequence inboundSequence = this.getSequenceOrSoapFault(requestAdapter.getPacket(), tsElement.getIdentifier().getValue());
        Sequence outboundSeqence = null;
        try {
            outboundSeqence = this.sequenceManager.getBoundSequence(inboundSequence.getId());
            TerminateSequenceResponseElement terminateSeqResponse = new TerminateSequenceResponseElement();
            Identifier id = new Identifier(inboundSequence.getId());
            terminateSeqResponse.setIdentifier(id);
            String responseAction = RmVersion.WSRM11.terminateSequenceResponseAction;
            TerminateSequenceResponseElement responseObject = terminateSeqResponse;
            PacketAdapter responseAdapter = requestAdapter.createServerResponse(responseObject, responseAction);
            responseAdapter.appendSequenceAcknowledgementHeader(inboundSequence);
            PacketAdapter packetAdapter = responseAdapter;
            return packetAdapter;
        }
        finally {
            Utilities.endSessionIfExists(inboundSequence.getId());
            try {
                this.sequenceManager.terminateSequence(inboundSequence.getId());
            }
            finally {
                if (outboundSeqence != null) {
                    this.sequenceManager.terminateSequence(outboundSeqence.getId());
                }
            }
        }
    }

    PacketAdapter handleMakeConnectionAction(PacketAdapter requestAdapter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

