/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rm.RmRuntimeException;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.runtime.PacketAdapter;
import com.sun.xml.ws.rm.runtime.Utilities;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rm.v200702.AckRequestedElement;
import com.sun.xml.ws.rm.v200702.Identifier;
import com.sun.xml.ws.rm.v200702.SequenceAcknowledgementElement;
import com.sun.xml.ws.rm.v200702.SequenceElement;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class Rm11PacketAdapter
extends PacketAdapter {
    public Rm11PacketAdapter(Configuration configuration, @NotNull Packet packet) {
        super(configuration, packet);
    }

    public void appendSequenceHeader(@NotNull String sequenceId, long messageNumber) throws RmRuntimeException {
        SequenceElement sequenceHeaderElement = new SequenceElement();
        sequenceHeaderElement.setNumber(messageNumber);
        sequenceHeaderElement.setId(sequenceId);
        this.appendHeader(sequenceHeaderElement);
    }

    public void appendAckRequestedHeader(@NotNull String sequenceId) throws RmRuntimeException {
        AckRequestedElement ackRequestedElement = new AckRequestedElement();
        ackRequestedElement.setId(sequenceId);
        this.appendHeader(ackRequestedElement);
    }

    public void appendSequenceAcknowledgementHeader(@NotNull Sequence sequence) throws RmRuntimeException {
        SequenceAcknowledgementElement ackElement = new SequenceAcknowledgementElement();
        Identifier identifier = new Identifier();
        identifier.setValue(sequence.getId());
        ackElement.setIdentifier(identifier);
        List<Sequence.AckRange> ackedMessageIds = sequence.getAcknowledgedMessageIds();
        sequence.clearAckRequestedFlag();
        if (ackedMessageIds != null && !ackedMessageIds.isEmpty()) {
            for (Sequence.AckRange range : ackedMessageIds) {
                ackElement.addAckRange(range.lower, range.upper);
            }
        } else {
            ackElement.addAckRange(0L, 0L);
        }
        if (sequence.isClosed()) {
            ackElement.setFinal(new SequenceAcknowledgementElement.Final());
        }
        this.appendHeader(ackElement);
    }

    void initSequenceHeaderData() throws RmRuntimeException {
        SequenceElement sequenceElement = (SequenceElement)this.readHeaderAsUnderstood("Sequence");
        if (sequenceElement != null) {
            this.setSequenceData(sequenceElement.getId(), sequenceElement.getMessageNumber());
        }
    }

    String initAckRequestedHeaderData() throws RmRuntimeException {
        AckRequestedElement ackRequestedElement = (AckRequestedElement)this.readHeaderAsUnderstood("AckRequested");
        return ackRequestedElement != null ? ackRequestedElement.getId() : null;
    }

    public void processAcknowledgements(SequenceManager sequenceManager, String expectedAckedSequenceId) throws RmRuntimeException {
        SequenceAcknowledgementElement ackElement = (SequenceAcknowledgementElement)this.readHeaderAsUnderstood("SequenceAcknowledgement");
        if (ackElement != null) {
            if (expectedAckedSequenceId != null) {
                Utilities.assertSequenceId(expectedAckedSequenceId, ackElement.getId());
            }
            LinkedList<Sequence.AckRange> ranges = new LinkedList<Sequence.AckRange>();
            if (ackElement.getNone() == null) {
                if (!ackElement.getNack().isEmpty()) {
                    ArrayList<BigInteger> nacks = new ArrayList<BigInteger>(ackElement.getNack());
                    Collections.sort(nacks);
                    long lastLowerBound = 1L;
                    for (BigInteger nackId : nacks) {
                        if (lastLowerBound == nackId.longValue()) {
                            ++lastLowerBound;
                            continue;
                        }
                        ranges.add(new Sequence.AckRange(lastLowerBound, nackId.longValue() - 1L));
                        lastLowerBound = nackId.longValue() + 1L;
                    }
                    long lastMessageId = sequenceManager.getSequence(ackElement.getId()).getLastMessageId();
                    if (lastLowerBound <= lastMessageId) {
                        ranges.add(new Sequence.AckRange(lastLowerBound, lastMessageId));
                    }
                } else if (ackElement.getAcknowledgementRange() != null && !ackElement.getAcknowledgementRange().isEmpty()) {
                    for (SequenceAcknowledgementElement.AcknowledgementRange rangeElement : ackElement.getAcknowledgementRange()) {
                        ranges.add(new Sequence.AckRange(rangeElement.getLower().longValue(), rangeElement.getUpper().longValue()));
                    }
                }
            }
            sequenceManager.getSequence(ackElement.getId()).acknowledgeMessageIds(ranges);
        }
    }
}

